/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.ReflectionLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class, delegateTo="delegate"), @ExportLibrary(value=ReflectionLibrary.class, delegateTo="delegate")})
final class LegacyMetaObjectWrapper
implements TruffleObject {
    final Object original;
    final Object delegate;

    LegacyMetaObjectWrapper(Object original, Object delegate) {
        this.original = original;
        this.delegate = delegate;
    }

    @ExportMessage
    boolean isMetaObject() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasMetaObject(@CachedLibrary(value="this.delegate") InteropLibrary library) {
        return library.hasMetaObject(this.delegate);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMetaObject(@CachedLibrary(value="this.delegate") InteropLibrary library) throws UnsupportedMessageException {
        Object metaObject = library.getMetaObject(this.delegate);
        if (metaObject instanceof LegacyMetaObjectWrapper) {
            return metaObject;
        }
        return new LegacyMetaObjectWrapper(this.delegate, metaObject);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMetaInstance(Object instance) {
        Object unboxedInstance = instance;
        Object unboxedOriginal = this.original;
        if (unboxedInstance instanceof LegacyMetaObjectWrapper) {
            unboxedInstance = ((LegacyMetaObjectWrapper)unboxedInstance).delegate;
        }
        if (unboxedOriginal instanceof LegacyMetaObjectWrapper) {
            unboxedOriginal = ((LegacyMetaObjectWrapper)unboxedOriginal).delegate;
        }
        return unboxedInstance == this.original;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaSimpleName"), @ExportMessage(name="getMetaQualifiedName")})
    Object getLegacyMetaName(@CachedLibrary(value="this.delegate") InteropLibrary delegateInterop) {
        return delegateInterop.toDisplayString(this.delegate);
    }
}

