/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.jar.AbstractJarMojo;
import org.apache.maven.plugin.jar.JarSignVerifyMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JarSignMojo
extends AbstractMojo {
    private boolean skip;
    private File workingDirectory;
    private File basedir;
    private String finalName;
    private File jarPath;
    private String keystore;
    private String storepass;
    private String keypass;
    private String sigfile;
    private File signedjar;
    private String type;
    private String alias;
    private boolean verify;
    private boolean skipAttachSignedArtifact;
    private boolean verbose;
    private MavenProjectHelper projectHelper;
    private MavenProject project;
    private String classifier;

    public void execute() throws MojoExecutionException {
        ArtifactHandler artifactHandler;
        if (this.skip) {
            this.getLog().info((CharSequence)("Skipping JAR signing for file: " + this.getJarFile().getAbsolutePath()));
            return;
        }
        if (this.project != null && (artifactHandler = this.project.getArtifact().getArtifactHandler()) != null && !"java".equals(artifactHandler.getLanguage())) {
            this.getLog().debug((CharSequence)"Not executing jar:sign as the project is not a Java module");
            return;
        }
        JarSignVerifyMojo verifyMojo = this.createJarSignVerifyMojo();
        verifyMojo.setWorkingDir(this.workingDirectory);
        verifyMojo.setBasedir(this.basedir);
        File signedJarFile = this.signedjar != null ? this.signedjar : this.getJarFile();
        verifyMojo.setVerbose(this.verbose);
        verifyMojo.setJarPath(signedJarFile);
        if (signedJarFile.exists()) {
            verifyMojo.setErrorWhenNotSigned(false);
            verifyMojo.execute();
        }
        if (verifyMojo.isSigned()) {
            this.getLog().info((CharSequence)("JAR " + signedJarFile.getAbsoluteFile() + " is already signed. Skipping."));
            return;
        }
        this.signJar();
        if (this.verify) {
            verifyMojo.setErrorWhenNotSigned(true);
            verifyMojo.execute();
        }
    }

    protected JarSignVerifyMojo createJarSignVerifyMojo() {
        return new JarSignVerifyMojo();
    }

    File getJarFile() {
        if (this.jarPath != null) {
            return this.jarPath;
        }
        return AbstractJarMojo.getJarFile(this.basedir, this.finalName, null);
    }

    void signJar() throws MojoExecutionException {
        ArrayList<File> arguments = new ArrayList<File>();
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getJarsignerPath());
        this.addArgIf(arguments, this.verbose, "-verbose");
        this.addArgIfNotEmpty(arguments, "-keystore", this.keystore);
        this.addArgIfNotEmpty(arguments, "-storepass", this.storepass);
        this.addArgIfNotEmpty(arguments, "-keypass", this.keypass);
        this.addArgIfNotEmpty(arguments, "-signedjar", this.signedjar);
        this.addArgIfNotEmpty(arguments, "-storetype", this.type);
        this.addArgIfNotEmpty(arguments, "-sigfile", this.sigfile);
        arguments.add(this.getJarFile());
        this.addArgIf(arguments, this.alias != null, this.alias);
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            commandLine.createArgument().setValue(it.next().toString());
        }
        commandLine.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        this.createParentDirIfNecessary(this.signedjar);
        if (this.signedjar == null) {
            this.getLog().debug((CharSequence)"Signing JAR in-place (overwritting original JAR).");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executing: " + this.purgePassword(commandLine)));
        }
        InputStream inputStream = new InputStream(){

            public int read() {
                return -1;
            }
        };
        StreamConsumer outConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                JarSignMojo.this.getLog().info((CharSequence)line);
            }
        };
        final StringBuffer errBuffer = new StringBuffer();
        StreamConsumer errConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                errBuffer.append(line);
                JarSignMojo.this.getLog().warn((CharSequence)line);
            }
        };
        try {
            int result = this.executeCommandLine(commandLine, inputStream, outConsumer, errConsumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of " + this.purgePassword(commandLine) + " execution is: '" + result + "'.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("command execution failed", (Exception)((Object)e));
        }
        if (this.signedjar == null || this.skipAttachSignedArtifact) {
            return;
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "jar", this.classifier, this.signedjar);
        } else {
            this.project.getArtifact().setFile(this.signedjar);
        }
    }

    private String purgePassword(Commandline commandLine) {
        String out = commandLine.toString();
        if (this.keypass != null && out.indexOf(this.keypass) != -1) {
            out = StringUtils.replace((String)out, (String)this.keypass, (String)"******");
        }
        return out;
    }

    private void createParentDirIfNecessary(File file) {
        File fileDir;
        if (file != null && (fileDir = file.getParentFile()) != null) {
            boolean mkdirs = fileDir.mkdirs();
            this.getLog().debug((CharSequence)("mdkirs: " + mkdirs + " " + fileDir));
        }
    }

    private String getJarsignerPath() {
        return JarSignMojo.getJDKCommandPath("jarsigner", this.getLog());
    }

    private static String getJDKCommandPath(String command, Log logger) {
        String path = JarSignMojo.getJDKCommandExe(command).getAbsolutePath();
        logger.debug((CharSequence)(command + " executable=[" + path + "]"));
        return path;
    }

    private static File getJDKCommandExe(String command) {
        String fullCommand = command + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        File exe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + "/../sh", fullCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getJavaHome() + "/bin", fullCommand) : new File(SystemUtils.getJavaHome() + "/../bin", fullCommand));
        return exe;
    }

    private void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, Object value) {
        this.addArgIfNotEmpty(arguments, key, value, false);
    }

    private void addArgIfNotEmpty(List arguments, String key, Object value, boolean repeatKey) {
        if (value != null && !StringUtils.isEmpty((String)value.toString())) {
            arguments.add(key);
            StringTokenizer token = new StringTokenizer(value.toString(), ",");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                if (StringUtils.isEmpty((String)current)) continue;
                arguments.add(current);
                if (!token.hasMoreTokens() || !repeatKey) continue;
                arguments.add(key);
            }
        }
    }

    protected int executeCommandLine(Commandline commandLine, InputStream inputStream, StreamConsumer stream1, StreamConsumer stream2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine((Commandline)commandLine, (InputStream)inputStream, (StreamConsumer)stream1, (StreamConsumer)stream2);
    }

    public void setWorkingDir(File workingDir) {
        this.workingDirectory = workingDir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setSignedJar(File signedjar) {
        this.signedjar = signedjar;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setJarPath(File jarPath) {
        this.jarPath = jarPath;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setSigFile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setSkipAttachSignedArtifact(boolean skipAttachSignedArtifact) {
        this.skipAttachSignedArtifact = skipAttachSignedArtifact;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }
}

