/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.JSProxyHasPropertyNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSProxyHasPropertyNode.class)
public final class JSProxyHasPropertyNodeGen
extends JSProxyHasPropertyNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile trapFunProfile_;

    private JSProxyHasPropertyNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public boolean executeWithTargetAndKeyBoolean(Object arg0Value, Object arg1Value) {
        int state = this.state_;
        if (state != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            return this.doGeneric(arg0Value_, arg1Value, this.trapFunProfile_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private boolean executeAndSpecialize(Object arg0Value, Object arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                this.trapFunProfile_ = ConditionProfile.createBinaryProfile();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doGeneric(arg0Value_, arg1Value, this.trapFunProfile_);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[2];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doGeneric";
        if (state != 0) {
            s[1] = (byte)1;
            ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
            cached.add(Arrays.asList(this.trapFunProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSProxyHasPropertyNode create(JSContext context) {
        return new JSProxyHasPropertyNodeGen(context);
    }
}

