/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DefaultMaterializedFrame;
import java.util.Arrays;

final class DefaultVirtualFrame
implements VirtualFrame {
    private final FrameDescriptor descriptor;
    private final Object[] arguments;
    private Object[] locals;
    private byte[] tags;

    DefaultVirtualFrame(FrameDescriptor descriptor, Object[] arguments) {
        this.descriptor = descriptor;
        this.arguments = arguments;
        int size = descriptor.getSize();
        this.locals = new Object[size];
        Object defaultValue = descriptor.getDefaultValue();
        if (defaultValue != null) {
            Arrays.fill(this.locals, defaultValue);
        }
        this.tags = new byte[size];
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public MaterializedFrame materialize() {
        return new DefaultMaterializedFrame(this);
    }

    @Override
    public Object getObject(FrameSlot slot) throws FrameSlotTypeException {
        this.verifyGet(slot, FrameSlotKind.Object);
        return this.locals[DefaultVirtualFrame.getFrameSlotIndex(slot)];
    }

    @Override
    public void setObject(FrameSlot slot, Object value) {
        this.verifySet(slot, FrameSlotKind.Object);
        this.locals[DefaultVirtualFrame.getFrameSlotIndex((FrameSlot)slot)] = value;
    }

    @Override
    public byte getByte(FrameSlot slot) throws FrameSlotTypeException {
        this.verifyGet(slot, FrameSlotKind.Byte);
        return (Byte)this.locals[DefaultVirtualFrame.getFrameSlotIndex(slot)];
    }

    @Override
    public void setByte(FrameSlot slot, byte value) {
        this.verifySet(slot, FrameSlotKind.Byte);
        this.locals[DefaultVirtualFrame.getFrameSlotIndex((FrameSlot)slot)] = value;
    }

    @Override
    public boolean getBoolean(FrameSlot slot) throws FrameSlotTypeException {
        this.verifyGet(slot, FrameSlotKind.Boolean);
        return (Boolean)this.locals[DefaultVirtualFrame.getFrameSlotIndex(slot)];
    }

    @Override
    public void setBoolean(FrameSlot slot, boolean value) {
        this.verifySet(slot, FrameSlotKind.Boolean);
        this.locals[DefaultVirtualFrame.getFrameSlotIndex((FrameSlot)slot)] = value;
    }

    @Override
    public int getInt(FrameSlot slot) throws FrameSlotTypeException {
        this.verifyGet(slot, FrameSlotKind.Int);
        return (Integer)this.locals[DefaultVirtualFrame.getFrameSlotIndex(slot)];
    }

    @Override
    public void setInt(FrameSlot slot, int value) {
        this.verifySet(slot, FrameSlotKind.Int);
        this.locals[DefaultVirtualFrame.getFrameSlotIndex((FrameSlot)slot)] = value;
    }

    @Override
    public long getLong(FrameSlot slot) throws FrameSlotTypeException {
        this.verifyGet(slot, FrameSlotKind.Long);
        return (Long)this.locals[DefaultVirtualFrame.getFrameSlotIndex(slot)];
    }

    @Override
    public void setLong(FrameSlot slot, long value) {
        this.verifySet(slot, FrameSlotKind.Long);
        this.locals[DefaultVirtualFrame.getFrameSlotIndex((FrameSlot)slot)] = value;
    }

    @Override
    public float getFloat(FrameSlot slot) throws FrameSlotTypeException {
        this.verifyGet(slot, FrameSlotKind.Float);
        return ((Float)this.locals[DefaultVirtualFrame.getFrameSlotIndex(slot)]).floatValue();
    }

    @Override
    public void setFloat(FrameSlot slot, float value) {
        this.verifySet(slot, FrameSlotKind.Float);
        this.locals[DefaultVirtualFrame.getFrameSlotIndex((FrameSlot)slot)] = Float.valueOf(value);
    }

    @Override
    public double getDouble(FrameSlot slot) throws FrameSlotTypeException {
        this.verifyGet(slot, FrameSlotKind.Double);
        return (Double)this.locals[DefaultVirtualFrame.getFrameSlotIndex(slot)];
    }

    @Override
    public void setDouble(FrameSlot slot, double value) {
        this.verifySet(slot, FrameSlotKind.Double);
        this.locals[DefaultVirtualFrame.getFrameSlotIndex((FrameSlot)slot)] = value;
    }

    @Override
    public FrameDescriptor getFrameDescriptor() {
        return this.descriptor;
    }

    @Override
    public Object getValue(FrameSlot slot) {
        int slotIndex = this.getSlotIndexChecked(slot);
        return this.locals[slotIndex];
    }

    private int getSlotIndexChecked(FrameSlot slot) {
        int slotIndex = DefaultVirtualFrame.getFrameSlotIndex(slot);
        if (slotIndex >= this.tags.length && !this.resize()) {
            throw new IllegalArgumentException(String.format("The frame slot '%s' is not known by the frame descriptor.", slot));
        }
        return slotIndex;
    }

    private void verifySet(FrameSlot slot, FrameSlotKind accessKind) {
        int slotIndex = this.getSlotIndexChecked(slot);
        this.tags[slotIndex] = (byte)accessKind.ordinal();
    }

    private void verifyGet(FrameSlot slot, FrameSlotKind accessKind) throws FrameSlotTypeException {
        int slotIndex = this.getSlotIndexChecked(slot);
        byte tag = this.tags[slotIndex];
        if (accessKind == FrameSlotKind.Object ? tag != 0 : tag != accessKind.ordinal()) {
            throw new FrameSlotTypeException();
        }
    }

    private boolean resize() {
        int oldSize = this.tags.length;
        int newSize = this.descriptor.getSize();
        if (newSize > oldSize) {
            this.locals = Arrays.copyOf(this.locals, newSize);
            Arrays.fill(this.locals, oldSize, newSize, this.descriptor.getDefaultValue());
            this.tags = Arrays.copyOf(this.tags, newSize);
            return true;
        }
        return false;
    }

    private byte getTag(FrameSlot slot) {
        int slotIndex = this.getSlotIndexChecked(slot);
        return this.tags[slotIndex];
    }

    private static int getFrameSlotIndex(FrameSlot slot) {
        return slot.getIndex();
    }

    @Override
    public boolean isObject(FrameSlot slot) {
        return this.getTag(slot) == FrameSlotKind.Object.ordinal();
    }

    @Override
    public boolean isByte(FrameSlot slot) {
        return this.getTag(slot) == FrameSlotKind.Byte.ordinal();
    }

    @Override
    public boolean isBoolean(FrameSlot slot) {
        return this.getTag(slot) == FrameSlotKind.Boolean.ordinal();
    }

    @Override
    public boolean isInt(FrameSlot slot) {
        return this.getTag(slot) == FrameSlotKind.Int.ordinal();
    }

    @Override
    public boolean isLong(FrameSlot slot) {
        return this.getTag(slot) == FrameSlotKind.Long.ordinal();
    }

    @Override
    public boolean isFloat(FrameSlot slot) {
        return this.getTag(slot) == FrameSlotKind.Float.ordinal();
    }

    @Override
    public boolean isDouble(FrameSlot slot) {
        return this.getTag(slot) == FrameSlotKind.Double.ordinal();
    }
}

