/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.buffer;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.CharArrayBuffer;

public class CharRangesBuffer
extends CharArrayBuffer
implements RangesBuffer {
    public CharRangesBuffer() {
        this(16);
    }

    public CharRangesBuffer(int initialSize) {
        super(initialSize);
    }

    @Override
    public int getMinValue() {
        return 0;
    }

    @Override
    public int getMaxValue() {
        return 65535;
    }

    @Override
    public int getLo(int i) {
        return this.buf[i * 2];
    }

    @Override
    public int getHi(int i) {
        return this.buf[i * 2 + 1];
    }

    @Override
    public int size() {
        return this.length() / 2;
    }

    @Override
    public void appendRange(int lo, int hi) {
        assert (this.isEmpty() || this.leftOf(this.size() - 1, lo, hi) && !this.adjacent(this.size() - 1, lo, hi));
        this.add((char)lo);
        this.add((char)hi);
    }

    @Override
    public void insertRange(int index, int lo, int hi) {
        assert (index >= 0 && index < this.size());
        assert (index == 0 || this.leftOf(index - 1, lo, hi) && !this.adjacent(index - 1, lo, hi));
        assert (this.rightOf(index, lo, hi) && !this.adjacent(index, lo, hi));
        this.ensureCapacity(this.length + 2);
        int i = index * 2;
        System.arraycopy(this.buf, i, this.buf, i + 2, this.length - i);
        this.buf[i] = (char)lo;
        this.buf[i + 1] = (char)hi;
        this.length += 2;
    }

    @Override
    public void replaceRanges(int fromIndex, int toIndex, int lo, int hi) {
        assert (fromIndex >= 0 && fromIndex < toIndex && toIndex >= 0 && toIndex <= this.size());
        assert (fromIndex == 0 || this.leftOf(fromIndex - 1, lo, hi) && !this.adjacent(fromIndex - 1, lo, hi));
        assert (toIndex == this.size() || this.rightOf(toIndex, lo, hi) && !this.adjacent(toIndex, lo, hi));
        this.buf[fromIndex * 2] = (char)lo;
        this.buf[fromIndex * 2 + 1] = (char)hi;
        if (toIndex < this.size()) {
            System.arraycopy(this.buf, toIndex * 2, this.buf, fromIndex * 2 + 2, this.length - toIndex * 2);
        }
        this.length -= (toIndex - (fromIndex + 1)) * 2;
    }

    @Override
    public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
        assert (buffer instanceof CharRangesBuffer);
        int bulkLength = (endIndex - startIndex) * 2;
        if (bulkLength == 0) {
            return;
        }
        CharRangesBuffer o = (CharRangesBuffer)buffer;
        int newSize = o.length() + bulkLength;
        o.ensureCapacity(newSize);
        assert (o.isEmpty() || this.rightOf(startIndex, o, o.size() - 1));
        System.arraycopy(this.buf, startIndex * 2, o.getBuffer(), o.length(), bulkLength);
        o.setLength(newSize);
    }

    public CharRangesBuffer create() {
        return new CharRangesBuffer(this.buf.length);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.defaultToString();
    }
}

