/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializeCollatorNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSCollator;
import java.util.MissingResourceException;

public abstract class InitializeCollatorNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CreateOptionsObjectNode createOptionsNode;
    @Node.Child
    GetStringOptionNode getUsageOption;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetBooleanOptionNode getNumericOption;
    @Node.Child
    GetStringOptionNode getCaseFirstOption;
    @Node.Child
    GetStringOptionNode getSensitivityOption;
    @Node.Child
    GetBooleanOptionNode getIgnorePunctuationOption;

    protected InitializeCollatorNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.createOptionsNode = CreateOptionsObjectNodeGen.create(context);
        this.getUsageOption = GetStringOptionNode.create(context, "usage", new String[]{"sort", "search"}, "sort");
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, "localeMatcher", new String[]{"lookup", "best fit"}, "best fit");
        this.getNumericOption = GetBooleanOptionNode.create(context, "numeric", null);
        this.getCaseFirstOption = GetStringOptionNode.create(context, "caseFirst", new String[]{"upper", "lower", "false"}, null);
        this.getSensitivityOption = GetStringOptionNode.create(context, "sensitivity", new String[]{"base", "accent", "case", "variant"}, null);
        this.getIgnorePunctuationOption = GetBooleanOptionNode.create(context, "ignorePunctuation", false);
    }

    public abstract DynamicObject executeInit(DynamicObject var1, Object var2, Object var3);

    public static InitializeCollatorNode createInitalizeCollatorNode(JSContext context) {
        return InitializeCollatorNodeGen.create(context);
    }

    @Specialization
    public DynamicObject initializeCollator(DynamicObject collatorObj, Object localesArg, Object optionsArg) {
        try {
            JSCollator.InternalState state = JSCollator.getInternalState(collatorObj);
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            DynamicObject options = this.createOptionsNode.execute(optionsArg);
            String usage = this.getUsageOption.executeValue(options);
            String optLocaleMatcher = this.getLocaleMatcherOption.executeValue(options);
            Boolean optkn = this.getNumericOption.executeValue(options);
            String optkf = this.getCaseFirstOption.executeValue(options);
            String sensitivity = this.getSensitivityOption.executeValue(options);
            Boolean ignorePunctuation = this.getIgnorePunctuationOption.executeValue(options);
            JSCollator.initializeCollator(this.context, state, locales, usage, optLocaleMatcher, optkn, optkf, sensitivity, ignorePunctuation);
        }
        catch (MissingResourceException e) {
            throw Errors.createICU4JDataError(e);
        }
        return collatorObj;
    }
}

