/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class TreeAndListGroup
implements ISelectionChangedListener {
    private Object root;
    private Object currentTreeSelection;
    private final List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final List<IDoubleClickListener> doubleClickListeners = new ArrayList<IDoubleClickListener>();
    private final ITreeContentProvider treeContentProvider;
    private final IStructuredContentProvider listContentProvider;
    private final ILabelProvider treeLabelProvider;
    private final ILabelProvider listLabelProvider;
    private TreeViewer treeViewer;
    private TableViewer listViewer;
    private boolean allowMultiselection = false;

    public TreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, int width, int height, boolean allowMultiselection) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.allowMultiselection = allowMultiselection;
        this.createContents(parent, width, height, style);
    }

    public void aboutToOpen() {
        Object primary;
        this.currentTreeSelection = null;
        Object[] elements = this.treeContentProvider.getElements(this.root);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(primary));
        }
        this.treeViewer.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.add(listener);
    }

    protected void notifySelectionListeners(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(event);
        }
    }

    protected void notifyDoubleClickListeners(DoubleClickEvent event) {
        for (IDoubleClickListener listener : this.doubleClickListeners) {
            listener.doubleClick(event);
        }
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, width / 2, height);
        this.createListViewer(composite, width / 2, height);
        this.initialize();
    }

    protected void createListViewer(Composite parent, int width, int height) {
        int style = this.allowMultiselection ? 2 : 4;
        this.listViewer = new TableViewer(parent, 0x800 | style);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.listViewer.addSelectionChangedListener(this::notifySelectionListeners);
        this.listViewer.addDoubleClickListener(event -> {
            if (!event.getSelection().isEmpty()) {
                this.notifyDoubleClickListeners(event);
            }
        });
    }

    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, 2048);
        GridData data = new GridData(1808);
        data.widthHint = width;
        data.heightHint = height;
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Table getListTable() {
        return this.listViewer.getTable();
    }

    public IStructuredSelection getListTableSelection() {
        ISelection selection = this.listViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected void initialListItem(Object element) {
        Object parent = this.treeContentProvider.getParent(element);
        this.selectAndRevealFolder(parent);
    }

    public void selectAndRevealFolder(Object treeElement) {
        this.treeViewer.reveal(treeElement);
        StructuredSelection selection = new StructuredSelection(treeElement);
        this.treeViewer.setSelection((ISelection)selection);
    }

    public void selectAndRevealFile(Object treeElement) {
        this.listViewer.reveal(treeElement);
        StructuredSelection selection = new StructuredSelection(treeElement);
        this.listViewer.setSelection((ISelection)selection);
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getStructuredSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (selectedElement != this.currentTreeSelection) {
            this.listViewer.setInput(selectedElement);
        }
        this.currentTreeSelection = selectedElement;
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.listViewer.setContentProvider((IContentProvider)contentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setListSorter(ViewerComparator comparator) {
        this.listViewer.setComparator(comparator);
    }

    public void setRoot(Object newRoot) {
        this.root = newRoot;
        this.initialize();
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeComparator(ViewerComparator comparator) {
        this.treeViewer.setComparator(comparator);
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }
}

