/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

public class DictionaryCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "dictionaryCompoundWord";
    private CharArraySet dictionary;
    private final String dictFile;
    private final int minWordSize;
    private final int minSubwordSize;
    private final int maxSubwordSize;
    private final boolean onlyLongestMatch;
    private final boolean onlyLongestMatchIgnoreSubwords;

    public DictionaryCompoundWordTokenFilterFactory(Map<String, String> args) {
        super(args);
        this.dictFile = this.require(args, "dictionary");
        this.minWordSize = this.getInt(args, "minWordSize", 5);
        this.minSubwordSize = this.getInt(args, "minSubwordSize", 2);
        this.maxSubwordSize = this.getInt(args, "maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean(args, "onlyLongestMatch", true);
        this.onlyLongestMatchIgnoreSubwords = this.getBoolean(args, "onlyLongestMatchIgnoreSubwords", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public DictionaryCompoundWordTokenFilterFactory() {
        throw DictionaryCompoundWordTokenFilterFactory.defaultCtorException();
    }

    public void inform(ResourceLoader loader) throws IOException {
        this.dictionary = super.getWordSet(loader, this.dictFile, false);
    }

    public TokenStream create(TokenStream input) {
        if (this.dictionary == null) {
            return input;
        }
        return new DictionaryCompoundWordTokenFilter(input, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch, this.onlyLongestMatchIgnoreSubwords);
    }
}

