'       nov.bas: NEC-2 output file viewer --
'       color-coded current map using current information from NEC output file.
'
'       Written by David de Schweinitz <dave.des@metronet.com>
'       Distribute freely.  If it is useful or you have suggestions,
'       please send me e-mail.
'
'       I'll eventually integrate this as a mode of the "nv" input file
'       viewer.
'
'       This program will run with under QBasic with one minor change
'       (noted below), but it is much faster in QuickBasic.  If it's
'       too slow on a machine that does not a math co-processor, try
'       compiling it with QuickBasic 3.0.  It should run much faster.
'       Be careful running any QuickBasic 3.0 executable with graphics
'       calls while running MS Windows, however.  I've had problems with
'       major system crashes running similar programs at full-screen DOS
'       prompt under Windows.  I've had no problems with QuickBasic 4.5
'       executables (like the one distributed with this listing).  They
'       usually will not run in a window, but do fine full -screen.
'
'       If you see a bunch of % signs in the number displays, that indicates
'       that the wire parameters are too big or too small for the fixed
'       decimal format I used.  You may need to edit these lines if you want
'       to read the numbers.
'
'       Good luck and have fun!
'                                       Dave

DECLARE FUNCTION XP! (X!, y!, Z!, PHI!, THETA!)

DECLARE FUNCTION YP! (X!, y!, Z!, PHI!, THETA!)

     COMMON SHARED deg2rad
     deg2rad = 4 * ATN(1) / 180
     nuum% = 10000   '   Maximum number of wires
     DIM x1(nuum%), y1(nuum%), z1(nuum%), x2(nuum%), y2(nuum%), z2(nuum%), rad(nuum%)
     DIM NTAG%(nuum%)
     DIM curmag(nuum%), curph(nuum%)
     DIM ampshade%(15)
     CONST ESC = 27, DOWN = 80, UP = 72, LEFT = 75, RIGHT = 77
     CONST HOME = 71, ENDKEY = 79, PGDN = 81, PGUP = 73
   
     CLS
     WIDTH 80, 43
     SCREEN 9
     linecol% = 14: SLINECOL% = 15   ' 12  Line colors (changable)
     XAXISCOL% = 5: YAXISCOL% = 2: ZAXISCOL% = 7: SHEETCOL% = 8:
     ampshade%(1) = 0: ampshade%(2) = 5: ampshade%(3) = 1: ampshade%(4) = 9
     ampshade%(5) = 2: ampshade%(6) = 10: ampshade%(7) = 3: ampshade%(8) = 11
     ampshade%(9) = 4: ampshade%(10) = 12

'    If running from an interpeter insert file name here or use INPUT command.
     NECFILE$ = COMMAND$      'reads NEC input file name from command line.
     IF NECFILE$ = "" THEN
       PRINT "Usage: nv FILE, where FILE is NEC input file"
     END IF

'    This program first tries to read the file as space-delimited.  If it
'    is comma-delimited, the file is closed, re-opened and then re-read.
'    I'm sure that there must be a more elegant way to do this, but this
'    seems to work OK.
'    If you use one type exclusively you may want to edit the following
'    lines accordingly.
      
     DISTSQD = 0      ' Initialize value used to scale screen.
     OPEN NECFILE$ FOR INPUT AS #1
     n% = 0
'    Skip through:
     DO
       LINE INPUT #1, j$
     LOOP UNTIL MID$(j$, 34, 34) = "- - - - SEGMENTATION DATA - - - -"
     FOR n% = 1 TO 8: LINE INPUT #1, j$: NEXT
     n% = 0
     DO
       LINE INPUT #1, j$
       IF j$ = "" THEN EXIT DO
       n% = n% + 1
       NTAG%(n%) = VAL(MID$(j$, 95, 6))
       xc = VAL(MID$(j$, 8, 9)): yc = VAL(MID$(j$, 18, 9)): zc = VAL(MID$(j$, 28, 9))
       seglength = VAL(MID$(j$, 38, 9)): alpha = VAL(MID$(j$, 48, 10)): beta = VAL(MID$(j$, 58, 10))
       dx = seglength / 2! * COS(deg2rad * alpha) * COS(deg2rad * beta)
       dy = seglength / 2! * COS(deg2rad * alpha) * SIN(deg2rad * beta)
       dz = seglength / 2! * SIN(deg2rad * alpha)
       x1(n%) = xc - dx: y1(n%) = yc - dy: z1(n%) = zc - dz
       x2(n%) = xc + dx: y2(n%) = yc + dy: z2(n%) = zc + dz
       rad(n%) = VAL(MID$(j$, 69, 9))
       DISTSQD = x1(n%) * x1(n%) + y1(n%) * y1(n%) + z1(n%) * z1(n%)
       IF DISTSQD > height THEN height = DISTSQD
     LOOP
     nmax% = n%
     DO
       LINE INPUT #1, j$
     LOOP UNTIL MID$(j$, 30, 33) = "- - - CURRENTS AND LOCATION - - -"
     FOR n% = 1 TO 6: LINE INPUT #1, j$: NEXT
     FOR n% = 1 TO nmax%
       LINE INPUT #1, j$
       curmag(n%) = VAL(MID$(j$, 74, 11))
       curph(n%) = VAL(MID$(j$, 86, 8))
     NEXT

     CLOSE #1
     height = 1.1 * SQR(height)  'Scale display to fit input file
     XPMIN = -height / 2: YPMIN = -height / 2
    
     PHI = 320: THETA = 60
     ampref = 1!   'amplitude reference for color-keyed current map
     hn% = 1         'number of highlighted element

     LOCATE 2, 68: PRINT "AXIS LENGTH:"
     LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
     LOCATE 6, 68: PRINT " PGUP/PGDN "
     LOCATE 7, 68: PRINT "    KEYS"
     LOCATE 8, 68: PRINT "CHANGE SCALE"
     LOCATE 12, 68: PRINT " PHI THETA"
     LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
     LOCATE 16, 68: PRINT " ARROW KEYS"
     LOCATE 17, 68: PRINT "  TO ROTATE"
     LOCATE 20, 68: PRINT "2-4-6-8-0:"
     LOCATE 21, 68: PRINT " SHIFT AXES"
    
     LOCATE 24, 68: PRINT "  +/- KEY"
     LOCATE 25, 68: PRINT "TO HIGHLIGHT"
     LOCATE 26, 68: PRINT "   A WIRE:"
     LOCATE 27, 68: PRINT " DATA BELOW"
     LOCATE 31, 68: PRINT "L,S,X,Y,Z"
     LOCATE 32, 68: PRINT "CHANGE COLORS"
     LOCATE 34, 68: PRINT "  <ESC>"
     LOCATE 35, 68: PRINT "   TO"
     LOCATE 36, 68: PRINT "  QUIT"
     LOCATE 39, 1: PRINT "SEG#  TAG    X1       Y1       Z1       X2       Y2       Z2      RAD   "
   
     LOCATE 40, 1: PRINT USING "####"; hn%;
     PRINT USING " ###"; NTAG%(hn%);
     PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
     LOCATE 41, 10: PRINT "current: "; : PRINT USING "#.######"; 1000 * curmag(hn%);
     PRINT " mA "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
    
     FOR n% = 1 TO 10
       COLOR ampshade%(n%)
       LOCATE 20 - n%, 58: PRINT USING "###.###"; n% / 10 * ampref
     NEXT
     COLOR 15
    
     GOSUB newwindow
DRAWIT:
     VIEW (10, 10)-(450, 290), SHEETCOL%   ' re-draws the background
'    The XP and YP functions do the coordinate rotation
     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(height / 4, 0, 0, PHI, THETA): YP2 = YP(height / 4, 0, 0, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), XAXISCOL%
     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(0, height / 4, 0, PHI, THETA): YP2 = YP(0, height / 4, 0, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), YAXISCOL%
     XP1 = XP(0, 0, 0, PHI, THETA): YP1 = YP(0, 0, 0, PHI, THETA)
     XP2 = XP(0, 0, height / 4, PHI, THETA): YP2 = YP(0, 0, height / 4, PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), ZAXISCOL%
     FOR n% = 1 TO nmax%
       XP1 = XP(x1(n%), y1(n%), z1(n%), PHI, THETA): YP1 = YP(x1(n%), y1(n%), z1(n%), PHI, THETA)
       XP2 = XP(x2(n%), y2(n%), z2(n%), PHI, THETA): YP2 = YP(x2(n%), y2(n%), z2(n%), PHI, THETA)
       shade% = INT(10! * 1000! * curmag(n%) / ampref): IF shade% > 10 THEN shade% = 10
       linecol% = ampshade%(shade%)
       LINE (XP1, YP1)-(XP2, YP2), linecol%
     NEXT n%
     XP1 = XP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA): YP1 = YP(x1(hn%), y1(hn%), z1(hn%), PHI, THETA)
     XP2 = XP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA): YP2 = YP(x2(hn%), y2(hn%), z2(hn%), PHI, THETA)
     LINE (XP1, YP1)-(XP2, YP2), SLINECOL%

     DO
       test$ = INKEY$
     LOOP WHILE test$ = ""
     ' Convert 2-byte extended code to 1-byte ASCII code and handle
     test$ = RIGHT$(test$, 1)
     SELECT CASE test$
       CASE CHR$(PGUP) 'REDUCE SCALE
         height = 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE CHR$(PGDN) 'EXPAND SCALE
         height = 1 / 2 ^ .25 * height
         LOCATE 4, 68: : PRINT USING "#####.###"; height / 4
         XPMIN = -height / 2: YPMIN = -height / 2
         GOSUB newwindow
       CASE "6" 'move to right
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "4" 'move to left
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "8" 'move up
         yoffset = yoffset - height / 10
         GOSUB newwindow
       CASE "2" 'move down
         yoffset = yoffset + height / 10
         GOSUB newwindow
       CASE "9" 'move up and right
         yoffset = yoffset - height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "7" 'move up and left
         yoffset = yoffset - height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "3" 'move down and right
         yoffset = yoffset + height / 10
         xoffset = xoffset - height / 10
         GOSUB newwindow
       CASE "1" 'move down and left
         yoffset = yoffset + height / 10
         xoffset = xoffset + height / 10
         GOSUB newwindow
       CASE "0" 'back to origin
         xoffset = 0: yoffset = 0
         GOSUB newwindow
       CASE CHR$(RIGHT)
         PHI = PHI + 10
         IF PHI >= 360 THEN PHI = PHI - 360
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(LEFT)
         PHI = PHI - 10
         IF PHI < 0 THEN PHI = PHI + 360
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(UP)
         THETA = THETA + 10
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE CHR$(DOWN)
         THETA = THETA - 10
         LOCATE 14, 68: PRINT USING " ###"; PHI; THETA
       CASE "-"
         hn% = hn% - 1: IF hn% < 1 THEN hn% = nmax%
         LOCATE 40, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
         LOCATE 41, 10: PRINT "current: "; : PRINT USING "#.######"; 1000 * curmag(hn%);
         PRINT " milliamps at "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
       CASE "+"
         hn% = hn% + 1: IF hn% > nmax% THEN hn% = 1
         LOCATE 40, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
         LOCATE 41, 10: PRINT "current: "; : PRINT USING "#.######"; 1000 * curmag(hn%);
         PRINT " milliamps at "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
       CASE "n", "N"
         LOCATE 20, 10: INPUT "Enter segment number"; hn%
         IF hn% < 1 THEN hn% = 1
         IF hn% > nmax% THEN hn% = nmax%
         LOCATE 40, 1: PRINT USING "####"; hn%;
         PRINT USING " ###"; NTAG%(hn%);
         PRINT USING " ###.####"; x1(hn%); y1(hn%); z1(hn%); x2(hn%); y2(hn%); z2(hn%); rad(hn%)
         LOCATE 41, 10: PRINT "current: "; : PRINT USING "#.######"; 1000 * curmag(hn%);
         PRINT " milliamps at "; : PRINT USING "####.#"; curph(hn%); : PRINT " deg."
       CASE "/"
         ampref = ampref / 1.1
         FOR n% = 1 TO 10
           COLOR ampshade%(n%)
           LOCATE 20 - n%, 58: PRINT USING "###.###"; n% / 10 * ampref
         NEXT
         COLOR 15
       CASE "*"
         ampref = ampref * 1.1
         FOR n% = 1 TO 10
           COLOR ampshade%(n%)
           LOCATE 20 - n%, 58: PRINT USING "###.###"; n% / 10 * ampref
         NEXT
         COLOR 15
       CASE "l", "L"
         linecol% = linecol% + 1
         IF linecol% > 15 THEN linecol% = 0
       CASE "s", "S"
         SLINECOL% = SLINECOL% + 1
         IF SLINECOL% > 15 THEN SLINECOL% = 0
       CASE "x", "X"
         XAXISCOL% = XAXISCOL% + 1
         IF XAXISCOL% > 15 THEN XAXISCOL% = 0
       CASE "y", "Y"
         YAXISCOL% = YAXISCOL% + 1
         IF YAXISCOL% > 15 THEN YAXISCOL% = 0
       CASE "z", "Z"
         ZAXISCOL% = ZAXISCOL% + 1
         IF ZAXISCOL% > 15 THEN ZAXISCOL% = 0
       CASE "b", "B"
         SHEETCOL% = SHEETCOL% + 1
         IF SHEETCOL% > 15 THEN SHEETCOL% = 0
       CASE CHR$(ESC)
         GOTO DONE
     END SELECT
     GOTO DRAWIT

DONE:
     STOP
     END

newwindow:
     WINDOW (XPMIN + xoffset, YPMIN + yoffset)-(1.4 * height + XPMIN + xoffset, height + YPMIN + yoffset)
     RETURN
    
     END

     FUNCTION XP (X, y, Z, PHI, THETA)
'       deg2rad = ATN(1!) / 45
       XP = -X * SIN(PHI * deg2rad) + y * COS(PHI * deg2rad)
     END FUNCTION

     FUNCTION YP (X, y, Z, PHI, THETA)
'      deg2rad = ATN(1!) / 45
      YP = Z * SIN(THETA * deg2rad) - X * COS(THETA * deg2rad) * COS(PHI * deg2rad) - y * COS(THETA * deg2rad) * SIN(PHI * deg2rad)
     END FUNCTION

