;***************************************************************
;* LEONID.ASM -- Alef Null DSP CARD 4 monitor interface        *
;*							       *
;* Here are equates for services provided by DSP CARD 4        *
;* monitor.						       *
;*							       *
;* Copyright (C) 1992, 1993 by Alef Null. All rights reserved. *
;* Author(s): Jarkko Vuori, OH2LNS			       *
;* Modification(s):					       *
;***************************************************************


; Start of the user program and data areas
user_code equ	$003f
user_data equ	$0014


; Macro for target system detecting (simulator or DSP CARD 4 platform)
system	macro	target
	if @scp("target",'simulator')!=0
sim_debug
	else
	    if @scp("target",'dsp4')==0
		fail "No such system: target, known systems are dsp4 or simulator"
	    endif
	endif
	endm


; Open serial communication port (reset all buffers)
; set to KISS mode if a is zero, if a is non-zero
; enter to normal mode
opensc	macro
	jsr	<$0020
	endm


; Put a byte in x0 to the serial output
putc	macro
	jsr	<$0022
	endm


; Request a character from the serial input
; waits until character given and returns it in x0
getc	macro
_gc1	wait
	jsr	<$0024
	jcs	_gc1
	endm


; Look if there are characters waiting at the serial input
; returns C if there are no data available
;	 NC if there are data, and received data is placed to x0
lookc	macro
	jsr	<$0024
	endm


; Test if there are characters waiting at the serial input
; returns C if there are no data available
;	 NC if there are data available
tstc	macro
	jsr	<$0026
	endm


; Terminate KISS output frame
endc	macro
	jsr	<$0028
	endm


; Reject KISS output frame
rejc	macro
	jsr	<$002A
	endm


; put next bit in C to the host transmit queue
putbit	macro
	jsr	<$002C
	endm


; returns next bit to be sent in C
; returns Z if this is an end of the transmission
getbit	macro
	jsr	<$002E
	endm


; Open codec
; fs is desired sampling rate (8,9.6,16,27.42857,32,48)
opencd	macro	fs
	if @def(sim_debug)==0
	    if fs==8
		move			    #>$000000,x0
	    else
		if fs==9.6
		    move		    #>$003800,x0
		else
		    if fs==16
			move		    #>$000800,x0
		    else
			if fs==27.42857
			    move	    #>$001000,x0
			else
			    if fs==32
				move	    #>$001800,x0
			    else
				if fs==48
				    move    #>$003000,x0
				else
				    fail "Illegal sampling rate: fs"
				endif
			    endif
			endif
		    endif
		endif
	    endif
	    jsr     <$0030
	endif
	endm


; Set codecs input and output settings
HEADP	equ	$8000
LINEO	equ	$4000
SPEAKER equ	$0040

LINEI	equ	$0000
MIC	equ	$1000

ctrlcd	macro	init,reg,len,inputs,lgain,rgain,outputs,loattn,roattn
	if @def(sim_debug)==0
	    if	    (lgain>22.5)|(rgain>22.5)|(loattn>94.5)|(roattn>94.5)
	    fail 'Illegal input gain or output attenuation'
	    endif
	    move		#(inputs|$f0|(@cvi(lgain/1.5)<<8)|@cvi(rgain/1.5))<<8,x0
	    clr     a		#(outputs|(@cvi(loattn/1.5)<<8)|@cvi(roattn/1.5))<<8,x1
	    move    (reg)+
	    do	    #len,_initcs
	    if	    init
	    move		a,y:(reg)+
	    move		a,y:(reg)+
	    else
	    move		(reg)+
	    move		(reg)+
	    endif
	    move		x1,y:(reg)+
	    move		x0,y:(reg)+
_initcs
	    move    (reg)-
	endif
	endm


; Close codec
closecd macro
	jsr	<$0032
	endm


; Put byte in x0 to output port
putio	macro
	jsr	<$0036
	endm


; Wait for the given time (in seconds)
sleep	macro	time
	move		    #@cvi(time*9600.0),x0
	jsr	<$0034
_slp1	jset	#4,y:$0002,_slp1
	endm


; Macro for waiting specified amount of input data from the codec
waitblk macro	reg,buflen,blklen
	if @def(sim_debug)==0
_loop	    wait					; wait for a new sample to be received
	    move		r7,a
	    move		reg,x0
	    sub     x0,a	#>blklen*4,x0
	    jmi     <_wrap
	    cmp     x0,a				; wp - rp > threshold
	    jlo     <_loop
	    jmp     <_ok
_wrap	    move		#>buflen*4,x1
	    add     x1,a				; buffer wraparound, rp - wp + lenght > threshold
	    cmp     x0,a
	    jlo     <_loop
_ok
	else
	    movep		x:$ffe0,x:(reg)
	endif
	endm
