// fbbWDlg.h : header file
//

#if !defined(AFX_FBBWDLG_H__9BC1CA25_2D96_11D4_89A9_525400EBA61E__INCLUDED_)
#define AFX_FBBWDLG_H__9BC1CA25_2D96_11D4_89A9_525400EBA61E__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

typedef struct _REMOTE_CONFIG
{
	char	szName[16];
	char	szHostName[64];
	int		nPort;
	BOOL	bAutoConnect;
	char	szCallSign[16];
	char	szPassword[256];
} REMOTE_CONFIG;

typedef struct {
	COLORREF	color;
	char		szText[40];
} LINEINFO;

#include "afxmt.h"
#include "FileTransfer.h"	// Added by ClassView
#include "ListFiles.h"	// Added by ClassView
#include "Forward.h"	// Added by ClassView
#include "DlgBar.h"	// Added by ClassView
#include "FbbListBox.h"	// Added by ClassView
#include "EditUser.h"	// Added by ClassView
#include "EditMessage.h"	// Added by ClassView
#include "UserInfos.h"

/////////////////////////////////////////////////////////////////////////////
// CFbbWDlg dialog

class CConsoleDlg;
class CSingleWnd;
//class CMonitorDlg;
//class CAllChannelsDlg;
//class COneChannelDlg;

class CFbbWDlg : public CDialog
{
// Construction
public:
	void OnListButton(int nButton, UINT nChannel, CPoint point);
	void PactorStatus(char *pStr, int uLength);
	int m_nPactor;
	BOOL m_bPactorStatus;
	void ConsoleFocus();
	CString m_cSignature;
	BOOL m_bSignature;
	BOOL m_bPrefix;
	BOOL m_bJust;
	BOOL m_bAnsi;
	BOOL m_bBreak;
	void SendMsgData(char *szFileName, BOOL bAbort);
	BOOL m_bMessage;
	void OpenOneChannel();
	BOOL IsOpened(CWnd *);
	void SendFile(char *szFileName);
	void RequestFile(char *szFileName);
	void RequestDirectory(char *szPath);
	COLORREF ConvertColor(UINT uColorIndex);
	void SendToServer(LPCTSTR lpszText);
	CFbbWDlg(CWnd* pParent = NULL);	// standard constructor
	virtual ~CFbbWDlg();
	void MakeMD5Key(LPCTSTR lpszKey, LPCTSTR lpszPassword, LPSTR lpszBuffer);
	void RequestService(int nNumService, char *szRequest);
	void SetFont();
	void SetAnsi(BOOL bFlag);
	void SetJustification(BOOL bFlag);
	void SetBreakline(BOOL bFlag);
	void SetPrefix(BOOL bFlag);
	void SetSignature(BOOL bFlag, CString cSignature);

	CFbbWApp *m_pApp;
	CFont m_Font;

// Dialog Data
	//{{AFX_DATA(CFbbWDlg)
	enum { IDD = IDD_FBBW_DIALOG };
	CButton	m_StatusBox;
	CButton	m_MessageBox;
	CFbbListBox	m_ConnectedList;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFbbWDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
protected:
	void SendMsg();
	void SendReply(long nMsg);
	int m_nTimerDelay;
	void Connected(SOCKET hSock);
	UINT m_CurrFileLength;
	UINT m_TotalFileLength;
	afx_msg LRESULT OnRemoteDisconnect(WPARAM wParam, LPARAM lParam);
	void OnAbout();
	void OnCopyright();
	LRESULT OnNewAllChannelsMessage(int nChan, int nType, LPCSTR buf, int len, int color);
	LRESULT OnNewMsgsMessage(LPCSTR buf);
	LRESULT OnNewStatusMessage(LPCSTR buf);
	void SendMaskToServer();
	LRESULT OnNewNbcnxMessage(int nb);
	LRESULT OnNewListcnxMessage(LPCSTR buf);
	LRESULT OnCloseConsole(WPARAM wParam = 0, LPARAM lParam = 0);
	LRESULT OnCloseMonitoring(WPARAM wParam = 0, LPARAM lParam = 0);
	LRESULT OnCloseAllChannels(WPARAM wParam = 0, LPARAM lParam = 0);
	LRESULT OnCloseOneChannel(WPARAM wParam = 0, LPARAM lParam = 0);
	LRESULT OnNewMonitorMessage(LPCSTR buf, int len, int color);
	LRESULT OnNewConsoleMessage(LPCSTR buf, int len, int color);
	LRESULT OnSocketNotification(WPARAM wParam = 0, LPARAM lParam = 0);
	LRESULT OnGetHostByName(WPARAM wParam = 0, LPARAM lParam = 0);
	void SockErrMessageBox(LPCTSTR lpszText, int nErrorCode);
	void SaveRemoteConfig(int nRemote);
	void LoadRemoteConfig(int nRemote);
	HICON m_hIcon;
	CForward * m_pForward;
	CConsoleDlg * m_pConsoleDlg;
	CSingleWnd * m_pMonitorDlg;
	CSingleWnd * m_pAllChannelsDlg;
	CSingleWnd  * m_pOneChannelDlg;
	void CloseConnection();
	SOCKET OpenConnection(LPCTSTR lpszTcpAddr, int nTcpPort, int nMask);

	afx_msg void OnRemote(UINT nID);
	afx_msg void OnConfig(UINT nID);
	afx_msg void OnOptions(UINT nID);
	afx_msg BOOL OnToolTipText(UINT, NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg LRESULT OnPopMessageString(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetMessageString(WPARAM wParam, LPARAM lParam = 0L);

	// Generated message map functions
	//{{AFX_MSG(CFbbWDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnConsole();
	afx_msg void OnAllChannels();
	afx_msg void OnMonitoring();
	afx_msg void OnFilelist();
	afx_msg void OnForward();
	afx_msg void OnMessageCheck();
	afx_msg void OnStatusCheck();
	afx_msg void OnDestroy();
	afx_msg void OnClose();
	afx_msg void OnExit();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnDblclkConnectedlist();
	afx_msg void OnUpdateOnechannel(CCmdUI* pCmdUI);
	afx_msg void OnOneChannel();
	afx_msg void OnSelchangeConnectedlist();
	afx_msg void OnUpdateMonitoring(CCmdUI* pCmdUI);
	afx_msg void OnUpdateConsole(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAllchannels(CCmdUI* pCmdUI);
	afx_msg void OnDisc();
	afx_msg void OnUpdateDisc(CCmdUI* pCmdUI);
	afx_msg void OnImmediatedisc();
	afx_msg void OnUpdateImmediatedisc(CCmdUI* pCmdUI);
	afx_msg void OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);
	afx_msg void OnEnterIdle(UINT nWhy, CWnd* pWho);
	afx_msg void OnEditmessage();
	afx_msg void OnEdituser();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnSettings();
	afx_msg void OnPactorirs();
	afx_msg void OnPactoriss();
	afx_msg void OnPactorscan();
	afx_msg void OnUpdatePactorscan(CCmdUI* pCmdUI);
	afx_msg void OnUserinformation();
	afx_msg void OnUpdateUserinformation(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	void UserInformation(BOOL bForce);
	int m_nChan;
	CUserInfos * m_pUserInfos;
	int m_nPactorPort;
	void OnScan();
	void OnCho();
	HMENU m_PactorMenu;
	SOCKADDR_IN m_SockAddrIn;
	char m_HostBuffer[MAXGETHOSTSTRUCT];
	int doConnect(SOCKADDR_IN *pSockAddr);
	void ClearMessages();
	void ClearStatus();
	void DrawLine(int nID, LPDRAWITEMSTRUCT lpDI);
	void ShowMessages(int nCmd);
	void ShowStatus(int nCmd);
	void DestroyOptionsMenu();
	HMENU m_OptionMenu;
	void CreateOptionsMenu();
	void RequestOptions();
	void Options(char *pStr, int uLength);
	LINEINFO m_sUsedMem, m_sDataMem, m_sDiskFree, m_sMessages, m_sHeldMsgs, m_sPrivMsgs;
	CEditMessage * m_pEditMessage;
	CEditUser *m_pEditUser;
	int m_nPrevChan;
	void StatusString(UINT nID, CString cStr = "");
	CStatic *m_pStatusInfo;
	CString m_sParameter;
	int m_NbConnected;
	CString m_CurrentStatus;
	BOOL SetProgress(int nVal);
	BOOL StopProgress();
	BOOL StartProgress(int nMax);
	CProgressCtrl *m_pWndProgress;
	UINT m_nIDTracking;
	UINT m_nIDLastMessage;
	UINT m_nDefaultID;
	void RequestDisconnect(BOOL bImmediate);
	void UpdateControls();
	BOOL m_bConnected;
	void ChangeChannelMask();
	char * DisplayMemory(int nVal, int nUnit, char *szStr);
	char m_RemoteFileName[256];
	CListFiles *m_pListFiles;
	BOOL FileTransfer(UINT command, char *buffer, UINT uLength);
	char m_szFileName[256];
	FILE *p_Fptr;
	LRESULT OnNewMessage(WPARAM wParam, LPARAM lParam);
	int m_nMask;
	CDlgToolBar m_wndToolBar;
	CDlgStatusBar m_wndStatusBar;
	UINT m_nActiveRemoteID;
	REMOTE_CONFIG m_RemoteConfig;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio insre des dclarations supplmentaires juste au-dessus de la ligne prcdente.

#endif // !defined(AFX_FBBWDLG_H__9BC1CA25_2D96_11D4_89A9_525400EBA61E__INCLUDED_)
