/*			        impmsg.c                 */
#define                       VERSION "1.4"
/*                          DL6HAZ Jul. 1992
*             compiliert mit TC 1.5 - huge, Warnings off
*                  All Warnings ON = 108 - normal
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <sys\stat.h>

/*#define DEBUG  */          /* es werden auch keine tmpfiles geloescht */
/*#define KEYB   */          /* ermoeglich eingaben fast wie  bei einem  */
 			/* sendbefehl ueber die Tastur */

#define ShowLength 87
#define IDXLENGTH 115                   /* protfile */
#define BoxNullTime 536454000L         /*01.01.87*/
#define SFLength 104


#define AEXISTS 00		      /* es stellt sich die Frage warum */
				      /* wenn es access gibt, nicht die */
				      /* entsprechenden #define gibt ...*/


char *GetMsg();
char *GetDest();
char *genBullID();
char *upcase();
char *lcase();
char *ConvName();
char *getpath();
char *getenv();
long GetMaxBytes();
unsigned long absDat();
struct userrec *readUSRInfo();
struct userindex *getIndex();
struct SF_DIR *get_mb();


extern char *sys_errlist[];
extern long timezone = 0l;
extern int daylight = 0;
extern int _fmode;

int err_count = 0;
int BinFlag = 0;
long glob_bytecount = 0l;

unsigned char MultiBuff[10240];
unsigned crctab[256];

struct userindex {
		char call[8];
		unsigned long pos;
	      };

struct userrec {
		char Language[4];
		char LastLogin[15];
		char MyBBS[7];
		char Name[16];
		int Status;
		unsigned long ltime;
	      };

struct SF_DIR {
                int pos;
		char mb[10];
	      };


main(argc, argv)
int argc;
char *argv[];
{
int priv;
int lifetime;
int FileCount = 0;
char Call[80];
char Dest[80];
char Subject[80];
char Language[5];
char BullID[20];
char ImpPath[MAXPATH];
long pos;
long len;



FILE *imp_fp;

/*
putenv("MBSYS_DIR=D:\\MB_TEST\\MBSYS\\");
putenv("USR_DIR=D:\\MB_TEST\\USR\\");
putenv("INFO_DIR=D:\\MB_TEST\\INFO\\");
  */

/* Defaultwerte einstellen */
memset(Dest, '\0', sizeof(Dest));
memset(Subject, '\0', sizeof(Subject));
memset(BullID, '\0', sizeof(BullID));
memset(Call, '\0',  sizeof(Call));
sprintf(Language, "%s", getenv("DEFAULT_LANG"));
upcase(Language);
priv = 1;
lifetime = 32000;
BinFlag = 0;

fclose(stdprn);
fclose(stdaux);
#ifndef KEYB
  fprintf(stdout, "                              IMPMSG\n");
#endif

#ifdef KEYB
  fprintf(stdout, "                               SEND\n");
#endif


fprintf(stdout, "                            Version %s\n", VERSION);
fprintf(stdout, "                            %s\n\n", __DATE__);

#ifndef KEYB
  fprintf(stdout, "                 Import-Utilitie for THEBOX 1.9\n");
  fprintf(stdout, "                     for Text- or BinFiles!\n");
  fprintf(stdout, "          For HELP call IMPMSG without any Arguments!\n");
#endif


#ifdef DEBUG
  fprintf(stderr, "\n*** DEBUG-MODE ***\n");
#endif

init_crctab();
#ifndef KEYB
  if(argc >1){
	fprintf(stdout, "\nImport: %s\n\n", argv[1]);
        if((imp_fp = fopen(argv[1], "rt")) == NULL){
		fprintf(stderr, "%s ", argv[1]);
		perror("Importfile");
		exit(1);
	}
	setvbuf(imp_fp, NULL, _IOFBF, 10240);
	sprintf(ImpPath, "%s", getpath(argv[1]));
	sprintf(Call, "%s", getenv("OWNBBS"));
        upcase(Call);
	fseek(imp_fp, 0l, 2);
	len = ftell(imp_fp);
	fseek(imp_fp, 0l, 0);
	if(*Call != '\0')
	do{
	   SendRoutine(
	      Call, Dest, Subject,  BullID, lifetime, Language, priv, imp_fp, ImpPath);
	   memset(Dest, '\0', sizeof(Dest));
	   memset(Subject, '\0', sizeof(Subject));
	   memset(BullID, '\0', sizeof(BullID));
           BinFlag = 0;
	   lifetime = 32000;
	   pos = ftell(imp_fp);
	   FileCount++;
  	} while(len > pos+10);
	fclose(imp_fp);
        fprintf(stdout,
		"\n\nImport OK!\nMsg: %d  Bytes: %ld  Errors: %d\n\n",
						  		FileCount,
						  		glob_bytecount,
						  		err_count);
  }
  else
    help();
#endif

#ifdef KEYB
 sprintf(Call, "%s", getenv("OWNBBS"));
 upcase(Call);
 if(*Call != '\0')
  SendRoutine(Call, Dest, Subject,  BullID, lifetime, Language, priv, stdin, ImpPath);
#endif
}



SendRoutine(Call, Dest, Subject, BullID, lifetime, Lang, priv, Imp_fp, ImpPath)
unsigned char *Call;
unsigned char *Dest;
unsigned char *Subject;
char *BullID;
int lifetime;
char *Lang;
int priv;
FILE *Imp_fp;
char *ImpPath;
{
char cmd[10];
char ZielMB[80];
char ChanStr[100];
char SaveDir[80];
char TmpFilename[80];
char OrgSName[20];
char BoxSName[20];
char SendCall[20];
char RecFrom[10];
char *opt_ptr;
char ShowRec[ShowLength+1];
char *ptr;
char c;
long bytecount = 0l;
unsigned bytes;
int get_text();
int LifetimeBox;
int No;
int i;
long fp_pos;
time_t utc_secs;

struct tm *utc;
struct userrec *Record;
struct stat Stat;


FILE *Tmp_fp;
FILE *fp;
FILE *Prot_fp;

#ifndef KEYB
   *cmd = '\0';
   fscanf(Imp_fp, "%s", cmd);
   lcase(cmd);
   if((strncmp(cmd, "send", strlen(cmd))) != 0){
	fprintf(stderr, "%s %s", cmd, GetMsg(21, Lang));
	exit(1);
   }
#endif


if(*Dest == '\0'){
	fprintf(stderr, "\n%s\n", GetMsg(16, Lang));
	fgets(Dest, 80, Imp_fp);
	if(*Dest == '\n'){
	    fprintf(stderr, "%s\n", GetMsg(3, Lang));
	    exit(1);
	}
       *(Dest+strlen(Dest)-1) = '\0';
}
if(*Subject == '\0'){
	fprintf(stderr, "%s\n", GetMsg(17, Lang));
	fgets(Subject, 80, Imp_fp);
	if(*Subject == '\n'){
	    fprintf(stderr, "%s\n", GetMsg(3, Lang));
	    exit(1);
	}
        *(Subject +strlen(Subject)-1) = '\0';
}
upcase(Dest);
/* text in tmp-file abspeichern */
sprintf(ChanStr, "%sboxXXXXXX", getenv("TMP_DIR"));
sprintf(TmpFilename, "%s",  mktemp(ChanStr));
if((Tmp_fp=fopen(TmpFilename, "w")) == NULL){
     fprintf(stderr, "%s ", TmpFilename);
     perror("Tmpfile");
     exit(1);
}
/* msg-headline erstellen, vorbereiten */
if((ptr = strchr(Dest, '@')) > NULL){   /* aufteilen nach Filename, ZielMb*/
   *ptr = '\40';
   sscanf(Dest, "%s %s", OrgSName, ZielMB);
}
else{
   *ZielMB = '\0';
   sscanf(Dest, "%s", OrgSName);
}
sprintf(SendCall, "%.6s", Call);
/* find and interpre Options */
   ptr = &Dest[0]+strlen(ZielMB) + strlen(OrgSName);
   if(ptr != NULL) ptr++;
   if((opt_ptr = strchr(ptr, '#')) != NULL){
	sscanf((opt_ptr+1), "%3d", &lifetime);
    }
    if((opt_ptr = strchr(ptr, '$')) != NULL){
	sscanf((opt_ptr+1), "%13s", BullID);
    }
    if((opt_ptr = strchr(ptr, '<')) != NULL){
        sscanf((opt_ptr+1), "%6s", SendCall);
	if(isCall(SendCall) == 0)
 	     sprintf(SendCall, "%s", Call);
    }

if((ptr= ConvName(Dest)) == NULL)        /* FileName evt convertieren */
   sprintf(BoxSName, "%s", OrgSName);
else
   sprintf(BoxSName, "%s", ptr);
#ifdef DEBUG
fprintf(stderr,
"\n-----------------------------------------------------------------------\n");
fprintf(stderr, "Zeile %d:\n", __LINE__);
fprintf(stderr,
	"Call   : %-6s SendCall : %-6s BoxSn : %-8s OrgSn    : %-8s\n",
					        Call,
						SendCall,
						BoxSName,
						OrgSName);
fprintf(stderr, "ZielMB : %-6s BullID   : %-13s           lifetime : %-4d\n",
								ZielMB,
								BullID,
								lifetime);
fprintf(stderr,
"-----------------------------------------------------------------------\n");
#endif
if(isCall(BoxSName) == 0){                  /* InfoFile */
	if(*ZielMB == '\0')
            sprintf(ZielMB,"%-.8s",getenv("DEF_SF"));
	if(*BullID == '\0')
	    sprintf(BullID, "%s", genBullID());
	LifetimeBox  = getLifetime(BoxSName);
	if(lifetime != 32000){
 	     ptr = getenv("LF_FLAG");
		switch(*ptr){
			case '0': LifetimeBox = lifetime;
				  break;
			case '1': if(lifetime < LifetimeBox)
					LifetimeBox = lifetime;
				  break;
			if(priv) LifetimeBox = lifetime;
		}
	}
	sprintf(SaveDir, "%s%s", getenv("INFO_DIR"), BoxSName);
}
else{					/* UserFIle */
     if(*ZielMB == '\0'){
	if((Record = readUSRInfo(BoxSName)) != NULL){
	    sprintf(ZielMB, "%.6s", Record->MyBBS);
	}
        else
	    sprintf(ZielMB, "%s", getenv("OWNBBS"));
      }
      sprintf(SaveDir, "%s%s", getenv("USR_DIR"), BoxSName);
}
upcase(ZielMB);

#ifdef DEBUG
fprintf(stderr,
"\n-----------------------------------------------------------------------\n");
fprintf(stderr, "Zeile %d:\n", __LINE__);
fprintf(stderr,
	"Call   : %-6s SendCall : %-6s BoxSn : %-8s OrgSn       : %-8s\n",
					        Call,
						SendCall,
						BoxSName,
						OrgSName);
fprintf(stderr, "ZielMB : %-6s BullID   : %-13s           LifetimeBox : %-4d\n",
								ZielMB,
								BullID,
								LifetimeBox);
fprintf(stderr,
"-----------------------------------------------------------------------\n");
#endif

memset(ChanStr, ' ', 80);
fprintf(Tmp_fp, "\n\031%58.58s\n", ChanStr);		/* Space for Headline */
fprintf(Tmp_fp, "%-.79s\n", Subject);
if(isCall(BoxSName) == 0)					/* Info */
   fprintf(Tmp_fp, "*** Bulletin-ID: %s ***\n", BullID);
else
   fprintf(Tmp_fp, "\n");

*ChanStr = '\0';
#ifndef KEYB
  fp_pos = ftell(Imp_fp);
  fgets(ChanStr, 80, Imp_fp);
  fseek(Imp_fp, fp_pos, 0);
#endif

if(strncmp(ChanStr, "R:", 2) == 0){
   ptr = strchr(ChanStr, '@');
   while(!isalnum(*ptr++));
   ptr --;
   sscanf(ptr, "%6s", RecFrom);
   fprintf(Tmp_fp, "*** Received from %s ***\n\n", RecFrom);
}
else{
   fprintf(Tmp_fp, "\n\nde %s @ %s\n\n", SendCall, getenv("OWNBBS"));
}

/* Text in TMP-file einlesen */
fprintf(stderr, "%s %s %c%s", GetMsg(18, Lang),    /* Bitte Text eingeben */
	 	    BoxSName,
		    *ZielMB ? '@' : '\0',
		    ZielMB);
fprintf(stderr, "%s\n", GetMsg(19, Lang));

if(get_text(Tmp_fp, Imp_fp, TmpFilename, ImpPath) < 0){
	fprintf(stderr, "%s\n",GetMsg(3, Lang));
	fclose(Tmp_fp);
	#ifndef DEBUG
	 unlink(TmpFilename);
        #endif
	exit(0);
}


fseek(Tmp_fp, 0l, 2);
bytecount = ftell(Tmp_fp);
glob_bytecount += bytecount;
fseek(Tmp_fp, 3l,0);
fprintf(Tmp_fp, "%-.8s", BoxSName);
if(*ZielMB == '\0')
  fprintf(Tmp_fp, " @%-.6s", getenv("OWNBBS"));
else
  fprintf(Tmp_fp, " @%-.6s", ZielMB);
time(&utc_secs);
utc = gmtime(&utc_secs);
fseek(Tmp_fp, 20l, 0);
fprintf(Tmp_fp, "de:%-7.6s%02d.%02d.%02d %02d:%02d", SendCall,
				 	             utc->tm_mday,
					             utc->tm_mon+1,
					             utc->tm_year,
						     utc->tm_hour,
						     utc->tm_min);
if(isCall(BoxSName))
	fprintf(Tmp_fp, " %3.3s", "UTC");
else
   fprintf(Tmp_fp, " %3d", LifetimeBox);
fprintf(Tmp_fp, " %6ld Bytes", bytecount);
fclose(Tmp_fp);


sprintf(ChanStr, "%s\\protfile.dat", SaveDir);
if((Prot_fp = fopen(ChanStr, "r+")) == NULL){
    mkdir(SaveDir);
    sprintf(ChanStr, "%s\\protfile.dat", SaveDir);
    Prot_fp = fopen(ChanStr, "w");
    fclose(Prot_fp);   /* einen NullByteFile erzeugen */
    Prot_fp = fopen(ChanStr, "r+");   /* oeffnen fuer read & write */
}
sprintf(ChanStr, "%s\\", SaveDir);
mktmp(ChanStr);
upcase(ChanStr);
#ifdef DEBUG
fprintf(stderr, "\nZeile %d: %s\n", __LINE__, ChanStr);
#endif

_fmode= O_BINARY;
Tmp_fp= fopen(TmpFilename, "rb");
fp = fopen(ChanStr, "wb");
while ((bytes=fread(MultiBuff, 1, sizeof(MultiBuff), Tmp_fp)) > 0)
		  fwrite(MultiBuff, 1, bytes, fp);
fclose(Tmp_fp);
fclose(fp);
#ifndef DEBUG
 unlink(TmpFilename);
#endif
_fmode= O_TEXT;
fseek(Prot_fp, 0l, 2);  /* auf das Ende von Protfile positionieren */

 fp_pos = ftell(Prot_fp);
 fseek(Prot_fp, fp_pos, 0);
 if (fp_pos < IDXLENGTH-1) {   /* betr. nur eine unvollstaendige */
	fp_pos = 0;            /* erste Zeile - loeschen */
	fseek(Prot_fp, fp_pos, 0);
 }
 c = '\0';
 if(fp_pos > 0){
 	for( ; c != '\n' &&
        	c != '\032' &&
		ftell(Prot_fp) !=0 &&
        	c != '!'&& c != '|'; ){
        		c = (char)fgetc(Prot_fp);
			fp_pos --;
			fseek(Prot_fp, fp_pos, 0);
 	}
  	fp_pos += 2;
  	fseek(Prot_fp, fp_pos, 0);
	if(c == '!' || c == '|')
		fprintf(Prot_fp, "\n");
 }
#ifdef DEBUG
fprintf(stderr,
"-----------------------------------------------------------------------\n");
fprintf(stderr, "Zeile %d\n",  __LINE__);
fprintf(stderr, "Sendcall: %-6s Bytecount: %5ld BinFlag: %1d\n",
				SendCall, bytecount, BinFlag);
fprintf(stderr, "Subject : %s\n", Subject);
fprintf(stderr,
"-----------------------------------------------------------------------\n");
#endif
fprintf(Prot_fp,
           /*     Date    */ /*  time */
 "%s%-6.6s %2.2d.%2.2d.%2.2d %2.2d.%2.2d %6ld",
						ChanStr+strlen(SaveDir)+1,
						SendCall,
						utc->tm_mday,
						utc->tm_mon+1,
						utc->tm_year%100,
						utc->tm_hour,
						utc->tm_min,
						bytecount);


if(BinFlag)
   fprintf(Prot_fp, "  (BIN) %-70.70s!\n", Subject);
else
   fprintf(Prot_fp, "  %-76.76s!\n", Subject);
fseek(Prot_fp, 0l, 2);
No =(int)(ftell(Prot_fp)/IDXLENGTH+1)-1;
fclose(Prot_fp);

if(strcmp(ZielMB, getenv("OWNBBS")))
	Mk_SFRec(BoxSName, No, SendCall, BullID,
		 ZielMB, lifetime,OrgSName, bytecount, Lang);

if(isCall(BoxSName) == 0){
  sprintf(ChanStr, "%sbullid.txt", getenv("MBSYS_DIR"));
  fp = fopen(ChanStr, "r+");
  fseek(fp, 0l, 2);
  fp_pos = ftell(fp);
  fseek(fp, fp_pos, 0);
  c = '\0';
  if(fp_pos > 0){
	for( ; c != '\n' &&
	       c != '\032' &&
	       ftell(fp) !=0 &&
	       c != '!'&& c != '|'; ){
			c = (char)fgetc(fp);
	    		fp_pos --;
	    		fseek(fp, fp_pos, 0);
		}
		fp_pos += 2;
		fseek(fp, fp_pos, 0);
		if(c == '!' || c == '|')
			fprintf(fp, "\n");
	}

  fprintf(fp, " %-15.15s!\n", BullID);
  fclose(fp);

  memset(ShowRec+9, '.', 12);
  sprintf(ShowRec,
	 "%-6.6s%3.3s%-8.8s%4d %08lX %-6.6s %5ld",
	 SendCall,
	 " > ",
	 BoxSName,
	 No,
	 (utc_secs-BoxNullTime) /60,
	 ZielMB,
	 bytecount);
 if(BinFlag)
    sprintf(ShowRec+43, "  (BIN) %-19.19s%-12.12s%3d\n",  Subject,
	 				                  BullID,
						          LifetimeBox);
 else
    sprintf(ShowRec+43, "  %-25.25s%-12.12s%3d\n", Subject,
	 				           BullID,
						   LifetimeBox);
 for(i = 9; i < 20; i++)
    if(ShowRec[i] == ' ') ShowRec[i] = '.';
 sprintf(ChanStr, "%sshow.box", getenv("MBSYS_DIR"));
 if((fp=fopen(ChanStr, "r+")) == NULL){
          fp = fopen(ChanStr, "w");
	  fclose(fp);
	  fp=fopen(ChanStr, "r+");

 }
 fseek(fp, 0l, 2);
 fp_pos = ftell(fp);
 fseek(fp, fp_pos, 0);
 if (fp_pos < ShowLength-1) {   /* betr. nur eine unvollstaendige */
	fp_pos = 0;             /* erste Zeile - loeschen */
	fseek(fp, fp_pos, 0);
 }
 c = '\0';
 if(fp_pos > 0){
	for( ; c != '\n' &&
	       c != '\032' &&
	       ftell(fp) !=0; ){
			c = (char)fgetc(fp);
	    		fp_pos --;
	    		fseek(fp, fp_pos, 0);
		}
		fp_pos += 2;
		fseek(fp, fp_pos, 0);
	}

 fputs(ShowRec, fp);
 fclose(fp);
}  /*if iscall == 0 */
}


char *ConvName(SName)
char *SName;
{
char ChanStr[80];
char in[20];
static char out[20];

FILE *Conv_fp;


sprintf(ChanStr, "%sconvname.box", getenv("MBSYS_DIR"));
if((Conv_fp = fopen(ChanStr, "r")) != NULL)
while(fgets(ChanStr, 79, Conv_fp) != NULL){
	upcase(ChanStr);
	sscanf(ChanStr, "%s %s", in, out);
	if(strcmp(in, SName) == 0){
		out[9] = '\0';
		fclose(Conv_fp);
		return &out[0];
	}
}
fclose(Conv_fp);
return NULL;
}

int isCall(Call)
unsigned char *Call;
{
 int ok;
 int length;
 int count;
 char *uc;

 length = strlen(Call);

 /*printf("Laenge ");*/
 if((length > 2) && (length < 7))
 ok = 1;
 else ok = 0;

 if(Call[0] > 0x7F) ok = 0;

 if(ok == 1)
 {
  /*printf("Zahlen 2+3 ");*/
  if((isdigit(*(Call +1))) || (isdigit(*(Call +2)))) ok = 1;
  else ok = 0;
 }

 if(ok == 1)
 {
  /*printf("Letztes keine Zahl ");*/
  if(!isdigit(*(Call + length -1))) ok = 1;
  else ok = 0;
 }

 if(ok == 1)
 {
  /*printf("Suffix-Length ");*/
  uc = Call + length ;
  count = 0;

  do
  {
   uc -= 1;
   count++;
  }
  while((count < 5) && (isdigit(*uc) == 0));

  if(count < 5) ok = 1;
  else ok = 0;
 }

 if(ok == 1)
 {
  /*printf("Zahlen 1+2 ");*/
  uc = Call;
  if((isdigit(*uc++))&&(isdigit(*uc))) ok = 0;
  else ok = 1;
 }

 return(ok);
}





char *genBullID()
{
 time_t time_now;
 int CC;
 int OM;
 char CCC[80];
 char ChanStr[80];
 char BullID[20];
 char OldBullID[80];

 FILE *Bull_fp;
 struct tm *UTC;

 time(&time_now);
 UTC = gmtime(&time_now);
 sprintf(ChanStr,"%sbullid.txt",getenv("MBSYS_DIR"));
 Bull_fp = fopen(ChanStr, "r+");
 if (Bull_fp == NULL){
    sprintf(OldBullID,"000000000000");
    Bull_fp = fopen(ChanStr, "w");
 }
 else
    if(fgets(OldBullID, 19, Bull_fp) == NULL)
	sprintf(OldBullID,"000000000000");
 fseek(Bull_fp, 0l, 0);
 *(OldBullID+13) = '\0';
 sscanf(OldBullID + 5,"%2x",&CC);
 sscanf(OldBullID + 1,"%2d",&OM);
 if(OM != UTC->tm_mday) CC = 0;

 CC++;

 sprintf(CCC,"%2x",CC & 0x00FF);
 if(*CCC == ' ') *CCC = '0';

 sprintf(BullID,"%2d%1x%1.1d%s%s", UTC->tm_mday,
				 UTC->tm_mon+1,
				 UTC->tm_year%10,
				 CCC,
				 getenv("OWNBBS"));
 upcase(BullID);
 if(*BullID == ' ') *BullID = '0';

 fprintf(Bull_fp," %-15.15s!\n",BullID);

 fclose(Bull_fp);
 return BullID;
}


int getLifetime(Filename)
char *Filename;
{
int DefLTime;
int Lifetime;
int RubricLf;
char ChanStr[80];
char Rubric[15];

FILE *Lf_fp;

DefLTime = 7;
Lifetime = 32000;

sprintf(ChanStr, "%slifetime.box", getenv("MB_DIR"));
Lf_fp = fopen(ChanStr, "r");
while(fgets(ChanStr, 80, Lf_fp) != NULL){
        sscanf(ChanStr, "%8s %3d", Rubric, &RubricLf);
	if(strcmp(Rubric, "*") == 0) DefLTime = RubricLf;

         if(strcmp(upcase(Rubric), upcase(Filename)) == 0){
	    Lifetime = RubricLf;
	    break;
	 }
}
fclose(Lf_fp);
if (Lifetime == 32000)
    return DefLTime;
else
   return Lifetime;
}




mktmpnam(Zeile)
char *Zeile;
{
 unsigned char *c;
 static unsigned int now = 0;
 int i;

 c = Zeile + strlen(Zeile);

 srand(now++);

 for (i=0;i<6;i++)
 {
  do
   *c = (char)rand();
  while((*c < 'a') || (*c > 'z'));
  c++;
 }
 *c = '\0';
}

mktmp(Name)
char *Name;
{
 unsigned char Dummy[81];

 do
 {
  sprintf(Dummy,"%-.80s",Name);
  mktmpnam(Dummy);
 }
 while (access(Dummy, AEXISTS) == 0);
 sprintf(Name,"%s",Dummy);
}




Mk_SFRec(SName, ContPos, Call, BullID, ZielMB, Lifetime, orgname, bytecount, Lang)
char *SName;
int ContPos;
char *Call;
char *BullID;
char *ZielMB;
int Lifetime;
char *orgname;
long bytecount;
char *Lang;
{
 char ChanStr[80];
 char Zeile[SFLength+1];
 char DestStr[25];
 char *ptr;
 char LFStr[25];
 char SearchStr1[10];
 char SearchStr2[10];
 int sfw_fd;
 int bytes;
 int i;
 int found;
 int denied;
 long DTime;
 char *p;

 struct SF_DIR *sf;

 #ifdef DEBUG
   fprintf(stderr, "\nZeile %d: MK_SFREC()\n", __LINE__);
 #endif

 found = 0;
 if((Lifetime != 32000)&&(!isCall(SName)))
   sprintf(LFStr, "%d", Lifetime);
 else
   sprintf(LFStr, "    ");
 DTime=absDat();
 while(DTime >= 999) DTime -= 999;
 sprintf(Zeile,
  "%-9.9s%4d %-6.6s %-12.12s %-31.31s%4.4s%4ld%-8.8s%c",
  SName,
  ContPos,
  Call,
  BullID,
  ZielMB,
  LFStr,
  DTime,
  orgname,
  BinFlag?'|':'!'
  );
 sprintf(DestStr, "--------------------");

 for( ; ((sf = get_mb()) != NULL); )
        if(isCall(sf->mb)){
	sprintf(ChanStr, "%s%s.sfw", getenv("MBSYS_DIR"), sf->mb);
	if((sfw_fd = open(ChanStr, O_RDONLY)) > 0){
	     bytes = read(sfw_fd, MultiBuff, 2700);
             close(sfw_fd);
	     *(MultiBuff+bytes+1) = '\0';
	     upcase(MultiBuff);
	     denied = 0;

	     sprintf(SearchStr1, " *%s ", SName);
	     sprintf(SearchStr2, "\n*%s ", SName);
	     if(strstr(MultiBuff, SearchStr1) != NULL ||
                strstr(MultiBuff, SearchStr2) != NULL ||
		strncmp(MultiBuff, SearchStr1+1, strlen(SearchStr1+1)) == 0)
								 denied = 1;

              sprintf(ChanStr, "%s", ZielMB);
	      for(ptr = &ChanStr[0];
		 (*ptr != '\0')&&(*ptr != '.')&&(*ptr != ' ');
		  ptr++);
	      *ptr = '\0';
	      sprintf(SearchStr1, " ~%.10s ", ChanStr);
	      sprintf(SearchStr2, "\n~%.10s ", ChanStr);
	      if(strstr(MultiBuff, SearchStr1) != NULL ||
                 strstr(MultiBuff, SearchStr2) != NULL ||
		 strncmp(MultiBuff, SearchStr1+1, strlen(SearchStr1+1)) == 0)
						                    denied = 1;
	      if(denied == 0){   /* keine Sperre */
	        sprintf(ChanStr, "%s", ZielMB);
	        for(ptr = &ChanStr[0];
		  (*ptr != '\0')&&(*ptr != '.')&&(*ptr != ' ');
		   ptr++);
		*ptr = '\0';
                for(i=strlen(ChanStr)-1; i >= 0 && found == 0; i--){
		   sprintf(SearchStr1, " %.10s ", ChanStr);
		   sprintf(SearchStr2, "\n%.10s ", ChanStr);
		    if(strstr(MultiBuff, SearchStr1)||
		      strstr(MultiBuff, SearchStr2)||
		      strncmp(MultiBuff,SearchStr1+1,strlen(SearchStr1+1))==0){
		      	  found = 1;

			  if(bytecount > GetMaxBytes(sf->mb))
			     *(DestStr+sf->pos) = '+';
		      	  else
		             *(DestStr+sf->pos) = 'X';
		     }  /* if str... */
		     *(ChanStr+i) = '?';
		     *(ChanStr+i+1) = '\0';
       		}  /* for strlen ...*/
	      }/* if !denied ...*/
	  } /* if sfw_fd > 0*/
 }  /* if d.d_ino .... */

 if(found == 0){
    write_sf("????????????????????", Zeile);
    fprintf(stderr, "%s\n", GetMsg(59, Lang));
 }
 else{
    write_sf(DestStr, Zeile);
    fprintf(stderr, "%s %s @%s\n", GetMsg(2, Lang), SName, ZielMB);
 }
}


struct SF_DIR *get_mb()
{
 char ChanStr[80];
 static long pos = 0;
 static struct SF_DIR sf;
 static count = 0;

 FILE *fp;


 sprintf(ChanStr, "%ssf-liste.sfw", getenv("MBSYS_DIR"));
 if((fp=fopen(ChanStr, "r")) == NULL){
	perror("get_mb(): sf-liste.sfw");
	exit(1);
  }
  memset(&sf, '\0', sizeof(struct SF_DIR));
  fseek(fp, 46*pos, 0);
  if(fgets(ChanStr, 50, fp) == NULL || pos == 20l){
		pos = 0;
		fclose(fp);
		return NULL;

  }
  sscanf(ChanStr, "%s", sf.mb);
  sf.pos = (int)pos++;

 fclose(fp);
 return &sf;
}


write_sf(DestStr, Zeile)
char *DestStr;
char *Zeile;
{
 char ChanStr[80];
 long fp_pos;
 char c = '\0';


 FILE *SFW_fp;

 sprintf(ChanStr, "%slogsfw.box", getenv("MBSYS_DIR"));
 #ifdef DEBUG
   fprintf(stderr,
   "-----------------------------------------------------------------------\n");
   fprintf(stderr, "Zeile %d:\n", __LINE__);
   fprintf(stderr, "%s%.40s\n", DestStr, Zeile);
   fprintf(stderr, "%s\n", Zeile+34);
   fprintf(stderr,
   "-----------------------------------------------------------------------\n");
 #endif
 if((SFW_fp= fopen(ChanStr, "r+")) == NULL){
 	if((SFW_fp= fopen(ChanStr, "w")) == NULL){
	   fprintf(stderr, "%s ", ChanStr);
	   perror("LOGSFW.BOX");
	   exit(1);
 	}
	fclose(SFW_fp);
	SFW_fp = fopen(ChanStr, "r+");
  }
  if(SFW_fp != NULL){
	fseek(SFW_fp, 0l, 2);    /* Dateiende suchen */
	fp_pos = ftell(SFW_fp);
	fseek(SFW_fp, fp_pos, 0);
	if (fp_pos < SFLength-1) {   /* betr. nur eine unvollstaendige */
		fp_pos = 0;          /* erste Zeile - loeschen */
		fseek(SFW_fp, fp_pos, 0);
	}
	if(fp_pos > 0){
		for( ; c != '\n' &&
		       c != '\032' &&
		       ftell(SFW_fp) !=0 &&
		       c != '!'&& c != '|'; ){
            		c = (char)fgetc(SFW_fp);
	    		fp_pos --;
	    		fseek(SFW_fp, fp_pos, 0);
		}
		fp_pos += 2;
		fseek(SFW_fp, fp_pos, 0);
		if(c == '!' || c == '|')
			fprintf(SFW_fp, "\n");
	}
	fprintf(SFW_fp, "%s%s\n", DestStr, Zeile);   /* wegschreiben */
        fclose(SFW_fp);
  }
}


long GetMaxBytes(SF_MB)
char *SF_MB;
{
char ChanStr[80];
char dummy[20];
long MaxBytes = 0x7FFFFFFFl;

FILE *cfg_fp;


sprintf(dummy, "%s", SF_MB);
*(strchr(dummy, '.')) = '\0';
sprintf(ChanStr, "%s/%s.cfg", getenv("MBSYSDIR"), dummy);
if((cfg_fp = fopen(ChanStr, "r")) != NULL){
   fgets(ChanStr, 79, cfg_fp);
   sscanf(ChanStr, "%ld", &MaxBytes);
   MaxBytes *= 1024l;
   fclose(cfg_fp);
}
return MaxBytes;
}



/*
 * Convert a string to upper case.
 */
char *
upcase(s)
char *s;
{
	register char *p, c;

	for(p = s; c = *p; p++)
		if((c >= 'a') && (c <= 'z'))
			*p = c + 'A' - 'a';
	return(s);
}


/*
 * Convert a string to lower case.
 */
char *
lcase(s)
char *s;
{
	register char *p, c;

	for(p = s; c = *p; p++)
		if((c >= 'A') && (c <= 'Z'))
			*p = c + 'a' - 'A';
	return(s);
}







struct userrec *readUSRInfo(Call)
char *Call;
{
 struct userindex *Index;
 static struct userrec Record, *RecPtr;

 if((Index = (struct userindex *)getIndex(Call)) > NULL)
 {
  RecPtr = &Record;
  memset(RecPtr, '\0', sizeof(struct userrec));
  getRecord(Index, RecPtr);
  RecPtr->Status &= 0x7F;
  return RecPtr;
 }
 else return NULL;
}





struct userindex *getIndex(call)
char *call;
{
 int found,IFile;
 struct userindex *USRIDX;
 char dummycall[10], ChanStr[80];
 int Count,Menge;

 sprintf(dummycall,"%-6.6s",call);
 found  = 0;
 Menge  = 12000;

 sprintf(ChanStr,"%suser3.idx",getenv("MBSYS_DIR"));
 if((IFile = open(ChanStr,O_RDWR|O_BINARY)) == -1){
	perror("IFile");
	return NULL;
 }

 do{
      Menge = read(IFile,MultiBuff,10200);
      Count = Menge;
      if(Menge >= 12){
         USRIDX = (struct userindex *)MultiBuff;
         while((Count > 0) && (found == 0)){
	       if(strncmp(USRIDX->call, dummycall,6) == 0){
                  found = 1;
                  close(IFile);
                  return USRIDX;
               }
               USRIDX++;
               Count -= 12;
         }
      }
 } while((found == 0) && (Menge == 10200));
 close(IFile);
 return NULL;
}


getRecord(Index, Record)
struct userindex *Index;
struct userrec *Record;
{
 int UserFile;
 char ChanStr[80];

 sprintf(ChanStr,"%s/user3.dat", getenv("MBSYS_DIR"));

 do
  UserFile = open(ChanStr, O_RDWR|O_BINARY);
 while(UserFile == -1);

 lseek(UserFile,Index->pos,0);
 read(UserFile, Record, sizeof(struct userrec));
 if(strncmp(Record->MyBBS, "OwnBBS",6) == 0)
  			sprintf(Record->MyBBS, "%s", getenv("OWNBBS"));
 upcase(Record->MyBBS);
 close(UserFile);

}





char *GetMsg(MsgNo, Lang)
int MsgNo;
char *Lang;
{
int i;

char Filename[80];
static char msg[255];

FILE *stream;

sprintf(Filename, "%s/msg%s.box", getenv("MBSYS_DIR"), Lang);
stream = fopen(Filename, "r");
if(stream != NULL){
  for (i = 1; (fgets(msg, 255, stream) != NULL)&&(i != MsgNo); i++);
  fclose(stream);
  *(msg+strlen(msg)-1) = '\0';
  return (&msg[0]);
}
perror("GetMsg");
return NULL;
}


help()
{
fprintf(stdout, "\n                         *** HELP ***\n\n");
fprintf(stdout, "Auruf: impmsg <Importfile>\n\n");
fprintf(stdout, "Der Importfile solte folgendermassen aufgebaut sein:\n");
fprintf(stdout, "----------------------------------------------------\n");
fprintf(stdout, "s Call @ZielMB <Options>\n");
fprintf(stdout, "Titel\n");
fprintf(stdout, "\nNun kommt der Text!\n");
fprintf(stdout, "\n<eol>***END<eol>, <eol>#BIN##BinFilename<eol>\n");
fprintf(stdout, "<eol>#TXT##TextFilename<eol>\n");
fprintf(stdout, "-----------------------------------------------------\n");
fprintf(stdout, "#BIN##BinFilename ist der Befehl zum Import eines Binaerfiles.\n");
fprintf(stdout, "#BIN##TextFilename ist der Befehl zum Import eines Textfiles.\n");
fprintf(stdout, "\nCall: Call oder Rubirk.\n");
fprintf(stdout, "@ZielMB muss nicht mit angeben werden!\n");
fprintf(stdout, "\nOptions: $BullID #Lifetime <Call.\n");
fprintf(stdout, "Jede Option muss durch ein Blank (Zwischenraum) vom vorherigen Block getrennt\n");
fprintf(stdout, "werden!\n");

exit(0);

}


int Schaltjahr(Jahr)
unsigned int Jahr;
{
 if(Jahr % 4 == 0 && Jahr % 100 != 0 || Jahr % 400 == 0) return(1);
 return(0);
}



unsigned long absDat()
{
 struct tm *utc;
 time_t utc_secs;
 unsigned long  NumJahr;
 unsigned long  result;
 unsigned int   Mon;
	  int   i;


 time(&utc_secs);
 utc=gmtime(&utc_secs);

 NumJahr = (long)utc->tm_year + 1900;
 for (i=1987,result=0L;i<NumJahr;i++)
 {
  if(Schaltjahr(i)) result += 366;
  else result += 365;
 }

 for(i=1; i < utc->tm_mon+1; i++)
 {
  switch(i)
  {
   case  1:
   case  3:
   case  5:
   case  7:
   case  8:
   case 10:
   case 12: Mon = 31;
 	    break;
   case  2: if(Schaltjahr((unsigned int)NumJahr)) Mon = 29; else Mon = 28;
   	    break;
   default: Mon = 30;
 	    break;
  }
  result += Mon;
 }

 result  += utc->tm_mday;

 return(result - 1);
}



int get_text(Tmp_fp, Imp_fp, TmpFilename, ImpPath)
FILE *Tmp_fp;
FILE *Imp_fp;
char *TmpFilename;  /* wird fuer Umchalten BIN / Text benoetigt */
char *ImpPath;
{
unsigned get_bin();
unsigned crc;
char *ptr;
char ChanStr[80];
char BinFilename[80];
char TXT_Filename[80];


long bytecount = 0l;
long TmpCRCPos;
long len;

FILE *bin_fp;
FILE *txt_fp;

int found;
int bytes;

ptr = &MultiBuff[0];
memset(MultiBuff, '\0', sizeof(MultiBuff));
for( ; ; ){
        found = 0;
	if((*ptr = (char)getc(Imp_fp)) > '\0' || *ptr == -1) bytecount++;
	if((*ptr == '\032')||(*ptr == '\04')||feof(Imp_fp)){
	    if(bytecount == 1l){
		return (-1);
	    }
	    else{
                fwrite(MultiBuff, 1, strlen(MultiBuff)-1, Tmp_fp);
    	        memset(MultiBuff, '\0', sizeof(MultiBuff));
		ptr = &MultiBuff[0];
                fputc('\n', Tmp_fp);
		break;
	    }
	}

        if(*ptr == '\n'){
                /*   ***END */
		if(strncmp(MultiBuff, "***END\n", 7) == 0 ||
                   strncmp(MultiBuff, "***end\n", 7) == 0){
			if(bytecount == 7l){
			    return (-1);
	    		}
	    		else{
                            fwrite(MultiBuff, 1, strlen(MultiBuff)-7, Tmp_fp);
    	                    memset(MultiBuff, '\0', sizeof(MultiBuff));
		            ptr = &MultiBuff[0];
			    fputc('\n', Tmp_fp);
			    break;
                        }
		}   /* ***END */

               /* BINAER */
               if(strncmp(MultiBuff, "#BIN##", 6) == 0 ||
                  strncmp(MultiBuff, "#bin##", 6) == 0){
		     found = 1;
		     sscanf(MultiBuff+6, "%s", BinFilename);
                     if(*(MultiBuff+6+strlen(BinFilename)) != '\n' ||
			strlen(BinFilename) == 0){
			   fwrite(MultiBuff, 1, strlen(MultiBuff), Tmp_fp);
			   memset(MultiBuff, '\0', sizeof(MultiBuff));
			   ptr = &MultiBuff[0];
			   continue;
  		     }
		     fputc('\n', Tmp_fp);
		     fclose(Tmp_fp);
		     _fmode = O_BINARY;
                    if((bin_fp = fopen(BinFilename, "rb")) == NULL){
                         sprintf(ChanStr, "%s%s", ImpPath, BinFilename);
			 if((bin_fp = fopen(ChanStr, "rb")) == NULL){
				perror("Binfile");
				err_count++;
				_fmode = O_TEXT;
                                Tmp_fp = fopen(TmpFilename, "r+t");
				fseek(Tmp_fp, 0l, 2);
				break;
                            }
		   }
		   BinFlag = 1;
		   Tmp_fp=fopen(TmpFilename, "r+b");
		   fseek(Tmp_fp, 0l, 2);
                   fseek(bin_fp, 0l, 2);
	           len = ftell(bin_fp);
		   fprintf(stderr, "\n#BIN#%ld#%s\n\n", len, BinFilename);
                   fprintf(Tmp_fp, "#BIN#%ld#|", len);
                   TmpCRCPos = ftell(Tmp_fp);
		   fprintf(Tmp_fp, "65535\r");
		   crc = get_bin(Tmp_fp, bin_fp);
                   fseek(Tmp_fp, TmpCRCPos, 0);
		   fprintf(Tmp_fp, "%5.5u", crc);
		   fprintf(stderr, "#OK#%u\n\n", crc);
		   fclose(bin_fp);
		   fclose(Tmp_fp);
                   _fmode = O_TEXT;
		   Tmp_fp = fopen(TmpFilename, "r+t");
		   fseek(Tmp_fp, 0l,2);
                   break;
	           }   /* #BIN## */

		   /*  TEXT */
                   if(strncmp(MultiBuff, "#TXT##", 6) == 0 ||
                      strncmp(MultiBuff, "#txt##", 6) == 0){
                         found = 1;
		         sscanf(MultiBuff+6, "%s", TXT_Filename);
                         if(*(MultiBuff+6+strlen(TXT_Filename)) != '\n' ||
			    strlen(TXT_Filename) == 0){
			      fwrite(MultiBuff, 1, strlen(MultiBuff), Tmp_fp);
			      memset(MultiBuff, '\0', sizeof(MultiBuff));
			      ptr = &MultiBuff[0];
			      continue;
  		         }
                         if((txt_fp = fopen(TXT_Filename, "rt")) == NULL){
                             sprintf(ChanStr, "%s%s", ImpPath, TXT_Filename);
			     if((txt_fp = fopen(ChanStr, "r")) == NULL){
				perror("txt_file");
				err_count++;
				break;
                             }
		         }
		         fseek(txt_fp, 0l, 2);
	                 len = ftell(txt_fp);
			 fseek(txt_fp, 0l, 0);
			 fprintf(stderr, "\n#TXT#%ld#%s\n\n", len, TXT_Filename);
                         while ((bytes=fread(MultiBuff, 1,
				             sizeof(MultiBuff), txt_fp)) > 0)
		                 fwrite(MultiBuff, 1, bytes, Tmp_fp);
			fprintf(stderr, "#OK#\n\n");
			fclose(txt_fp);
		        break;
                   } /* #TXT## */

                   /*  DEFAULT */
		   if(found == 0){
		       fwrite(MultiBuff, 1, strlen(MultiBuff), Tmp_fp);
		       memset(MultiBuff, '\0', sizeof(MultiBuff));
		       ptr = &MultiBuff[0];
                   }

	}   /* if Cr or Lf */
	else{
	       /* fputc(*ptr, stdout); */
		ptr++;
	}

}

return 1;
}




/*
 *   CCITT Polynom x^16 + x^12 + x^5 + 1
 *
 *   hier im Gegensatz zu CCITT, (A)X.25:
 *     - Datenbyte MSB zuerst
 *     - CRC-Start mit 0
 *     - keine Multiplikation Nachricht mit x^16
 *       (CRC wird bei Empfang nicht ueber CRC-Bytes berechnet)
 *     - kein Invertieren des CRC
 *
 *   wird z.B. benutzt von:  UoSat DCE, SEVEN
 */

 /* unsigned crctab[256];*/
/*  unsigned crc;  */
/*unsigned byte; */       /* Datenbyte, high Byte = 0 ! */



/*
 *   entweder beim Programmstart einmal aufrufen,
 *   oder die 512 Byte Tabelle einmal ausrechnen lassen und dann als
 *   initialisierte Tabelle ins Programm uebernehmen
 */

init_crctab()
  {
    unsigned n;
    unsigned m;
    unsigned r;
    unsigned mask;

    static unsigned bitrmdrs[] = { 0x9188,0x48C4,0x2462,0x1231,
                                   0x8108,0x4084,0x2042,0x1021  };

    for (n = 0; n < 256; ++n)
      {
        for (mask = 0x0080, r = 0, m = 0; m < 8; ++m, mask >>= 1)
          if (n & mask) r = bitrmdrs[m] ^ r;
/*
 *       "if (n & mask) r ^= bitrmdrs[m];"  ist kuerzer, aber Turbo C fuer
 *       den Atari ST, Version 1.0, uebersetzt das falsch
 */
        crctab[n] = r;
      }
  }



/*
 *   byteweiser Algorithmus, C, portabel
 */
          /*
void do_crc(void)
  {
    crc = crctab[crc >> 8] ^ (crc << 8 | byte);
  }
            */


 unsigned get_bin(tmp_fp, bin_fp)
 FILE *tmp_fp;
 FILE *bin_fp;
 {
  unsigned byte;
  unsigned crc = 0;
  long bytecnt;


   fseek(bin_fp, 0l, 0);
    for (bytecnt = 0l; (byte = fgetc(bin_fp)) != -1; bytecnt++){
	  crc = crctab[crc >> 8] ^ ((crc << 8) | byte);
	  fputc(byte, tmp_fp);
  }

  return crc;
 }

char *getpath(Filename)
char *Filename;
{
 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char ext[MAXEXT];
 char name[MAXFILE];
 static char Path[MAXPATH];

 fnsplit(Filename, drive, dir, name, ext);
 sprintf(Path, "%s%s", drive, dir);

 return &Path[0];
}