
 {

   Clusse configuration utility

   (c) 1996 Heikki Hannikainen, OH7LZB

   hessu@pspt.fi

 }

Program Setup;

{$X+,S-}
{$M 16384,8192,655360}

{
    StdDlg    - Open file browser, change directory tree.
    MsgBox    - Simple dialog to display messages.
    ColorSel  - Color customization.
    Gadgets   - Shows system time and available heap space.
    Calc      - Desktop calculator.
    HelpFile  - Context sensitive help.
    MouseDlg  - Mouse options dialog.
    Editors   - Text Editor object.
}

Uses
  Dos, Objects, Drivers, Memory, Views, Menus, Dialogs, StdDlg, HistList,
  MsgBox, App, DemoCmds, Gadgets, Calc,

  Setform, ConfFile, s_User, s_UGroup, s_Adm, s_Exp, s_Conv, s_Scr,
  s_Snd,

  HelpFile, SetHelp, ColorSel, MouseDlg, Editors;

Const
  HeapSize = 128 * (1024 div 16);  { Save 48k heap for main program }

  Version      = 'v0.03';
  CluVersion   = 'v0.31';

Var
  ClipWindow: PEditWindow;

Type

  { TTVDemo }

  PTVDemo = ^TTVDemo;
  TTVDemo = object(TApplication)
    Clock: PClockView;
    Heap: PHeapView;
    constructor Init;
    destructor Done; virtual;
    procedure FileOpen(WildCard: PathStr);
    function OpenEditor(FileName: FNameStr; Visible: Boolean): PEditWindow;
    procedure GetEvent(var Event: TEvent); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure OutOfMemory; virtual;
    procedure About; virtual;
  end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

function CalcHelpName: PathStr;
var
  EXEName: PathStr;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
begin
  if Lo(DosVersion) >= 3
    then EXEName := ParamStr(0)
    else EXEName := FSearch('SETUP.EXE', GetEnv('PATH'));
  FSplit(EXEName, Dir, Name, Ext);
  if Dir[Length(Dir)] = '\' then Dec(Dir[0]);
  CalcHelpName := FSearch('SETUP.HLP', Dir);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTvDemo.About;
var
  D: PDialog;
  Control: PView;
  R: TRect;
begin
  R.Assign(0, 0, 40, 11);
  D := New(PDialog, Init(R, 'About'));
  with D^ do
  begin
    Options := Options or ofCentered;

    R.Grow(-1, -1);
    Dec(R.B.Y, 3);
    Insert(New(PStaticText, Init(R,
      #13 +
      ^C'Clusse Setup ' + Version + #13 +
      ^C'for Clusse ' + CluVersion + #13 +
      #13 +
      ^C'Copyright (c) 1996'#13 +
      ^C'Heikki Hannikainen, OH7LZB')));

    R.Assign(15, 8, 25, 10);
    Insert(New(PButton, Init(R, 'O~K', cmOk, bfDefault)));
  end;
  if ValidView(D) <> nil then
  begin
    Desktop^.ExecView(D);
    Dispose(D, Done);
  end;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

function CreateFindDialog: PDialog;
var
  D: PDialog;
  Control: PView;
  R: TRect;
begin
  R.Assign(0, 0, 38, 12);
  D := New(PDialog, Init(R, 'Find'));
  with D^ do
  begin
    Options := Options or ofCentered;

    R.Assign(3, 3, 32, 4);
    Control := New(PInputLine, Init(R, 80));
    Insert(Control);
    R.Assign(2, 2, 15, 3);
    Insert(New(PLabel, Init(R, '~T~ext to find', Control)));
    R.Assign(32, 3, 35, 4);
    Insert(New(PHistory, Init(R, PInputLine(Control), 10)));

    R.Assign(3, 5, 35, 7);
    Insert(New(PCheckBoxes, Init(R,
      NewSItem('~C~ase sensitive',
      NewSItem('~W~hole words only', nil)))));

    R.Assign(14, 9, 24, 11);
    Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
    Inc(R.A.X, 12); Inc(R.B.X, 12);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

    SelectNext(False);
  end;
  CreateFindDialog := D;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

function CreateReplaceDialog: PDialog;
var
  D: PDialog;
  Control: PView;
  R: TRect;
begin
  R.Assign(0, 0, 40, 16);
  D := New(PDialog, Init(R, 'Replace'));
  with D^ do
  begin
    Options := Options or ofCentered;

    R.Assign(3, 3, 34, 4);
    Control := New(PInputLine, Init(R, 80));
    Insert(Control);
    R.Assign(2, 2, 15, 3);
    Insert(New(PLabel, Init(R, '~T~ext to find', Control)));
    R.Assign(34, 3, 37, 4);
    Insert(New(PHistory, Init(R, PInputLine(Control), 10)));

    R.Assign(3, 6, 34, 7);
    Control := New(PInputLine, Init(R, 80));
    Insert(Control);
    R.Assign(2, 5, 12, 6);
    Insert(New(PLabel, Init(R, '~N~ew text', Control)));
    R.Assign(34, 6, 37, 7);
    Insert(New(PHistory, Init(R, PInputLine(Control), 11)));

    R.Assign(3, 8, 37, 12);
    Insert(New(PCheckBoxes, Init(R,
      NewSItem('~C~ase sensitive',
      NewSItem('~W~hole words only',
      NewSItem('~P~rompt on replace',
      NewSItem('~R~eplace all', nil)))))));

    R.Assign(17, 13, 27, 15);
    Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
    R.Assign(28, 13, 38, 15);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

    SelectNext(False);
  end;
  CreateReplaceDialog := D;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

function DoEditDialog(Dialog: Integer; Info: Pointer): Word; far;
var
  R: TRect;
  T: TPoint;
begin
  case Dialog of
    edOutOfMemory:
      DoEditDialog := MessageBox('Not enough memory for this operation.',
        nil, mfError + mfOkButton);
    edReadError:
      DoEditDialog := MessageBox('Error reading file %s.',
        @Info, mfError + mfOkButton);
    edWriteError:
      DoEditDialog := MessageBox('Error writing file %s.',
        @Info, mfError + mfOkButton);
    edCreateError:
      DoEditDialog := MessageBox('Error creating file %s.',
        @Info, mfError + mfOkButton);
    edSaveModify:
      DoEditDialog := MessageBox('%s has been modified. Save?',
        @Info, mfInformation + mfYesNoCancel);
    edSaveUntitled:
      DoEditDialog := MessageBox('Save untitled file?',
        nil, mfInformation + mfYesNoCancel);
    edSaveAs:
      DoEditDialog := Application^.ExecuteDialog(New(PFileDialog, Init('*.*',
        'Save file as', '~N~ame', fdOkButton, 101)), Info);
    edFind:
      DoEditDialog := Application^.ExecuteDialog(CreateFindDialog, Info);
    edSearchFailed:
      DoEditDialog := MessageBox('Search string not found.',
        nil, mfError + mfOkButton);
    edReplace:
      DoEditDialog := Application^.ExecuteDialog(CreateReplaceDialog, Info);
    edReplacePrompt:
      begin
        { Avoid placing the dialog on the same line as the cursor }
        R.Assign(0, 1, 40, 8);
        R.Move((Desktop^.Size.X - R.B.X) div 2, 0);
        Desktop^.MakeGlobal(R.B, T);
        Inc(T.Y);
        if TPoint(Info).Y <= T.Y then
          R.Move(0, Desktop^.Size.Y - R.B.Y - 2);
        DoEditDialog := MessageBoxRect(R, 'Replace this occurence?',
          nil, mfYesNoCancel + mfInformation);
      end;
  end;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

constructor TTVDemo.Init;
var
  R: TRect;
  I: Integer;
  FileName: PathStr;
begin
  New(Conf);
  ReadConfig;
  MaxHeapSize := HeapSize;
  inherited Init;
  RegisterObjects;
  RegisterViews;
  RegisterMenus;
  RegisterDialogs;
  RegisterApp;

  RegisterHelpFile;
  RegisterCalc;
  RegisterEditors;

  RegisterSetForm;
  RegisterIfSetForm;
  RegisterUserSetForm;
  RegisterUGroupsForm;
  RegisterExpForm;
  RegisterConvForm;
  RegisterScrForm;
  RegisterSndForm;

  { Initialize demo gadgets }

  GetExtent(R);
  R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R));
  Insert(Clock);

  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap);

  DisableCommands([cmSave, cmSaveAs, cmCut, cmCopy, cmPaste, cmClear,
    cmUndo, cmFind, cmReplace, cmSearchAgain, cmCloseAll]);
  EditorDialog := DoEditDialog;
  ClipWindow := OpenEditor('', False);
  if ClipWindow <> nil then
  begin
    Clipboard := ClipWindow^.Editor;
    Clipboard^.CanUndo := False;
  end;

  for I := 1 to ParamCount do
  begin
    FileName := ParamStr(I);
    if FileName[Length(FileName)] = '\' then
      FileName := FileName + '*.*';
    if (Pos('?', FileName) = 0) and (Pos('*', FileName) = 0) then
      OpenEditor(FExpand(FileName), True)
    else FileOpen(FileName);
  end;

  About;

  If DefaultsUsed
    then MessageBox(^C'Could not read configuration file!'
                   + ' Creating a new one and using default settings...',
                   nil, mfWarning + mfOkButton);

end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

Destructor TTVDemo.Done;
Begin

 WriteConfig;
 inherited Done;

End;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

function TTVDemo.OpenEditor(FileName: FNameStr; Visible: Boolean): PEditWindow;
var
  P: PView;
  R: TRect;
begin
  DeskTop^.GetExtent(R);
  P := Application^.ValidView(New(PEditWindow,
    Init(R, FileName, wnNoNumber)));
  if not Visible then P^.Hide;
  DeskTop^.Insert(P);
  OpenEditor := PEditWindow(P);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTVDemo.FileOpen(WildCard: PathStr);
var
  FileName: FNameStr;
begin
  FileName := '*.*';
  if ExecuteDialog(New(PFileDialog, Init(WildCard, 'Open a file',
    '~N~ame', fdOpenButton + fdHelpButton, 100)), @FileName) <> cmCancel then
    OpenEditor(FileName, True);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTVDemo.GetEvent(var Event: TEvent);
var
  W: PWindow;
  HFile: PHelpFile;
  HelpStrm: PDosStream;
const
  HelpInUse: Boolean = False;
begin
  inherited GetEvent(Event);
  case Event.What of
    evCommand:
      if (Event.Command = cmHelp) and not HelpInUse then
      begin
        HelpInUse := True;
        HelpStrm := New(PDosStream, Init(CalcHelpName, stOpenRead));
        HFile := New(PHelpFile, Init(HelpStrm));
        if HelpStrm^.Status <> stOk then
        begin
          MessageBox('Could not open help file.', nil, mfError + mfOkButton);
          Dispose(HFile, Done);
        end
        else
        begin
          W := New(PHelpWindow,Init(HFile, GetHelpCtx));
          if ValidView(W) <> nil then
          begin
            ExecView(W);
            Dispose(W, Done);
          end;
          ClearEvent(Event);
        end;
        HelpInUse := False;
      end;
    evMouseDown:
      if Event.Buttons <> 1 then Event.What := evNothing;
  end;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

{
function TTVDemo.GetPalette: PPalette;
const
  CNewColor = CAppColor + CHelpColor;
  CNewBlackWhite = CAppBlackWhite + CHelpBlackWhite;
  CNewMonochrome = CAppMonochrome + CHelpMonochrome;
  P: array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  GetPalette := @P[AppPalette];
end;
}

function TTVDemo.GetPalette: PPalette;
const
  CNewColor = CAppColor + CHelpColor;
  CNewBlackWhite = CAppBlackWhite + CHelpBlackWhite;
  CNewMonochrome = CAppMonochrome + CHelpMonochrome;
  P: array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  GetPalette := @Conf^.Crt.Pal;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTVDemo.HandleEvent(var Event: TEvent);

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

  procedure ChangeDir;
  var
    D: PChDirDialog;
  begin
    D := New(PChDirDialog, Init(cdNormal + cdHelpButton, 101));
    D^.HelpCtx := hcFCChDirDBox;
    ExecuteDialog(D, nil);
  end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure Calculator;
var
  P: PCalculator;
begin
  P := New(PCalculator, Init);
  P^.HelpCtx := hcCalculator;
  InsertWindow(P);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure Colors;
var
  D: PColorDialog;
begin
  D := New(PColorDialog, Init('',
    ColorGroup('Desktop',       DesktopColorItems(nil),
    ColorGroup('Menus',         MenuColorItems(nil),
    ColorGroup('Dialogs',       DialogColorItems(dpGrayDialog, nil),
    ColorGroup('Editor',        WindowColorItems(wpBlueWindow, nil),
    ColorGroup('Status window',
                       ColorItem('Line 1, normal', cmStat1,
                       ColorItem('Version string', cmStatVer,
                       ColorItem('Clock', cmStatClock,
                       ColorItem('Line 2, normal', cmStat2,
                       ColorItem('Line 3, normal', cmStat3,
                       ColorItem('Action string', cmStatAction,
                       ColorItem('Critical actions', cmStatCritical,
                       nil))))))),
    ColorGroup('Terminal',
                       ColorItem('Received text', cmRxRec,
                       ColorItem('Received, highlighted', cmRxHi,
                       ColorItem('Sent text', cmRxCon,
                       ColorItem('Input window', cmTxWin,
                       nil)))),
    ColorGroup('Monitor',
                       ColorItem('System messages', cmMonSystem,
                       ColorItem('Critical system messages', cmMonCritical,
                       ColorItem('Headers', cmMonHeaders,
                       ColorItem('Text', cmMonText,
                       nil)))),
      nil)))))))));

  D^.HelpCtx := hcSCColorsDBox;

  if ExecuteDialog(D, Application^.GetPalette) <> cmCancel then
  begin
    DoneMemory;    { Dispose all group buffers }
    ReDraw;        { Redraw application with new palette }
  end;

end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure Mouse;
var
  D: PDialog;
begin
  D := New(PMouseDialog, Init);
  D^.HelpCtx := hcSMMouseDBox;
  ExecuteDialog(D, @MouseReverse);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure GenSettings;
var
  D: PDialog;
begin
  D := New(PGenSets, Init);
  D^.HelpCtx := hcGenSets;
  ExecuteDialog(D, nil);
end;

procedure IfSettings;
var
  D: PDialog;
begin
  D := New(PIfSets, Init);
  ExecuteDialog(D, nil);
end;

procedure UserSettings;
var
  D: PDialog;
begin
  D := New(PUserSets, Init);
  D^.HelpCtx := hcUserSets;
  ExecuteDialog(D, nil);
end;

procedure UGroupSettings;
var
  D: PDialog;
begin
  D := New(PUGroups, Init);
  D^.HelpCtx := hcGroupSets;
  ExecuteDialog(D, nil);
end;

procedure AdmSettings;
var
  D: PDialog;
begin
  D := New(PAdm, Init);
  D^.HelpCtx := hcAdmSets;
  ExecuteDialog(D, nil);
end;

procedure ExpSettings;
var
  D: PDialog;
begin
  D := New(PExp, Init);
  D^.HelpCtx := hcExpSets;
  ExecuteDialog(D, nil);
end;

procedure ConvSettings;
var
  D: PDialog;
begin
  D := New(PConv, Init);
  D^.HelpCtx := hcConvSets;
  ExecuteDialog(D, nil);
end;

procedure ScrSettings;
var
  D: PDialog;
begin
  D := New(PScr, Init);
  D^.HelpCtx := hcScreenSets;
  ExecuteDialog(D, nil);
end;

procedure SndSettings;
var
  D: PDialog;
begin
  D := New(PSnd, Init);
  D^.HelpCtx := hcSoundSets;
  ExecuteDialog(D, nil);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure FileNew;
begin
  OpenEditor('', True);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure ShowClip;
begin
  ClipWindow^.Select;
  ClipWindow^.Show;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

begin
  inherited HandleEvent(Event);
  case Event.What of
    evCommand:
      begin
        case Event.Command of
          cmOpen: FileOpen('*.*');
          cmNew: FileNew;
          cmShowClip: ShowClip;
          cmChangeDir: ChangeDir;

          cmAbout: About;
          cmCalculator: Calculator;

          cmColors: Colors;
          cmMouse: Mouse;

          cmGenSets: GenSettings;
          cmIfSets: IfSettings;
          cmUserSets: UserSettings;
          cmUGroups: UGroupSettings;
          cmAdm: AdmSettings;
          cmExp: ExpSettings;
          cmConv: ConvSettings;
          cmScr: ScrSettings;
          cmSnd: SndSettings;

        else
          Exit;
        end;
        ClearEvent(Event);
      end;
  end;
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTVDemo.Idle;

  function IsTileable(P: PView): Boolean; far;
  begin
    IsTileable := (P^.Options and ofTileable <> 0) and
      (P^.State and sfVisible <> 0);
  end;

begin
  inherited Idle;
  Clock^.Update;
  Heap^.Update;
  if Desktop^.FirstThat(@IsTileable) <> nil then
    EnableCommands([cmTile, cmCascade])
  else
    DisableCommands([cmTile, cmCascade]);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTVDemo.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y+1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~'#240'~', hcSystem, NewMenu(
      NewItem('~A~bout', '', kbNoKey, cmAbout, hcSAbout,
      NewLine(
      NewItem('~C~alculator', '', kbNoKey, cmCalculator, hcCalculator, nil)))),
    NewSubMenu('~F~ile', hcFile, NewMenu(
      StdFileMenuItems(nil)),
    NewSubMenu('~S~ettings', hcSettings, NewMenu(
      NewItem('~G~eneral...', '', kbNoKey, cmGenSets, hcGenSets,
      NewItem('~I~nterface...', '', kbNoKey, cmIfSets, hcIfSets,
      NewItem('~U~ser...', '', kbNoKey, cmUserSets, hcUserSets,
      NewItem('~P~rivilege groups...', '', kbNoKey, cmUGroups, hcGroupSets,
      NewItem('~A~dministrative...', '', kbNoKey, cmAdm, hcAdmSets,
      NewItem('~E~xpiration...', '', kbNoKey, cmExp, hcExpSets,
      NewItem('~C~onference mode...', '', kbNoKey, cmConv, hcConvSets,
      NewItem('~S~creen...', '', kbNoKey, cmScr, hcScreenSets,
      NewItem('Sou~n~d...', '', kbNoKey, cmSnd, hcSoundSets,
      NewLine(
      NewItem('~M~ouse...', '', kbNoKey, cmMouse, hcSMouse,
      NewItem('C~o~lors...', '', kbNoKey, cmColors, hcSColors,nil))))))))))))),
    NewSubMenu('~E~ditor', hcEdit, NewMenu(
      StdEditMenuItems(
      NewLine(
      NewItem('~F~ind...', '', kbNoKey, cmFind, hcFind,
      NewItem('~R~eplace...', '', kbNoKey, cmReplace, hcReplace,
      NewItem('~S~earch again', '', kbNoKey, cmSearchAgain, hcSearchAgain,
      NewLine(
      NewItem('~S~how clipboard', '', kbNoKey, cmShowClip, hcShowClip,
      nil)))))))),
    NewSubMenu('~W~indow', hcWindows, NewMenu(
      StdWindowMenuItems(nil)),
      nil))))))));

end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTVDemo.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F1~ Help', kbF1, cmHelp,
      NewStatusKey('~F3~ Open', kbF3, cmOpen,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      NewStatusKey('~F5~ Zoom', kbF5, cmZoom,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('', kbCtrlF5, cmResize,
      nil))))))),
    nil)));
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

procedure TTVDemo.OutOfMemory;
begin
  MessageBox('Not enough memory available to complete operation.',
    nil, mfError + mfOkButton);
end;

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }

var
  Demo: TTVDemo;

begin
  Demo.Init;
  Demo.Run;
  Demo.Done;
  WriteLn('Clusse Setup ' + Version
        + '              (c) 1996 Heikki Hannikainen <hessu@pspt.fi>');
end.

 { ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** ***** }
