
#include <signal.h>
#include <unistd.h>
#include <time.h>
#include <stdlib.h>

#include "timer.h"
#include "hmalloc.h"

struct timer_t *timers = NULL;
time_t now;
int timer_pending;

/*
 *	Timer interrupt handler, once per second
 */

static void timer_second(int sig)
{
	time(&now);
	timer_init();
	timer_pending = 1;
}

/*
 *	Initialize timer interrupt
 */

void timer_init(void)
{
	signal(SIGALRM, timer_second); /* Restore handler */
	alarm(1);
}

/*
 *	Timer event
 */

void timer_event(void)
{
	struct timer_t *t;
	struct timer_t *next = timers;
	
	while (next) {
		t = next;
		next = t->next;
		if (t->at <= now) {
			(*t->func)(t->ptr);
			if (t->interval)
				t->at = now + t->interval;
			else
				del_timer(t);
		}
	}
	
	timer_pending = 0;
} 
 
/*
 *	Delete a timer
 */

int del_timer(struct timer_t *t)
{
	*t->prevp = t->next;
	if (t->next)
		t->next->prevp = t->prevp;
	hfree(t);
	
	return 1;
}

/*
 *	Set a timer
 */

struct timer_t *set_timer(time_t at, long interval, 
		void (*func) (void *ptr), void *ptr)
{
	struct timer_t *t;
	
	t = hmalloc(sizeof(struct timer_t));
	t->at = at;
	t->interval = interval;
	t->func = func;
	t->ptr = ptr;
	
	if (timers)
		timers->prevp = &t->next;
	t->next = timers;
	timers = t;
	
	return t;
}

