#include <dos.h>
#include <string.h>
#include "buckmstr.h"

//--------------------------------------------------------------------------
//------ Service 1 - Set CD-ROM drive letter -------------------------------
//--------------------------------------------------------------------------
void Buck_SetDrive(char DriveLetter, int Int)
{
  union REGS regs;

  regs.x.ax = 1;
  regs.x.bx = (int) DriveLetter - 'A';

  int86(Int, &regs, &regs);
}

//--------------------------------------------------------------------------
//------ Service 2 - Set output String Details -----------------------------
//--------------------------------------------------------------------------
void Buck_SetOutput(char * String, int LenOfStr, int Int)
{
  union REGS regs;

  regs.x.ax = 2;
  regs.x.bx = FP_SEG(String);
  regs.x.cx = FP_OFF(String);
  regs.x.dx = LenOfStr;

  int86(Int, &regs, &regs);
}

//--------------------------------------------------------------------------
//------ Service 3 - Lookup Call -------------------------------------------
//--------------------------------------------------------------------------
void Buck_Lookup(char * CallSign, int Int)
{
  union REGS regs;

  regs.x.ax = 3;

  regs.x.bx = FP_SEG(CallSign);
  regs.x.cx = FP_OFF(CallSign);
  regs.x.dx = strlen(CallSign) + 1; //Includes trailing NULL

  int86(Int, &regs, &regs);
}

//--------------------------------------------------------------------------
//------ Extract a field ---------------------------------------------------
//--------------------------------------------------------------------------
//------ Input -------------------------------------------------------------
// char * String    : Records returning by BuckTsr
// char AsciiPrefix : Extract ASCII Prefic, defined by BuckMaster
//------ Output ------------------------------------------------------------
// Function return the extracted field, if any.
//--------------------------------------------------------------------------
char * Buck_GetField(char * Output, char * String, char AsciiPrefix)
{
  unsigned char * FirstOccur;
  int  index = 0;

  FirstOccur = strchr(String, AsciiPrefix);

  if( FirstOccur )
  {
    FirstOccur++;
    while( FirstOccur[index] < 181 )
      Output[index] = FirstOccur[index++];
    Output[index++] = ' '; //Ajouter un espace
  }

  Output[index] = NULL;

  return( Output );
}
