/* @(#) $Header: tcpdump.c,v 1.5 91/05/09 07:38:56 deyke Exp $ */

/* TCP header tracing routines
 * Copyright 1991 Phil Karn, KA9Q
 */
#include <stdio.h>
#include "listen.h"

#define	FIN	0x01
#define	SYN	0x02
#define	RST	0x04
#define	PSH	0x08
#define	ACK	0x10
#define	URG	0x20
#define	CE	0x40

#define	TCPLEN	20

/* Dump a TCP segment header. Assumed to be in network byte order */
void tcp_dump(unsigned char *data, int length, int hexdump)
{
	int source, dest;
	int seq;
	int ack;
	int flags;
	int wnd;
	int up;

	source = get16(data + 0);
	dest   = get16(data + 2);
	seq    = get32(data + 4);
	ack    = get32(data + 8);
	flags  = data[13];
	wnd    = get16(data + 14);
	up     = get16(data + 18);

	lprintf(T_PROTOCOL, "TCP:"); 
	lprintf(T_TCPHDR, " %d->%d Seq x%x", source, dest, seq);

	if (flags & ACK) lprintf(T_TCPHDR, " Ack x%x", ack);

	if (flags & CE)  lprintf(T_TCPHDR, " CE");

	if (flags & URG) lprintf(T_TCPHDR, " URG");

	if (flags & ACK) lprintf(T_TCPHDR, " ACK");

	if (flags & PSH) lprintf(T_TCPHDR, " PSH");

	if (flags & RST) lprintf(T_TCPHDR, " RST");

	if (flags & SYN) lprintf(T_TCPHDR, " SYN");

	if (flags & FIN) lprintf(T_TCPHDR, " FIN");

	lprintf(T_TCPHDR, " Wnd %d", wnd);

	if (flags & URG) lprintf(T_TCPHDR, " UP x%x", up);

	/* Print options, if any */
	/*
	if (mss != 0) lprintf(T_TCPHDR," MSS %d", mss);
	*/

	length -= TCPLEN;
	data   += TCPLEN;

	if (length > 0) {
		lprintf(T_TCPHDR, " Data %d\n", length);
		data_dump(data, length, hexdump);
		return;
	}
	
	lprintf(T_TCPHDR, "\n");
}
