/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    ALL.H   -   Headerfile fuer alle C-Sources                            *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:                                                          *
*                                                                          *
*	G8KBB - April 91 - remove defintion of FIRMWARE                        *
*         - add definitions for ESDG_RING                                  *
\**************************************************************************/

/*
 * Released as TheNet X-1J release 4, January 1995
 */

/* bit of a crock - need to include compile time switch definitions
 * from version.h. Note compiler difference. MSC goes & looks in the
 * wrong place !
 */

#ifdef MSDOS
#include "pc\version.h"
#else 
#include "version.h"
#endif

/*                                                         Festlegungen   */
/**************************************************************************/

#ifdef FIRMWARE
#define LINKNMBR     4        /* maximale Anzahl Links = Connect-Kanaele  */
#else
#define LINKNMBR    25
#endif

#define TRUE        1         /* BOOLEAN TRUE                             */
#define FALSE       0         /* BOOLEAN FALSE                            */
#define YES         1         /* TRUE-Synonym                             */
#define NO          0         /* FALSE-Synonym                            */
#define ERROR       (-1)      /* Fehler                                   */
#define LOOP        for(;;)   /* Endlosschleife                           */
#define STACKLEN    384       /* Anzahl Bytes fuer Systemstack            */
#define MAGIC       0x4D5A    /* "magic number", Warmstartfeststellung    */
                              /* (MSDOS laesst gruessen ...)              */

#define L2PNUM      NUMPORTS            /* L2x.C :   Level-2-Port numbers */

#define NULL        0         /* leerer Inhalt, leerer Zeiger,            */
                              /* sollte bei 8-Bit-Systemen 0, bei 16-Bit- */
                              /* Systemen 0L heissen, 0L weil NULL auch   */
                              /* als Parameter moeglich ist, 0L bei       */
                              /* 8-Bit-Systemen kann aber dazu fuehren,   */
                              /* dass die 32-Bit-Bibliothek geladen wird, */
                              /* ohne dass sie benutzt wird               */



/*                                                       einfache Typen   */
/**************************************************************************/

typedef int        VOID;      /* Keine-Parameter-Zurueck-Funktion         */
typedef unsigned   BOOLEAN;   /* 1 = TRUE, 0 = FALSE                      */

#ifdef MONITORCMD
#define MAXHEARDLIST 100
#ifndef MODIFIED
#define MODIFIED
#endif
#endif

#ifdef STATSCMD
#define NUM1STATS 6
/* WARNING !
 * If you change this you may need to alter tnl1.mac as it
 * offsets into this table for rxovr, txund and rxcrc
 */
#define NUML2STATS 11
#define L2HDCNT l2stats[0]
#define L2RXCNT l2stats[1]
#define L2TXCNT l2stats[2]
#define L2RXRNR l2stats[3]
#define L2RXREJ l2stats[4]
#define L2TXRNR l2stats[5]
#define L2TXREJ l2stats[6]
#define L2FAILS l2stats[7]
#define L2RXOVR l2stats[8]
#define L2TXUND l2stats[9]
#define L2RXCRC l2stats[10]

#define NUML4STATS 2
#define L4TXCNT l4stats[0]
#define L4RXCNT l4stats[1]
#ifndef MODIFIED
#define MODIFIED
#endif
#endif

#ifdef HOSTMODE
#define HOSTCMD
#ifndef MODIFIED
#define MODIFIED
#endif
#endif

#ifndef SIGNONTEXT
#define SIGNONTEXT "TheNet 1.01 "
#endif

#ifdef FIRMWARE
#define INCLUDEcpyfb
#else
#ifdef KISSMODE
#define INCLUDEcpyfb
#endif
#endif /* FIRMWARE */

#ifdef ACL
#define ACL_BAR_L2_IC 1
#define ACL_BAR_L2_OG 2
#define ACL_BAR_L3_BCASTS 4
#define ACL_BAR_L3_RELAY 8
#define ACL_BAR_L4_IC 0x10
#define ACL_BAR_L4_OG 0x20
#define ACL_IGNORE_SSID 0x40
#ifdef ACL_DISCMD_OVERRIDE
#define ACL_DIS_OVERRIDE 0x80
#endif
#endif


#ifdef METERS
/* The following apply to meterflags variable
 */
#define DEVMETER_ENABLE	1
#define SMETER_ENABLE 2
#define SMETER_AS_S 4
#define CH3_ENABLE 8
#define CH4_ENABLE 0x10
#define CH3_DIV1000 0x20
#define CH4_DIV1000 0x40
#define CH3_DECIMALS 0x80
#define CH4_DECIMALS 0x100
#ifdef ALL_METERS
#define CH1_ENABLE 0x200
#define CH2_ENABLE 0x400
#define CH1_DIV1000 0x800
#define CH2_DIV1000 0x1000
#define CH1_DECIMALS 0x2000
#define CH2_DECIMALS 0x4000
#endif
#endif

#ifdef CWID
#define CWIDLEN	6
#endif

#define BLINLEN 100		/* length of host port line buffer */

/* WARNING - the non portable versions here are macros not functions
 * so fairly predictable nasties may happen in predicable 'C' way if
 * you are careless with their parameters.
 */
#ifndef PORTABLE
#define cpy6ch( dest, src ) memcpy( (dest), (src), 6 )
#define move4b( count, dest, src ) memcpy( (dest), (src), (count)*4 )
#endif

/* Ende von ALL.H */

/* residue of tndef.h */

# define NUMCIR   20		/* Laenge der Circuit Tabelle		     */
# define NUMPAT   46		/* Laenge der Patchcord Liste		     */
# define MAXL2L   LINKNMBR	/* Links im Level2			     */
# define MAXHST	   1		/* Host Kanaele				     */
# define DEFL2L    1		/* Protokollversion 2			     */

/* definition of PIDs as follows :
 */
#define PID_IP		0xcc
#define PID_ARP		0xcd
#define PID_FLEXNET	0xce
#define PID_NETROM	0xcf
#define PID_NO_L3	0xf0
#define PID_TEXNET 0xc3

#define NR4_OP_PID  	0
#define NR_PROTO_IP 	0x0c

/* end of tndef.h */

/* the following are from l2.h */




#define L2CALEN  6                      /* Laenge Call im Level 2         */
#define L2IDLEN  (L2CALEN + 1)          /* Laenge Call + SSID = ID        */
#define L2INUM   2                      /* Anzahl ID's im an/von-Feld     */
#define L2VNUM   8                      /* Anzahl ID's im via-Feld        */
#define L2ILEN   (L2INUM * L2IDLEN)     /* Laenge an/von-Feld             */
#define L2VLEN   (L2VNUM * L2IDLEN)     /* Laenge via-Feld                */
#define L2AFLEN  (L2ILEN + L2VLEN)      /* Laenge Level 2 Adressfeld      */
#define L2MFLEN  328                    /* maximale Framelaenge,          */
                                        /*   10 * 7 =    70 Bytes Adresse */
                                        /*            +   1 Byte Control  */
                                        /*            +   1 Byte PID      */
                                        /*            + 256 Byte Info     */
                                        /*            -----               */
                                        /*              328               */



                              /* "layer 2 state", (state, s.u.) :         */
#define L2SDSCED    0         /*    disconnected                          */
#define L2SLKSUP    1         /*    link setup                            */
#define L2SFRREJ    2         /*    frame reject                          */
#define L2SDSCRQ    3         /*    disconnect request                    */
#define L2SIXFER    4         /*    information transfer                  */
#define L2SRS       5         /*    REJ sent                              */
#define L2SWA       6         /*    waiting acknowledge                   */
#define L2SDBS      7         /*    device busy                           */
#define L2SRBS      8         /*    remote busy                           */
#define L2SBBS      9         /*    both busy                             */
#define L2SWADBS   10         /*    waiting ack and device busy           */
#define L2SWARBS   11         /*    waiting ack and remote busy           */
#define L2SWABBS   12         /*    waiting ack and both busy             */
#define L2SRSDBS   13         /*    REJ sent and device busy              */
#define L2SRSRBS   14         /*    REJ sent and remote busy              */
#define L2SRSBBS   15         /*    REJ sent and both busy                */



                              /* "layer 2 message", Status vom Level 2 :  */
#define L2MNIX     0          /*    keine Nachricht                       */
#define L2MCONNT   1          /*    CONNECTED to                          */
#define L2MDISCF   2          /*    DISCONNECTED from                     */
#define L2MBUSYF   3          /*    BUSY from                             */
#define L2MFAILW   4          /*    LINK FAILURE with                     */
#define L2MLRESF   5          /*    LINK RESET from                       */
#define L2MLREST   6          /*    LINK RESET to                         */
#define L2MFRMRF   7          /*    FRAME REJECT from                     */
#define L2MFRMRT   8          /*    FRAME REJECT to                       */
#define L2MBUSYT   9          /*    BUSY to                               */



                              /* "layer 2 control", Frametypen :          */
                              /*                                          */
                              /*                       Command/   Poll/   */
                              /*    Typ       Gruppe   Response   Final   */
                              /* ---------------------------------------- */
#define L2CI       0x00       /*      I         I         C         P     */
#define L2CUI      0x03       /*     UI         U        C/R       P/F    */
#define L2CSABM    0x2F       /*   SABM         U         C         P     */
#define L2CDISC    0x43       /*   DISC         U         C         P     */
#define L2CUA      0x63       /*     UA         U         R         F     */
#define L2CDM      0x0F       /*     DM         U         R         F     */
#define L2CFRMR    0x87       /*   FRMR         U         R         F     */
#define L2CRR      0x01       /*     RR         S        C/R       P/F    */
#define L2CREJ     0x09       /*    REJ         S        C/R       P/F    */
#define L2CRNR     0x05       /*    RNR         S        C/R       P/F    */

                              /* "layer 2 control", spezielle Bits :      */
#define L2CPF      0x10       /*   Poll/Final                             */
#define L2CCR      0x80       /*   Command/Response                       */
#define L2CH       0x80       /*   "has been repeated"                    */
#define L2CEOA     0x01       /*   End of Address                         */

                              /* "layer 2 control", Masken :              */
#define L2CNOIM    0x01       /*   "no I mask", kein I-Frame              */
#define L2CNOSM    0x02       /*   "no S mask", kein S-Frame              */

                              /* "layer 2 control", Protokollidentifier   */
#define L2CPID     PID_NO_L3  /*   PID                                    */

                              /* "layer 2 control", Flags (flag, s.u.) :  */
#define L2FL3LNK   0x20       /*   Link ist Layer-3-Link                  */
#define L2FBUSY    0x40       /*   Device busy (ich !)                    */
#define L2FDSLE    0x80       /*   "disc if send list empty"              */

                              /* im Framebufferkopf (l2fflag, s.u.) :     */
#define L2FT1ST    0x01       /*   nach Aussendung ist T1 zu starten      */
#define L2FUS      0x02       /*   Sendeframe ist U- oder S-Frame (nicht  */
                              /*   digipeatet)                            */


