/*****************************************************************************/
/*	         							     */
/*									     */
/*    *****			  ***** 				     */
/*	 *****			*****					     */
/*	   *****	      *****					     */
/*	     *****	    *****					     */
/*  ***************	  ***************				     */
/*  *****************	*****************				     */
/*  ***************	  ***************				     */
/*	     *****	    *****	   TheNet       		     */
/*	   *****	      *****	   Portable. Compatible.	     */
/*	 *****			*****	   Public Domain		     */
/*    *****			  *****    G8KBB	 		     */
/*									     */
/* This software is public domain ONLY for non commercial use                */
/*                                                                           */
/*									     */
/*                                                                           */
/* September 1993 - released as TheNet X-1J                                  */
/* added texnet support to checkheard()                                      */
/*                                                                           */
/* Add support for l3mheard optionally on L3MONITOR                         */
/* Add link list reverse link checking in integrity()                        */
/* Add pk96 watchdog calls                                                   */
/*                                                                           */
/* Released as TheNet X-1J release 4, January 1995                           */
/*****************************************************************************/

#include "all.h"
#include "tntyp.h"

#ifdef MONITORCMD
extern lhtyp heardl;
extern char txfhdr[];
extern char rxfprt;
extern unsigned seconds;
extern unsigned char mhlcount;
extern unsigned char DEFMHL;
extern unsigned heardtm;
extern unsigned runtime, uptime;
extern MHEARD *mhptr;
#endif
#ifdef INTEGRITY
extern lhtyp destil;
extern lhtyp neigbl;
extern lhtyp Arp_tab;
extern lhtyp IP_Routes;
#endif

extern unsigned char rxfdev;
extern unsigned char siglev;

#ifdef ACL
extern ACLMB acl;
#endif

/* called from the level 2 software, this utility checks the heard list to see
 * when and if the station was last heard. If not heard, it creates an entry,
 * if it had been heard, the packet counter is bumped. In each case, the
 * 'lastheard' timer is set to the currenttime, and the station is moved to
 * the head of the list. Finally, if there are too many entries, the extra
 * are removed.
 */

#ifdef MONITORCMD

#ifdef L3MONITOR
checkheard( lst, callsign, count)
MHEARD *lst;
char *callsign;
unsigned char count;
{
	register MHEARD *mhp;
	register int i;
	register MHEARD *list = lst;

	i = 0;
	mhp = list->prevhb;			/*start with one end of list*/
	while( mhp != list )			/* step thru all entries    */
		if( cmpid( mhp->call, callsign ) )
			break;			/* stop if match found      */
		else				/* otherwise,               */
		{
			i++;			/* bump the counter         */
			mhp = mhp->prevhb;	/* and step on to the next  */
		}
	if( mhp != list )			/* if a match was found,    */
	{
		unlink( mhp );			/* then unlink it's buffer  */
		mhp->packets++;			/* and increment pkt count  */
	}
	else					/* otherwise ,              */
	{
		mhp = allocb();			/* allocate a new buffer    */
		cpyid( mhp->call, callsign );	/* copy callsign into buffer*/
#ifdef TEXNET
		mhp->istexnet =
#endif
		mhp->isnode = mhp->istcpip = 0;	/* clear flags              */
		mhp->packets = 1;		/* initialise packet count  */
	}
	mhp->port = rxfprt;			/* record which port heard  */
	relink( mhp, list->prevhb );		/* put it at list head      */
	mhp->lastheard = seconds;		/* mark heard time as 'now' */
#ifdef METERS
	mhp->dev = rxfdev;
	mhp->sig_level = siglev;
#endif
	mhptr = mhp;				/* If too long, clear oldest*/
	while( i-- >= count )			/* which is why we used 'i' */
	{
		mhp = list->nexthb;		/* clear out from end of lst*/
		dealoc( unlink( mhp ));		/* and return to free pool  */
	}
}

#else /* L3MONITOR */

checkheard()
{
	register MHEARD *mhp;
	register int i;

	i = 0;
	mhp = heardl.prevhb;			/*start with one end of list*/
	while( mhp != &heardl )			/* step thru all entries    */
		if( cmpid( mhp->call, txfhdr ) )
			break;			/* stop if match found      */
		else				/* otherwise,               */
		{
			i++;			/* bump the counter         */
			mhp = mhp->prevhb;	/* and step on to the next  */
		}
	if( mhp != &heardl )			/* if a match was found,    */
	{
		unlink( mhp );			/* then unlink it's buffer  */
		mhp->packets++;			/* and increment pkt count  */
	}
	else					/* otherwise ,              */
	{
		mhp = allocb();			/* allocate a new buffer    */
		cpyid( mhp->call, txfhdr );	/* copy callsign into buffer*/
#ifdef TEXNET
		mhp->istexnet =
#endif
		mhp->isnode = mhp->istcpip = 0;	/* clear flags              */
		mhp->packets = 1;		/* initialise packet count  */
	}
	mhp->port = rxfprt;			/* record which port heard  */
	relink( mhp, heardl.prevhb );		/* put it at list head      */
	mhp->lastheard = seconds;		/* mark heard time as 'now' */
#ifdef METERS
	mhp->dev = rxfdev;
	mhp->sig_level = siglev;
#endif
	mhptr = mhp;				/* If too long, clear oldest*/
	while( i-- >= mhlcount )		/* which is why we used 'i' */
	{
		mhp = heardl.lnext;		/* clear out from end of lst*/
		dealoc( unlink( mhp ));		/* and return to free pool  */
	}
}
#endif /* L3MONITOR */
#endif

/*--------------------------------------------------------------------------
 * This utility is part of the ACL subsystem. It checks if a buffer
 * is part of the ACL, so that is preserved in warmstart.
 * It is NOT used if INTEGRITY is defined as  integrity() is used instead.
 */

#ifdef ACL
#ifndef INTEGRITY
BOOLEAN	isacl(buffer)		/* Test, ob buffer in ACLlisten ist	     */
ACLMB	*buffer;
{
  register ACLMB *nachb;

  for (nachb  = (ACLMB *) acl.prevaclb;	/* Nachbarnliste absuchen    */
       nachb != (ACLMB *) &acl;
       nachb  = (ACLMB *) nachb->prevaclb)
  {
      if (nachb == buffer) 
      	return(TRUE);
  }
  return(FALSE);		/* nicht gefunden			     */
}
#endif
#endif

#ifdef INTEGRITY

/* The INTEGRITY routine is used to check whether a buffer is in use in
 * a table, and to check that the tables ( linked lists ) are properly
 * linked. ( it should also check the reverse links ! Doesn't yet. )
 *
 * The following table defines the tables that are included in the
 * checking.
 */

lhtyp *tables[] = {
	&neigbl,
	&destil,
#ifdef ACL
	&acl,
#endif
#ifdef IPROUTE
	&IP_Routes,
	&Arp_tab,
#endif
	NULL
};

/* This is the checking routine. If the parameter is NULL, then the
 * tables are checked to see they are linked correctly. If a value
 * is passed then false or true are returned depending on whether
 * the buffer is part of one of the tables.
 */

integrity( buffer )
lhtyp *buffer;
{
	register lhtyp **tableptr;
	register unsigned i;
	register lhtyp *table;
	unsigned numbuffers;

	/* calculate the maximum possible buffers count
	 */
	numbuffers = ( maxmem() - minmem() ) / sizeof( MBHEAD );

	/* step thru all tables
	*/
	tableptr = &tables[0];
	while( *tableptr != NULL )
	{
		for( table =  (*tableptr)->lnext, i = numbuffers ;
		     table != &((*tableptr)->lnext);
		     table =  table->lnext )
		{
#ifdef PK96
			kick_wdog();
#endif
			if( buffer != NULL )		/* if param not NULL */
			{
				if( buffer == table )	/* then return TRUE */
					return( TRUE );	/* if it is in table */
			}
			else				/* otherwise */
			{
				if( --i == 0 		/* count table size */
				    || table->lnext->lprev != table
				  )
				{			/* and init if too */
					inithd(*tableptr); /* large !! */
					break;
				}
			}
		}
		tableptr++;
	}
	return( FALSE );
}

#endif /* INTEGRITY */
