/*****************************************************************************/
/*	         							     */
/*									     */
/*    *****			  ***** 				     */
/*	 *****			*****					     */
/*	   *****	      *****					     */
/*	     *****	    *****					     */
/*  ***************	  ***************				     */
/*  *****************	*****************				     */
/*  ***************	  ***************				     */
/*	     *****	    *****	   TheNet       		     */
/*	   *****	      *****	   Portable. Compatible.	     */
/*	 *****			*****	   Public Domain		     */
/*    *****			  *****    NORD><LINK	 		     */
/*									     */
/* This software is public domain ONLY for non commercial use                */
/*                                                                           */
/*									     */
/*                                                                          */
/*****************************************************************************/

/* Miscellaneous extras
 * G8KBB April 1991 
 *
 * September 1993 - released as TheNet X-1J
 *
 * put arp_service back in iproute.c
 * add support for l3 heard list in flush routines
 * add port flush routine
 *
 * Released as TheNet X-1J release 4, January 1995
 */

#include "all.h"
#include "tntyp.h"		/* Definition der Typen			     */

#ifdef BANKED
#define EXTERN extern
#else
#define EXTERN
#endif

#include "miscv.h"
#include "misce.h"		/* Externe Definitionen			     */

#ifdef MANAGED
#ifdef BANKED
extern char L4audit[];
/* extern char L1audit[];
extern char CPUaudit[];
extern char BUFMSG[];
extern char CPUMSG[];
extern char TXMSG[];
extern char RXMSG[]; */
#else
char L4audit[] = "L4    `";
#endif
char L1audit[] = "L1    `";
char CPUaudit[] = "CPU   `";
char BUFMSG[] = "BUF";
char CPUMSG[] = "CPU";
char TXMSG[] = "%Tx";
char RXMSG[] = "%Rx";
#endif

/*---------------------------------------------------------------------------*/
VOID	initmisc()			/* Level 4 initialisieren	     */
{
  register unsigned cnt;		/* Sratch Zaehler		     */
#ifdef STATSCMD
  register unsigned i;
  register char *ptr;
#endif

	if (! iswarm())			/* im Kaltstart Standardwerte	     */
	{

#ifdef CWID
	cwiden = DEFCW;			/* set target counter in seconds */
	cwidtm = 0;			/* Start off counting from zero */
	cwspeed = DEFCWS;		/* set dot time ( 10's of msecs ) */
	cwstate = 3;			/* Set state to 'finished' */
	cwtimr = 0;			/* disable cwid interrupt process */
#endif

#ifdef STATSCMD

	/* clear the level 1 stats tables 
	 */
	for( cnt = 0; cnt < NUM1STATS; cnt++ )
		minbuf[cnt] = cpucnt[cnt] = txstat[cnt] = rxstat[cnt] = 0;

	/* now clear other misc stats counters
	 */
	txon = dcdon = usetim = 0;
	cpu2load = cpuload = 0;
	minfre = 0x7fff;
	usehour = 0;
#endif

#ifdef MONITORCMD
	runtime = 0;			/* reset the runtime counter */
#ifdef L3MONITOR
	l3mhlcnt =
#endif
	mhlcount = DEFMHL;		/* set default heard list length */
#endif

	}

#ifdef MONITORCMD
	inithd( &heardl );			/* clear the heard list */
	uptime = heardtm = seconds = 0;		/* reset the time counters */
#ifdef L3MONITOR
	inithd( &l3heardl );			/* clear L3 heard list */
#endif
#endif
#ifdef STATSCMD
	ptr = l4stats;
	for( i = sizeof( l4stats); i !=0; i-- )
		*ptr++ = '\0';
#endif
#ifdef MOD_MTU
	mtu_i_max = DEF_MTU_I_MAX;
	mtu_l2_max = DEF_MTU_L2_MAX;
	mtu_ip0 = DEF_MTU_IP0;
	mtu_ip1 = DEF_MTU_IP1;
	mtu_ipn = DEF_MTU_IPN;
#endif
}

/*---------------------------------------------------------------------------*/
VOID	miscsrv()		/* Miscellaneous timer service		     */
{

#ifdef CWID
	cwid();		/* call the cwid timer program each second */
#endif

#ifdef MONITORCMD
	seconds++;	/* bump the seconds counter */
	flushheard();	/* remove old entries in the heard list hourly */
#endif

#ifdef STATSCMD
	chuse();	/* every 10 minutes, update level 1 stats info */
#endif

}

/*-------------------------------------------------------------------------
 * CWID keyer - G8KBB
 * Daemon that every n minutes, sends the station ID in CW 
 */

#ifdef CWID

/* This function is the main daemon that is called every second.
 * If beaconing enabled, and if timeout has occurred, then call
 * cwsend();
 */

VOID cwid()
{
	if( cwiden != 0 )		/* If enabled */
	{
		if(++cwidtm >= cwiden)	/* bump counter & check timeout */
		{			/* if timeout period passed, */
			cwidtm = 0;	/* reset counter */
			if( cwstate == 3 )	/* check not already sending */
				cwsend();	/* and send callsign in cw */
		}
		else if( cwstate == -1 && cwidtm > 60 ) /* If not sent 1 min */
			kicktx( HDLCPORT );	/* later then force it   */
	}
}

/* Table of mappings from character to dots & dashes.
 * For each entry, the top 3 bits are the number of elements
 * in the character, and the lower 5 bits are the dots & dashes.
 * The bits are used starting with bit 0, and a 1 represents a dash.
 */

unsigned char cwchar[] =
{
	0x42, 0x81, 0x85, 0x61, 0x20, 0x84, 0x63, 0x80, 0x40, 0x8e, /* a-j */
	0x65, 0x82, 0x43, 0x41, 0x67, 0x86, 0x8b, 0x62, 0x60, 0x21, /* k-t */
	0x64, 0x88, 0x66, 0x89, 0x8d, 0x83,			    /* u-z */
	0xbf, 0xbe, 0xbc, 0xb8, 0xb0, 0xa0, 0xa1, 0xa3, 0xa7, 0xaf, /* 0-9 */
	0x0
};

/* Routine called by the daemon to send the callsign in CW
 */

cwsend()
{
	register int i,c;

	for( i = 0; i < CWIDLEN && DEFCAL[i] != ' '; i++ )
	{
		c = upcase( DEFCAL[i] );
		if( (c >= 'A') && (c <= 'Z') )
			c -= 'A';
		else if( (c >= '0') && (c <= '9') )
			c += 'Z' - '0' - 'A' + 1;
		else
			c = '9' + 'Z' - '0' + 2 - 'A';
		cwdat[i] = cwchar[c];
	}
	cwdat[i] = 0;		/* NULL signifies the end of the callsign */
	cwbit = (*cwdat >> 5)&7; /* set bits counter to first character */
	cwch  = *cwdat & 0x1f;	/* set first character */
	cwofs = 0;		/* point to first character */
	cwstate = -1;		/* set to start state */
}

#endif /* CWID */


#ifdef MONITORCMD

/* called each second, this program purges the heard list each hour.
 * All entries not heard for 12 hours are removed.
 */

#ifdef L3MONITOR
flushheard()
{
	if(++heardtm >= 3600)		/* bump counter & check timeout */
	{				/* if timeout period passed, */
		heardtm = 0;		/* reset counter */
		flush_mhlist( &heardl, mhlcount );
		flush_mhlist( &l3heardl, l3mhlcnt );
		runtime++;		/* bump timers */
		uptime++;
	}
}

flush_mhlist( list, count)
MHEARD *list;
unsigned char count;
{
	register MHEARD *mhp, *mhp2;
	register unsigned i;

	mhp = list->nexthb;
	i = 0;
	while( mhp != list )	/* step through the list */
	{
		mhp2 = mhp->nexthb;		/* copy the pointer  */
		if( seconds - mhp->lastheard > 3600*12  /* too old? */
		    || i > count )		/* list too long ? */
			dealoc(unlink( mhp ));	/* kill this entry */
		mhp = mhp2;			/* and continue      */
		i++;
	}
}

#else	/* L3MONITOR */

flushheard()
{
	register MHEARD *mhp, *mhp2;

	if(++heardtm >= 3600)	/* bump counter & check timeout */
	{			/* if timeout period passed, */
		heardtm = 0;	/* reset counter */
		mhp = heardl.lnext;
		while( mhp != &heardl )	/* step through the list */
		{
			mhp2 = mhp->nexthb;		/* copy the pointer  */
			if( seconds - mhp->lastheard > 3600*12 ) /* too old? */
				dealoc(unlink( mhp ));	/* kill this entry */
			mhp = mhp2;			/* and continue      */
		}
		runtime++;				/* bump timers */
		uptime++;
	}
}

#endif	/* L3MONITOR */
#endif	/* MONITORCMD */

/*--------------------------------------------------------------------------
 * STATS command daemon. - G8KBB
 * Every 10 minutes, shift the contents of the 10 minute summaries, losing
 * the oldest. The current entries are then formed by reading the totals
 * of the 10 ms updated counters, dividing by 600 to give percentages
 * and clearing the totalisers.
 */

#ifdef STATSCMD
VOID chuse()
{
	register int i,j;

	if( ++usetim >= 600 )			/* every 10 minutes */
	{
		usetim = 0;			/* reset 10 minute counter */
		for( i=NUM1STATS-1; i>0; i-- )	/* this loop copies the */
		{				/* entries in the table */
			txstat[i]=txstat[i-1];	/* losing the oldest one */
			rxstat[i]=rxstat[i-1];
			cpucnt[i]=cpucnt[i-1];
			minbuf[i]=minbuf[i-1];
		}
#ifdef PORTFLUSH
		flush_check();		/* check for port block flush needed */
#endif
		if( ++usehour >= 6 )
		{
			usehour = 0;
			for( i=NUMPORTS*2-1; i >= NUMPORTS; i-- )
				for( j = 0; j < NUML2STATS; j++ )
					l2stats[j][i] = l2stats[j][i-2];
			for( i = 0; i < NUMPORTS; i++ )
				for( j = 0; j < NUML2STATS; j++ )
					l2stats[j][i] = 0;
			for( i = 0; i < NUML4STATS; i++ )
			{
				l4stats[i][1] = l4stats[i][0];
				l4stats[i][0] = 0;
			}
			l3gwcnt[1] = l3gwcnt[0];
			l3gwcnt[0] = 0;
		}
		txstat[0] = txon / 600;		/* set the most recent entry */
		rxstat[0] = dcdon / 600;	/* from the counters */
		cpucnt[0] = cpuload;
		minbuf[0] = minfre;
#ifdef MANAGED
		if( auditmask & 1 )
		{
			notify( L1audit, 0x86, txstat[0], NULL, TXMSG, 3 );
			notify( L1audit, 0x86, rxstat[0], NULL, RXMSG, 3 );
		}
		if( auditmask & 0x40 )
		{
			notify( CPUaudit, 0x86, cpuload, NULL, CPUMSG, 3 );
			notify( CPUaudit, 0x86, minfre, NULL, BUFMSG, 3 );
		}
#endif
		cpuload = txon = dcdon = 0;		/* and reset the counters */
		minfre = 0x7fff;
	}
}

#endif

/**************************************************************************\
*                                                                          *
* "flush_check"                                                            *
*                                                                          *
* Check to see if a port is blocked. If so, then flush pending data        *
* if nothing has been sent when data is pending.                           *
*                                                                          *
\**************************************************************************/

#ifdef PORTFLUSH

flush_check()
{
	register unsigned port;
	
	for( port = 0; port < NUMPORTS; port++ )
	{
		DIinc();
		if( pending[port] && !sentdata[port] )
		{
			if( none_last_time[port] )
			{
				l1get( 0x8001 | ( port << 8 ) );
				flushed[port]++;
				pending[port] = 0;
			}
			none_last_time[port] = 1;
		}
		else
			none_last_time[port] = 0;
		if( sentdata[port] )
			pending[port] = 0;
		sentdata[port] = 0;
		decEI();
	}
}

#endif

/**************************************************************************\
*                                                                          *
* "uppercase"                                                              *
*                                                                          *
* Zeichen c in Grossbuchstabe umwandeln, wenn Kleinbuchstabe, und          *
* zurueckgeben.                                                            *
*                                                                          *
\**************************************************************************/

upcase(c)
register char c;
  {
    return ( ('a' > c || 'z' < c) ? c : c - ('a' - 'A') );
  }

