#include <stdio.h>
#include <dos.h>
#include "..\all.h"
#include "..\tntyp.h"		/* Definition of structures		     */
#include "..\ip.h"	
#include "..\icmp.h"

ARP arp;


/* *********************************************************************
 * simple test harness for thenet x-1j
 * (c) D Roberts G8KBB 1991 
 * you are free to use this for amateur, non commercial non profit use only
 *
 * It allows the thenet software to be run on a PC connected to a KISS
 * tnc. It does not support all features and is designed to allow test
 * procedures on the protocols. It should ideally be run under a debugger.
 * To exit the program, use control-b. DO NOT USE CONTROL-C !!!!!!!!!!!!
 *
 * ********************************************************************/

/* *********************************************************************
 * set default parameters in place of tnl1.mac routines
 *
 * ********************************************************************/

unsigned DEFTLI = 10;
unsigned DEFCH0 = 10;
unsigned DEFCH1 = 10;
unsigned DEFCON = 4;
unsigned DEFDES = 100;
unsigned DEFPER = 64;
unsigned DEFTBS = 180;
unsigned DEFTWI = 4;
unsigned DEFSLO = 10;
unsigned DEFTTO = 300;
unsigned DEFLT2 = 100;
unsigned DEFLT3 = 18000;
unsigned DEFL2T = 10;
unsigned DEFTTR = 2;
unsigned DEFWQU = 1;
unsigned DEFBEA = 2;
unsigned DEFOBB = 5;
unsigned DEFOBC = 6;
unsigned DEFTAC = 6;
unsigned DEFCQ  = 1;
unsigned DEFMAF = 2;
unsigned DEFNOA = 900;
unsigned DEFRPA = 1;		/* enable digi for test reasons */
unsigned DEFRAK = 5;
unsigned DEFVAL = 1;
unsigned DEFBRI = 1800;
unsigned char DEFXFP = 0;
unsigned char DEFDPA = 0;
unsigned char DEFTP = 30;
unsigned char DEFESC = 0x1b;
unsigned char DEFIDE[6] = {'#','E','S','D','G','#'};
unsigned char DEFCAL[] = {'G','8','K','B','B',' ', 0x60 };
unsigned char DEFINF[]  = {"ESDG\rTheNet X-1G ( based on TheNet 1.01 )\rTest version by G8KBB"};
unsigned char DEFPWD[]  = {"QPCGTIAORENBYSWI49DH10935D 5639DJCFHG   JFHGUH863TGDGBSHGQHQJSLFDL 58FJDHDTSR   "};

unsigned char DEICNT = 0;
unsigned      DEFCW = 1800;
unsigned char DEFKIS = 0;
unsigned char DEFHOS = 0;
unsigned char DEFBBS = 1;
unsigned char DEFCWS = 7;
unsigned char DEFMHL = 10;
unsigned char DEFBCN = 3;
unsigned char DEFALG = 0;
unsigned DEFBR1 = 0;
unsigned DEFBIN = 900;
unsigned char DEFCSB = 0;
unsigned DEFNOHASH = 0;
unsigned char DEFHLP = 31;
#ifdef IPROUTE
unsigned long DEFIPBCAST = (44L<<24)+(131L<<16)+0;
unsigned long DEFMYIPADDR = (44L<<24)+(131L<<16)+(16<<8)+83;
unsigned char DEFIPTTL = 10;
unsigned char DEFIPL2MODES = 3;
unsigned char DEFIPENABLE = 1;
#endif
#ifdef CWID
unsigned char calper, caltog;
#endif
#ifdef MOD_MTU
unsigned DEF_MTU_IP0 = 256;
unsigned DEF_MTU_IP1 = 256;
unsigned DEF_MTU_IPN = 256-20;
unsigned DEF_MTU_I_MAX = 257;
unsigned DEF_MTU_L2_MAX = 256+72;
#endif
#ifdef METERS
unsigned char DEFRECONNECT = 0;
unsigned char DEFNO_SLIME = 0;
unsigned char DEFNO_DIGI = 0;
unsigned char DEFDEVMETER = 255;
unsigned      DEFMETERFLAGS = 3;
unsigned char DEFRXSIGMIN = 50;
unsigned char DEFRXSMETER = 100;
unsigned char DEFRXDB = 50;
signed char DEFDBFLOOR = 120;
unsigned char DEFMULT1 = 1;
unsigned char DEFMULT2 = 100;
unsigned char DEFOFS1 = 0;
unsigned char DEFOFS2 = 127;
unsigned char sig_level;
#endif

char beadil[] = "";

#ifdef MANAGED
char AudCon[] = "C ";
char AudConAcc[] = "CA";
char AudDisc[] = "D ";
char AudDiscAcc[] = "DA";
#endif

char helpmsg[] = "This is the help text\nwhich is a bit thin in the demo!";


/* *********************************************************************
 * The 'memory' block simulaes ram in the TNC used for buffers
 *
 * ********************************************************************/

unsigned char memblock[32768];

/* *********************************************************************
 * These are used in TheRing software modifications only
 *
 * ********************************************************************/

unsigned tnc_connected = 0;	/* 0 TO DISABLE RS232 XMIT, 1 TO ENABLE */
int comport = 0;		/* 0 == COM1:, 1 == COM2: ETC */
int cominit = 0xc3;		/* com port baud rate etc setup */

unsigned bauds[] = { 300,600,1200,2400,4800,9600 };
unsigned char inits[] = { 0x43,0x63,0x83,0xa3,0xc3,0xe3 };
 
/* *********************************************************************
 * start here in place of tnc power on reset.
 * start the clock going, initialise rs232 link, clear memory block
 * just in case, then execute mainf ( in place of tnl1.mac )
 * ********************************************************************/

main( argc, argv )
char *argv[];
{
	unsigned baud, channel, i;

	if( argc == 1 )
		tnc_connected = 0;	/* 0 TO DISABLE RS232 XMIT, 1 TO ENABLE */
	else
	{
		baud = atoi( argv[1] );
		if( argc > 2 )
		{
			channel = atoi( argv[2] );
			if( channel < 1 || channel > 4 )
			{
				printf("Error - invalid channel number\n");
				exit(1);
			}
			comport = channel-1;
		}
		for(i=0;i<sizeof(bauds);i++)
			if( baud == bauds[i] )
				break;
		if( i == sizeof( bauds ) )
		{
			printf("Error - invalid baud rate\n");
			exit(2);
		}
		cominit = inits[i];
		tnc_connected = 1;
	}
	setticker();					/* INSTALL TICK */
	if( tnc_connected )
		comsetup();					/* INIT RS232 */
	memset( memblock, 0, sizeof( memblock ) );	/* ENSURE COLD START */
	mainf();					/* START TheNet */
}

/* ******************************************************************* *
 * ERRORS OR MISSING BITS FROM THE SOURCE CODE AND OTHER CORRECTIONS   *
 * ******************************************************************* */

seades( call )
char *call;
{
	return( iscall( call ) );
}

/* *********************************************************************
 * SIMPLE VERSIONS OF THENET RUNTIME ROUTINES FOR TEST HARNESS       
 *
 *
 * ********************************************************************/

reset()
{
	L1INIT();
}

L1INIT()
{
	HOINIT();
}

HOINIT()
{
}

/* return true if there is a keyboard char ready from the pc
 * as if it has come from the host port
 */

ishget()
{
	return( kbhit() & 1 );
}

ishput()
{
	return( 0 );
}

/* read a keyboard character. If it is control-b, clean up and exit.
 * If not, return the character
 */

hgetc()
{
	int c;
	
	c = getch();
	
	if( c == 2 )
	{
		removeticker();
		exit();
	}
	return( c );
}

/* display a character on the screen in lieu of the host port
*/

hputc(c)
int c;
{
	putchar( c );
}

/* simulate checking of the host port. If flag is for hldc port,
 * say it is ready ( coz a KISS port will be !! ), but if it
 * is for crossconnect, say it is not ( coz there is none here ! )
 */

iscd( port )
unsigned port;
{
	if( port == 1 )
		return( 0 );
	return( 1 );
}

/* no need on the PC to enable interrupts, but go thru the motions 
 */

decEI()
{
	DEICNT--;
}

/* ditto no need to disable interrupts !
 */

DIinc()
{
	DEICNT++;
}

/* successful execution of the STAled and CONled routines
 * gives a message on the screen
 */

CONled( flag )
unsigned flag;
{
	cprintf("\r\nCONNECT LED : %s\r\n", flag ? "ON" : "OFF" );
}

STAled( flag )
unsigned flag;
{
	cprintf("\r\nSTATUS LED : %s\r\n", flag ? "ON" : "OFF" );
}

/* return a random 8 bit number
 */

random()
{
	return( rand() & 0xff );
}

/* simulate the limits of the free ram by pointing to the ram memory block
 */

char *maxmem()
{
	return( &memblock[ sizeof( memblock ) - 1 ] );
}

char *minmem()
{
	return( memblock );
}

/* this is the main send routine, for a KISS tnc.
 */

kicktx( port )
{
	unsigned int c;
	
	if( port )				/* host port */
	{
		outprintf("\r\nHost:", 0 );
		do {				/* until eom mark, */
			c = l1get(0x8101);	/* ask for data */
			outprintf(" %2x",c);	/* and display it */
		}while( c <= 0xff );
		outprintf("\r\n", 0 );
	}
	else					/* hdlc port */
	{
		outprintf("\r\nHDLC:", 0);
		hdlcout( 0xc0 );		/* send KISS start */
		hdlcout( 0 );			/* send KISS data signal */
		do {				/* until eom mark, */
			c = l1get(0);		/* get a byte of data */
			if( c <= 0xff )		/* if valid data, then */
				hdlcsend( c );	/* send to TNC */
		}while( c <= 0xff );		/* repeat for whle frame */
		hdlcout( 0xc0 );		/* send KISS end signal */
		outprintf("\r\n", 0 );
	}
}

/* as there is no difference between half and full duplex, there
 * is no need here for pushtx(), but it should really be implemented.
 */

pushtx()
{
}

/* **************************************************************** */
/* KISS I/O OPERATIONS - OUTPUT AND INPUT 			    */

int ipstate = 0;		/* state of the input routine */

inputdata()
{
	unsigned c;

	while( instatus() & 0x100 )	/* whilst there is input data */
	{
		c = indata();		/* get it from TNC */
		switch( ipstate )	/* handle according to state */
		{
			case 0:		/* not receiving */
				if( c == 0xc0 )
				{
					inprintf("\r\nINPUT: %2x",c);
					ipstate = 3;
					l1put( 0x8001 );
				}
				break;
			case 3:		/* wait for null */
				inprintf(" %2x",c);
				switch( c )
				{
					case 0:
						ipstate = 1;
						break;
					case 0xc0:
						l1put( 0x8001 );
						break;
					default:
						ipstate = 0;
				}
				break;
			case 1:		/* inputting data */
				inprintf(" %2x",c);
				switch( c )
				{
					case 0xc0:
#ifdef METERS
						sig_level = random();
#endif
						l1put( 0x8000 );
						ipstate = 0;
						break;
					case 0xdb:
						ipstate = 2;
						break;
					default:
						l1put( c );
				}
				break;
				
			case 2:		/* FESC KISS char */
				inprintf(" %2x",c);
				switch( c )
				{
					case 0xdc:
						l1put( 0xc0 );
						break;
					case 0xdd:
						l1put( 0xdb );
						break;
					default:
						l1put( c );
				}
				ipstate = 1;
				break;
			default:
				inprintf(" %2x",c);
				l1put( c );
		}
	}
}

/* send a character to hdlc port, with KISS ESCAPE processing
 */

hdlcsend( c )
{
	switch( c )
	{
		case 0xc0:			/* if you get frame start */
			hdlcout( 0xdb );	/* then send the esc char */
			hdlcout( 0xdc );	/* followed by the char */
			break;
		case 0xdb:
			hdlcout( 0xdb );	/* ditto for escape */
			hdlcout( 0xdd );
			break;
		default:
			hdlcout( c );
	}
}

hdlcout( c )
{
	outprintf(" %2x",c);
	outdata( c );
}


/* **************************************************************** */
/* LOW LEVEL RS232 I/O OPERATIONS - STATUS, OUTPUT, INPUT AND RESET */



instatus()
{										
	union REGS inregs, outregs;

	inregs.x.dx = comport;
	inregs.h.ah = 3;
	int86( 0x14, &inregs, &outregs );
	return( outregs.x.ax );
}

indata()
{										
	union REGS inregs, outregs;

	inregs.x.dx = comport;
	inregs.h.ah = 2;
	int86( 0x14, &inregs, &outregs );
	return( outregs.h.al );
}

outdata( c )
{
	union REGS inregs, outregs;
	
	inregs.h.ah = 1;
	inregs.x.dx = comport;
	inregs.h.al = c;
	if( tnc_connected )
		int86( 0x14, &inregs, &outregs );
}

comsetup()
{
	union REGS inregs, outregs;
	
	inregs.h.ah = 0;
	inregs.x.dx = comport;
	inregs.h.al = cominit;
	int86( 0x14, &inregs, &outregs );	/* reset the port */
	inregs.h.ah = 4;
	inregs.x.dx = comport;
	inregs.h.al = 0;
	int86( 0x14, &inregs, &outregs );	/* check combios loaded */
	if( outregs.x.ax != 0xaa55 )
	{
		printf("Error - Please load combios first\n");
		exit(1);
	}
	while( instatus() & 0x100 )		/* clear i/p buffer */
		indata();
	inregs.h.ah = 6;
	inregs.x.dx = comport;
	inregs.h.al = 0;
	int86( 0x14, &inregs, &outregs );	/* raise rts & dtr */
}


/*********************************************************
 * simple console debugging functions 
 * ******************************************************/

int showinput = 0;	/* set to 0 to disable display if i/p frames */
int showoutput = 0;	/* set to 0 do disable display of o/p frames */

inprintf( s, c )
char *s;
int c;
{
	if( showinput )
		cprintf( s, c );
}

outprintf( s, c )
char *s;
int c;
{
	if( showoutput )
		cprintf( s, c );
}

/* *************************************************************** */

#ifdef HOSTMODE

raisedcd()
{
}

dropdcd()
{
}

unsigned char SIBRR0;

ishost()
{
	return( 1 );
}

#endif


#ifdef CLOSEDOWN
stop()
{
	removeticker();
	exit(255);
}
#endif
