/*
Program: X1JCONV.C 1.1 (c) 1994
Date: 02-JUL-94
Updates: 07-JUL-94
         Fix search routine to allow 'Net/Rom' on Iproute line.
Author: Ken Chamberlain, N8PTT.AMPR.ORG [44.70.179.1]
                 Packet: N8PTT@W8FT.#NWOH.OH.USA.NOAM
                 Internet: N8PTT@CRIS.COM
Function: Converts the 'record'ed output of an X1J display of
   of the following commands to a file suitable for loading back to X1J.
   ipaddress
   iproutes
   arp
   routes
   mode      <- only 1 line of output (it SHOULD fit)
   parm      <- due to size of parm each entry is on a seperate line
 
Comments:
   This program is use for Amateur Radio only.
   It may be freely copied for such use provided its source is acknowledged.
   It may not be used for commercial purposes.
   Written using X1J Version 2 displays, untested w/ other version of X1J.
   No Warranty is Implied or Expressed by the Author and
     accepts NO responsible for anything this program may
     destroy on purpose or by accident.
 
   The mode & parm routines depend in finding the word 'mode' and
     and the word 'parm' in the capture file so I know the following
     rcds in the file contain the information. I'm working on a better
     way to do this and will probably be in version 1.2
 
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
char author[] = "X1JCONV 1.1 Written by Ken Chamberlain N8PTT (c) 1994";
FILE *f1,*f2;                      /* input & output FILE(s)        */
#define MAXLEN 80                  /* max input rcd length (I hope) */
void isiprec(void);                /* build the IP rcd              */
void isarp(void);                  /* build the ARP rcd             */
void isroute(void);                /* build the ROUTES rcd          */
void ismyip(void);                 /* build the IPADDRESS rcd       */
void ismode(void);                 /* build the MODE rcd            */
void isparm(void);                 /* build the PARM rcd            */
void moveparm(void);               /* Move the data for PARM        */
void writeme(void);                /* output writer                 */
int nxtnblk(int);                  /* find next non-blank byte      */
int nxtblk(int);                   /* find next blank byte          */
char buf[80],outbuf[70],oldbuf[80];
int DEBUG;
int outcnt,incnt,cnt;
int cntr = 1;
int cntr2 = 0;
static isiport = 1;
char work[5];
static int howmanyin,howmanyout;
char *isip;
char *sa,*ptr;
void main(int argc,char *argv[])
{
 if(argc < 3)
  {
   printf("X1JCONV 1.2 converts a 'record'ed capture of X1J display output\n");
   printf("        to a file suitable for re-loading back to the X1J.\n");
   printf("        supports output of: ipaddr,ip,arp,r,mode, & parms\n");
   printf("        2 args need: x1jconv infile outfile\n");
   exit(1);
  }
 printf("Input File: %s, Output File: %s\n",argv[1],argv[2]);
 if((f1 = fopen(argv[1],"r")) == NULL)
   {
    fprintf(stderr,"Cannot open input file.\n");
    exit(1);
   }
 if((f2 = fopen(argv[2],"w")) == NULL)
   {
    fprintf(stderr,"Cannot open output file.\n");
    exit(1);
   }
 DEBUG = 0;                        /* default DEBUG is OFF */
 if(argv[3] != NULL)               /* got a 3rd parm????   */
  {
   if(!strcmp(argv[3],"debug"))    /* .. is it 'debug'???  */
    DEBUG = 1;                     /* .. yep, turn DEBUG 'on' */
  }
 while((sa = fgets(buf,MAXLEN,f1)) != NULL)  /* grab some data */
  {
   howmanyin++;                    /* keep count as to how many I've read */
   sa = sa;                        /* eliminate stupid compiler msg */
   if(DEBUG)                       /* DEBUG 'on'??? */
    {
     isip = strchr(buf,'\n');        /* see if has \n already here */
     if(isip)
      printf("Converting: %s",buf);  /* yep... display input rcd w/o \n */
     else
      printf("Converting: %s\n",buf); /* nope... display input w/ \n */
    }
   isip = buf+20;                        /* see if 'AX.25' ARP   */
   if(!strncmp(isip,"AX.25",5))
    {
     isarp();                            /* go build ARP rcd     */
     writeme();                          /* write it out         */
    }
   if(!strncmp(isip,"Net/Rom",7))        /* see if 'Net/Rom' ARP */
    {
     isarp();                            /* go build arp rcd     */
     writeme();                          /* write it out         */
    }
   isip = buf+22;                        /* see if ip define     */
   if(!strncmp(isip,"Net/Rom",7))        /* see if ip define     */
    {
     isiport = 0;
     isiprec();                         /* go build ip rcd       */
     writeme();                         /* write it out          */
    }
   if(!strncmp(isip,"Port",4))           /* see if ip define     */
    {
     isiport = 1;
     isiprec();                         /* go build ip rcd       */
     writeme();                         /* write it out          */
    }
   isip = strstr(buf,"!");              /* see if locked 'route' */
   if(isip)
    {
     isroute();                         /* go build routes rcd   */
     writeme();                         /* write it out          */
    }
   isip = strstr(buf,"My IP address");  /* see if 'My IP address'*/
   if(isip)
    {
     ismyip();                          /* go build My Ip rcd    */
     writeme();                         /* write it out          */
    }
   isip = strstr(buf,"mode");           /* see if 'mode' display */
   if(isip)
    {
     ismode();                          /* go build 'mode' rcd   */
     writeme();                         /* write it out          */
    }
   isip = strstr(buf,"parm");           /* see if 'parm' display */
   if(isip)
    {
     isparm();                          /* go build 'parm' rcd   */
                                        /* DON'T write this one  */
    }
   memset(buf,' ',80);                  /* clear the input work area */
  }
 fclose(f1);                            /* close my input file  */
 fclose(f2);                            /* close my output file */
 printf("%d records read, %d records converted.\n",howmanyin,howmanyout);
}
void writeme()
{
 if(DEBUG)
  printf("Output Str: %s\n",outbuf);  /* display the output to console */
 strcat(outbuf,"\n");                 /* append the newline */
 fputs(outbuf,f2);                    /* write out the record */
 howmanyout++;                        /* keep count of how many */
}
void ismode()
{
 if((sa = fgets(buf,MAXLEN,f1)) == NULL)  /* grab some data */
  {
   printf("mode rcd failure, missing 1st rcd after 'mode' string\n");
   exit(2);
  }
 memset(outbuf,' ',70);
 outbuf[69] = '\0';
 memcpy(outbuf,"mode ",5);
 incnt = 0;outcnt = 5;
 ptr = strchr(buf,'}');            /* look for fuzzy bracket */
 incnt = ptr - buf;                /* get where it is        */
 incnt = nxtnblk(++incnt);         /* find the mode string   */
 while(buf[incnt] != '\n' && buf[incnt] != '\0')
  outbuf[outcnt++] = buf[incnt++];
 outbuf[outcnt] = '\0';            /* mark end-of-rcd        */
}
void isparm()
{
 if((sa = fgets(buf,MAXLEN,f1)) == NULL)  /* grab some data */
  {
   printf("parm rcd failure, missing 1st rcd after 'parm' string\n");
   exit(2);
  }
 ptr = strchr(buf,'}');            /* look for fuzzy bracket */
 incnt = ptr - buf;                /* get where it is        */
 incnt++;                          /* jump over it           */
 incnt = nxtnblk(++incnt);         /* find the mode string   */
 moveparm();
 if((sa = fgets(buf,MAXLEN,f1)) == NULL)  /* grab some more data */
  {
   printf("parm rcd failure, missing 2nd rcd after 'parm' string\n");
   exit(2);
  }
 incnt = 0;
 moveparm();
}
void moveparm()
{
 while(incnt != -1)
  {
   incnt = nxtnblk(incnt);
   if(incnt != -1)
    {
     memset(outbuf,' ',70);
     outbuf[69] = '\0';
     memcpy(outbuf,"mode  / ",8);
     itoa(cntr++,work,10);
     outcnt = 8;cntr2 = 0;
     while(work[cntr2] != '\0')
      outbuf[outcnt++] = work[cntr2++];
     outcnt++;
     while(buf[incnt] != ' ' && buf[incnt] != '\n' && buf[incnt] != '\0')
      outbuf[outcnt++] = buf[incnt++];
     if(buf[incnt] == '\n' || buf[incnt] == '\0')
      incnt = -1;
     outbuf[outcnt] = '\0';
     writeme();
    }
  }
}
void ismyip()
{
 memset(outbuf,' ',70);
 outbuf[69] = '\0';
 memcpy(outbuf,"ipaddress ",10);
 incnt = 0;outcnt = 10;
 ptr = strchr(buf,'}');            /* look for fuzzy bracket */
 ptr = strchr(ptr,':');             /* .. now look for :      */
 incnt = ptr - buf;                /* get where it is        */
 incnt = nxtnblk(++incnt);         /* find the IP address    */
 while(buf[incnt] != ' ' && buf[incnt] != '\n' && buf[incnt] != '\0')
  outbuf[outcnt++] = buf[incnt++];
 outbuf[outcnt] = '\0';            /* mark end-of-rcd        */
}
void isroute()
{
 memset(outbuf,' ',70);
 outbuf[69] = '\0';
 memcpy(outbuf,"routes ",7);
 incnt = 0;outcnt = 7;
 incnt = nxtnblk(incnt);           /* get 1st non-blank */
 if(buf[incnt] == '>')             /* check for > */
  {                                /* if found bump around it */
   incnt++;                        /* .. bump over it */
   incnt = nxtnblk(incnt);         /* .. and find next non-blank */
  }
 outbuf[outcnt++] = buf[incnt++];  /* move in the port number */
 outcnt++;                         /* need a space here */
 ptr = strchr(buf,':');            /* look for the : seperator */
 if(!ptr)
  {
   printf("Route record missing : delimiter, aborting......\n");
   printf("%s\n",buf);
   exit(4);
  }
 incnt = ++ptr - buf;              /* point to Callsign */
 while(buf[incnt] != ' ')
  outbuf[outcnt++] = buf[incnt++];
 outcnt++;
 outbuf[outcnt++] = '+';          /* move in + sign */
 outcnt++;
 incnt = nxtnblk(incnt);
 while(buf[incnt] != ' ')         /* point to PathQuality */
  outbuf[outcnt++] = buf[incnt++];
 outbuf[outcnt] = '\0';
}
void isarp()
{
 memset(outbuf,' ',70);
 outbuf[69] = '\0';
 memcpy(outbuf,"arp ",4);
 incnt = 0;outcnt = 4;
 for(cnt=0;cnt < 20;cnt++)         /* copy the IP address */
  {
   if(buf[incnt] == ' ') break;
   outbuf[outcnt++] = buf[incnt++];
  }
 outcnt++;
 outbuf[outcnt++] = '+';          /* put in the + sign          */
 outcnt++;                        /* need a space here          */
 incnt = nxtnblk(incnt);          /* find the next non-blank    */
 if(buf[incnt] == 'P')            /* is this a 'Published' ARP? */
  {
   outbuf[outcnt++] = buf[incnt++]; /* .. copy the 'P' string   */
   outcnt++;                      /* need a space here          */
   incnt = nxtnblk(incnt);        /* bump down to hw-type       */
  }
 while(buf[incnt] != ' ')         /* move in the hw-type string */
  outbuf[outcnt++] = buf[incnt++];  /* .. 1 byte at a time      */
 outcnt++;                        /* need a space here          */
 incnt = nxtnblk(incnt);   /* bump down to Callsign and move to output */
 while(buf[incnt] != ' ' && buf[incnt] != NULL && buf[incnt] != '\n')
  outbuf[outcnt++] = buf[incnt++]; /* move in Callsign byte at a time */
 outcnt++;
 incnt = nxtnblk(incnt);           /* bounce down to Mode */
 if(incnt != -1)                   /* if != -1 then a Mode is here */
 while(buf[incnt] != ' ' && buf[incnt] != NULL && buf[incnt] != '\n')
  outbuf[outcnt++] = buf[incnt++]; /* move in Mode (VG/DG) */
 outbuf[outcnt] = '\0';           /* mark the end-of-rcd        */
}
void isiprec()
{
 memset(outbuf,' ',70);
 outbuf[69] = '\0';
 memcpy(outbuf,"iproute ",8);
 incnt = 0;outcnt = 8;
 for(cnt=0;cnt < 20;cnt++)         /* copy the IP address */
  {
   if(buf[incnt] == ' ') break;
   outbuf[outcnt++] = buf[incnt++];
  }
 incnt = nxtnblk(incnt);          /* find the next non-blank */
 if(strncmp(buf+incnt,"32",2))    /* see if Len is 32      */
  {                               /* if not then append it */
   outbuf[outcnt++] = '/';
   while(buf[incnt] != ' ')
    outbuf[outcnt++] = buf[incnt++];
  }
 else
  incnt += 2;
outcnt++;                         /* put a space here */
incnt = nxtnblk(incnt);           /* look for 'Port' string */
if(isiport)
 {
  incnt = nxtblk(incnt);            /* .. jump over it      */
  incnt = nxtnblk(incnt);           /* look for Port number */
 }
outbuf[outcnt++] = '+';           /* move in + and a space */
outbuf[++outcnt] = buf[incnt++];  /* move in Port number */
outcnt += 2;
incnt = nxtblk(incnt);            /* look for Gateway address */
incnt = nxtnblk(incnt);           /* look for Gateway address */
if(incnt != -1)                    /* move in Gateway IP address */
 {
  while(buf[incnt] != ' ' && buf[incnt] != NULL && buf[incnt] != '\n')
   outbuf[outcnt++] = buf[incnt++];
  outcnt++;
 }
 outbuf[outcnt] = '\0';
}
int nxtnblk(int ishere)            /* find the next non-blank byte    */
{
 int work;
 for(work = ishere;work <= ishere + 20;work++)
  {
   if(buf[work] != ' ' && buf[work] != NULL && buf[work] != '\n')
    return work;
  }
return -1;                         /* nohit within 20 bytes, return -1*/
}
int nxtblk(int ishere)             /* find the next blank byte        */
{
 int work;
 for(work = ishere;work < ishere + 20;work++)
  {
   if(buf[work] == ' ' && buf[work] != NULL && buf[work] != '\n')
    return work;
  }
return -1;                         /* nohit within 20 bytes, return -1*/
}
