/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.admin.CloneConfiguration;

public class CloneConfigurationImpl
implements CloneConfiguration,
CloneConfiguration.Builder {
    private boolean built = false;
    private boolean flush = true;
    private Map<String, String> propertiesToSet = null;
    private Set<String> propertiesToExclude = null;
    private boolean keepOffline = false;

    @Override
    public boolean isFlush() {
        Preconditions.checkState((boolean)this.built);
        return this.flush;
    }

    @Override
    public Map<String, String> getPropertiesToSet() {
        Preconditions.checkState((boolean)this.built);
        return this.propertiesToSet == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.propertiesToSet);
    }

    @Override
    public Set<String> getPropertiesToExclude() {
        Preconditions.checkState((boolean)this.built);
        return this.propertiesToExclude == null ? Collections.emptySet() : Collections.unmodifiableSet(this.propertiesToExclude);
    }

    @Override
    public boolean isKeepOffline() {
        Preconditions.checkState((boolean)this.built);
        return this.keepOffline;
    }

    @Override
    public CloneConfiguration.Builder setFlush(boolean flush2) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.flush = flush2;
        return this;
    }

    @Override
    public CloneConfiguration.Builder setPropertiesToSet(Map<String, String> propertiesToSet) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.propertiesToSet = propertiesToSet;
        return this;
    }

    @Override
    public CloneConfiguration.Builder setPropertiesToExclude(Set<String> propertiesToExclude) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.propertiesToExclude = propertiesToExclude;
        return this;
    }

    @Override
    public CloneConfiguration.Builder setKeepOffline(boolean keepOffline) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.keepOffline = keepOffline;
        return this;
    }

    @Override
    public CloneConfiguration build() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0);
        this.built = true;
        return this;
    }

    public String toString() {
        return "{flush=" + this.flush + ", propertiesToSet=" + String.valueOf(this.propertiesToSet) + ", propertiesToExclude=" + String.valueOf(this.propertiesToExclude) + ", keepOffline=" + this.keepOffline + ", built=" + this.built + "}";
    }
}

