/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.blockfile.impl.CacheProvider;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class SequenceFileIterator
implements FileSKVIterator {
    private final SequenceFile.Reader reader;
    private Value top_value;
    private Key top_key;
    private final boolean readValue;

    public SequenceFileIterator deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException("SequenceFileIterator does not yet support cloning");
    }

    @Override
    public void closeDeepCopies() throws IOException {
        throw new UnsupportedOperationException();
    }

    public SequenceFileIterator(SequenceFile.Reader reader, boolean readValue) throws IOException {
        this.reader = reader;
        this.readValue = readValue;
        this.top_key = new Key();
        if (readValue) {
            this.top_value = new Value();
        }
        this.next();
    }

    @Override
    public Key getTopKey() {
        return this.top_key;
    }

    @Override
    public Value getTopValue() {
        return this.top_value;
    }

    @Override
    public boolean hasTop() {
        return this.top_key != null;
    }

    @Override
    public void next() throws IOException {
        boolean valid = this.readValue ? this.reader.next((Writable)this.top_key, (Writable)this.top_value) : this.reader.next((Writable)this.top_key);
        if (!valid) {
            this.top_key = null;
            this.top_value = null;
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        throw new UnsupportedOperationException("seek() not supported");
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Key getFirstKey() throws IOException {
        throw new UnsupportedOperationException("getFirstKey() not supported");
    }

    @Override
    public Key getLastKey() throws IOException {
        throw new UnsupportedOperationException("getLastKey() not supported");
    }

    @Override
    public DataInputStream getMetaStore(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long estimateOverlappingEntries(KeyExtent extent) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSKVIterator getSample(SamplerConfigurationImpl sampleConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCacheProvider(CacheProvider cacheProvider) {
    }
}

