/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.coordinator.SharedBatchWriter;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionFinalState;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Timer;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionFinalizer {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionFinalizer.class);
    protected final ServerContext context;
    private final ExecutorService notifyExecutor;
    private final ExecutorService backgroundExecutor;
    private final BlockingQueue<ExternalCompactionFinalState> pendingNotifications;
    private final long tserverCheckInterval;
    private final ConcurrentHashMap<Character, SharedBatchWriter> writers = new ConcurrentHashMap(16);
    private final int queueSize;

    protected CompactionFinalizer(ServerContext context, ScheduledThreadPoolExecutor schedExecutor) {
        this.context = context;
        this.queueSize = context.getConfiguration().getCount(Property.COMPACTION_COORDINATOR_FINALIZER_QUEUE_SIZE);
        this.pendingNotifications = new ArrayBlockingQueue<ExternalCompactionFinalState>(this.queueSize);
        this.tserverCheckInterval = this.context.getConfiguration().getTimeInMillis(Property.COMPACTION_COORDINATOR_FINALIZER_COMPLETION_CHECK_INTERVAL);
        int max = this.context.getConfiguration().getCount(Property.COMPACTION_COORDINATOR_FINALIZER_TSERVER_NOTIFIER_MAXTHREADS);
        this.notifyExecutor = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.COORDINATOR_FINALIZER_NOTIFIER_POOL).numCoreThreads(3).numMaxThreads(max).withTimeOut(1L, TimeUnit.MINUTES).enableThreadPoolMetrics().build();
        this.backgroundExecutor = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.COORDINATOR_FINALIZER_BACKGROUND_POOL).numCoreThreads(1).enableThreadPoolMetrics().build();
        this.backgroundExecutor.execute(() -> this.processPending());
        ThreadPools.watchCriticalScheduledTask(schedExecutor.scheduleWithFixedDelay(this::notifyTservers, 0L, this.tserverCheckInterval, TimeUnit.MILLISECONDS));
    }

    private SharedBatchWriter getWriter(ExternalCompactionId ecid) {
        return this.writers.computeIfAbsent(ecid.getFirstUUIDChar(), prefix -> new SharedBatchWriter(Ample.DataLevel.USER.metaTable(), (Character)prefix, this.context, this.queueSize / 16));
    }

    public void commitCompaction(ExternalCompactionId ecid, KeyExtent extent, long fileSize, long fileEntries) {
        ExternalCompactionFinalState ecfs = new ExternalCompactionFinalState(ecid, extent, ExternalCompactionFinalState.FinalState.FINISHED, fileSize, fileEntries);
        SharedBatchWriter writer = this.getWriter(ecid);
        LOG.trace("Initiating commit for external compaction: {} {}", (Object)ecid, (Object)ecfs);
        Timer timer = Timer.startNew();
        writer.write(ecfs.toMutation());
        LOG.trace("{} metadata compaction state write completed in {}ms", (Object)ecid, (Object)timer.elapsed(TimeUnit.MILLISECONDS));
        if (!this.pendingNotifications.offer(ecfs)) {
            LOG.trace("Queue full, notification to tablet server will happen later {}.", (Object)ecid);
        } else {
            LOG.trace("Queued tserver notification for completed external compaction: {}", (Object)ecid);
        }
    }

    public void failCompactions(Map<ExternalCompactionId, KeyExtent> compactionsToFail) {
        Map.Entry<ExternalCompactionId, KeyExtent> e;
        ExternalCompactionFinalState ecfs;
        if (compactionsToFail.size() == 1) {
            Map.Entry<ExternalCompactionId, KeyExtent> e2 = compactionsToFail.entrySet().iterator().next();
            ExternalCompactionFinalState ecfs2 = new ExternalCompactionFinalState(e2.getKey(), e2.getValue(), ExternalCompactionFinalState.FinalState.FAILED, 0L, 0L);
            this.getWriter(e2.getKey()).write(ecfs2.toMutation());
        } else {
            try (BatchWriter writer = this.context.createBatchWriter(Ample.DataLevel.USER.metaTable());){
                for (Map.Entry<ExternalCompactionId, KeyExtent> e3 : compactionsToFail.entrySet()) {
                    ExternalCompactionFinalState ecfs3 = new ExternalCompactionFinalState(e3.getKey(), e3.getValue(), ExternalCompactionFinalState.FinalState.FAILED, 0L, 0L);
                    writer.addMutation(ecfs3.toMutation());
                }
            }
            catch (MutationsRejectedException | TableNotFoundException e4) {
                throw new RuntimeException(e4);
            }
        }
        Iterator<Map.Entry<ExternalCompactionId, KeyExtent>> iterator = compactionsToFail.entrySet().iterator();
        while (iterator.hasNext() && this.pendingNotifications.offer(ecfs = new ExternalCompactionFinalState((e = iterator.next()).getKey(), e.getValue(), ExternalCompactionFinalState.FinalState.FAILED, 0L, 0L))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTserver(TabletMetadata.Location loc, ExternalCompactionFinalState ecfs) {
        Timer timer;
        TabletClientService.Client client;
        block6: {
            client = null;
            timer = Timer.startNew();
            try {
                client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)loc.getHostAndPort(), (ClientContext)this.context);
                if (ecfs.getFinalState() == ExternalCompactionFinalState.FinalState.FINISHED) {
                    LOG.trace("Notifying tserver {} that compaction {} has finished.", (Object)loc, (Object)ecfs);
                    client.compactionJobFinished(TraceUtil.traceInfo(), this.context.rpcCreds(), ecfs.getExternalCompactionId().canonical(), ecfs.getExtent().toThrift(), ecfs.getFileSize(), ecfs.getEntries());
                    break block6;
                }
                if (ecfs.getFinalState() == ExternalCompactionFinalState.FinalState.FAILED) {
                    LOG.trace("Notifying tserver {} that compaction {} with {} has failed.", new Object[]{loc, ecfs.getExternalCompactionId(), ecfs});
                    client.compactionJobFailed(TraceUtil.traceInfo(), this.context.rpcCreds(), ecfs.getExternalCompactionId().canonical(), ecfs.getExtent().toThrift());
                    break block6;
                }
                throw new IllegalArgumentException(ecfs.getFinalState().name());
            }
            catch (TException e) {
                try {
                    LOG.warn("Failed to notify tserver {}", (Object)loc.getHostAndPort(), (Object)e);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(client, (ClientContext)this.context);
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.context);
            }
        }
        ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.context);
        LOG.trace("Tserver {} notification of {} {} took {}ms", new Object[]{loc, ecfs.getExternalCompactionId(), ecfs, timer.elapsed(TimeUnit.MILLISECONDS)});
    }

    private void processPending() {
        while (!Thread.interrupted()) {
            try {
                Map tabletsMetadata;
                ArrayList<ExternalCompactionFinalState> batch = new ArrayList<ExternalCompactionFinalState>();
                batch.add(this.pendingNotifications.take());
                this.pendingNotifications.drainTo(batch);
                LOG.trace("Processing pending of batch size {}", (Object)batch.size());
                ArrayList futures = new ArrayList();
                ArrayList<ExternalCompactionId> statusesToDelete = new ArrayList<ExternalCompactionId>();
                List extents = batch.stream().map(ExternalCompactionFinalState::getExtent).collect(Collectors.toList());
                Timer timer = Timer.startNew();
                try (TabletsMetadata tablets = this.context.getAmple().readTablets().forTablets(extents).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.PREV_ROW, TabletMetadata.ColumnType.ECOMP}).build();){
                    tabletsMetadata = tablets.stream().collect(Collectors.toMap(TabletMetadata::getExtent, Function.identity()));
                }
                LOG.trace("Metadata scan completed in {}ms for batch size {}, found {}", new Object[]{timer.elapsed(TimeUnit.MILLISECONDS), batch.size(), tabletsMetadata.size()});
                for (ExternalCompactionFinalState ecfs : batch) {
                    TabletMetadata tabletMetadata = (TabletMetadata)tabletsMetadata.get(ecfs.getExtent());
                    if (tabletMetadata == null || !tabletMetadata.getExternalCompactions().containsKey(ecfs.getExternalCompactionId())) {
                        LOG.debug("Unable to find tablets external compaction entry, deleting completion entry {}", (Object)ecfs);
                        statusesToDelete.add(ecfs.getExternalCompactionId());
                        continue;
                    }
                    if (tabletMetadata.getLocation() != null && tabletMetadata.getLocation().getType() == TabletMetadata.LocationType.CURRENT) {
                        futures.add(this.notifyExecutor.submit(() -> this.notifyTserver(tabletMetadata.getLocation(), ecfs)));
                        continue;
                    }
                    LOG.trace("External compaction {} is completed, but there is no location for tablet.  Unable to notify tablet, will try again later.", (Object)ecfs);
                }
                if (!statusesToDelete.isEmpty()) {
                    timer.restart();
                    this.context.getAmple().deleteExternalCompactionFinalStates(statusesToDelete);
                    LOG.info("Deleted unresolvable completed external compactions from metadata table, ids: {} in {}ms", (Object)statusesToDelete.size(), (Object)timer.elapsed(TimeUnit.MILLISECONDS));
                    for (ExternalCompactionId ecid : statusesToDelete) {
                        LOG.debug("Deleted unresolvable completed external compaction {}", (Object)ecid);
                    }
                }
                long waitStart = System.currentTimeMillis();
                LOG.trace("Waiting for notify messages to complete");
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        LOG.debug("Failed to notify tserver", (Throwable)e);
                    }
                }
                LOG.trace("Notify messages completed in {}ms", (Object)(System.currentTimeMillis() - waitStart));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to process pending notifications", (Throwable)e);
            }
        }
    }

    private void notifyTservers() {
        Timer timer = Timer.startNew();
        try (Stream finalStatesStream = this.context.getAmple().getExternalCompactionFinalStates();){
            int count = 0;
            Iterator finalStates = finalStatesStream.iterator();
            while (finalStates.hasNext()) {
                ExternalCompactionFinalState state = (ExternalCompactionFinalState)finalStates.next();
                ++count;
                LOG.trace("Found external compaction in final state: {}, queueing for tserver notification", (Object)state);
                this.pendingNotifications.put(state);
            }
            LOG.trace("Added {} final compaction states to notification queue in {}ms", (Object)count, (Object)timer.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to notify tservers", (Throwable)e);
        }
    }
}

