/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt.strategy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.PrefetchSubscription;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.broker.region.virtual.VirtualTopicInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.transport.mqtt.MQTTProtocolConverter;
import org.apache.activemq.transport.mqtt.MQTTProtocolException;
import org.apache.activemq.transport.mqtt.MQTTProtocolSupport;
import org.apache.activemq.transport.mqtt.MQTTSubscription;
import org.apache.activemq.transport.mqtt.ResponseHandler;
import org.apache.activemq.transport.mqtt.strategy.MQTTSubscriptionStrategy;
import org.apache.activemq.util.LongSequenceGenerator;
import org.fusesource.mqtt.client.QoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMQTTSubscriptionStrategy
implements MQTTSubscriptionStrategy,
BrokerServiceAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMQTTSubscriptionStrategy.class);
    private static final byte SUBSCRIBE_ERROR = -128;
    protected MQTTProtocolConverter protocol;
    protected BrokerService brokerService;
    protected final ConcurrentMap<ConsumerId, MQTTSubscription> subscriptionsByConsumerId = new ConcurrentHashMap<ConsumerId, MQTTSubscription>();
    protected final ConcurrentMap<String, MQTTSubscription> mqttSubscriptionByTopic = new ConcurrentHashMap<String, MQTTSubscription>();
    protected final Set<String> restoredDurableSubs = Collections.synchronizedSet(new HashSet());
    protected final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();

    @Override
    public void initialize(MQTTProtocolConverter protocol) throws MQTTProtocolException {
        this.setProtocolConverter(protocol);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    public void setProtocolConverter(MQTTProtocolConverter parent) {
        this.protocol = parent;
    }

    @Override
    public MQTTProtocolConverter getProtocolConverter() {
        return this.protocol;
    }

    @Override
    public byte onSubscribe(org.fusesource.mqtt.client.Topic topic) throws MQTTProtocolException {
        String destinationName = topic.name().toString();
        QoS requestedQoS = topic.qos();
        MQTTSubscription mqttSubscription = (MQTTSubscription)this.mqttSubscriptionByTopic.get(destinationName);
        if (mqttSubscription != null) {
            if (requestedQoS != mqttSubscription.getQoS()) {
                this.onUnSubscribe(destinationName);
            } else {
                try {
                    this.onReSubscribe(mqttSubscription);
                }
                catch (IOException e) {
                    throw new MQTTProtocolException("Failed to find subscription strategy", true, e);
                }
                return (byte)requestedQoS.ordinal();
            }
        }
        try {
            return this.onSubscribe(destinationName, requestedQoS);
        }
        catch (IOException e) {
            throw new MQTTProtocolException("Failed while intercepting subscribe", true, e);
        }
    }

    @Override
    public void onReSubscribe(MQTTSubscription mqttSubscription) throws MQTTProtocolException {
        RegionBroker regionBroker;
        String topicName = mqttSubscription.getTopicName();
        try {
            regionBroker = (RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class);
        }
        catch (Exception e) {
            throw new MQTTProtocolException("Error subscribing to " + topicName + ": " + e.getMessage(), false, e);
        }
        TopicRegion topicRegion = (TopicRegion)regionBroker.getTopicRegion();
        ConsumerInfo consumerInfo = mqttSubscription.getConsumerInfo();
        ConsumerId consumerId = consumerInfo.getConsumerId();
        String connectionInfoClientId = this.protocol.getClientId();
        if (connectionInfoClientId == null || connectionInfoClientId.isEmpty()) {
            connectionInfoClientId = this.protocol.getConnectionId().toString();
        }
        ConnectionContext connectionContext = regionBroker.getConnectionContext(connectionInfoClientId);
        Set<Destination> matchingDestinations = topicRegion.getDestinations(mqttSubscription.getDestination());
        block4: for (Destination dest : matchingDestinations) {
            for (Subscription subscription : dest.getConsumers()) {
                if (!subscription.getConsumerInfo().getConsumerId().equals(consumerId)) continue;
                try {
                    if (dest instanceof Topic) {
                        ((Topic)dest).recoverRetroactiveMessages(connectionContext, subscription);
                    } else if (dest instanceof VirtualTopicInterceptor) {
                        ((VirtualTopicInterceptor)dest).getTopic().recoverRetroactiveMessages(connectionContext, subscription);
                    }
                    if (!(subscription instanceof PrefetchSubscription)) continue block4;
                    PrefetchSubscription prefetchSubscription = (PrefetchSubscription)subscription;
                    prefetchSubscription.dispatchPending();
                    continue block4;
                }
                catch (Exception e) {
                    throw new MQTTProtocolException("Error recovering retained messages for " + dest.getName() + ": " + e.getMessage(), false, e);
                }
            }
        }
    }

    @Override
    public ActiveMQDestination onSend(String topicName) {
        return new ActiveMQTopic(topicName);
    }

    @Override
    public String onSend(ActiveMQDestination destination) {
        return destination.getPhysicalName();
    }

    @Override
    public boolean isControlTopic(ActiveMQDestination destination) {
        return destination.getPhysicalName().startsWith("$");
    }

    @Override
    public MQTTSubscription getSubscription(ConsumerId consumerId) {
        return (MQTTSubscription)this.subscriptionsByConsumerId.get(consumerId);
    }

    protected ConsumerId getNextConsumerId() {
        return new ConsumerId(this.protocol.getSessionId(), this.consumerIdGenerator.getNextSequenceId());
    }

    protected byte doSubscribe(ConsumerInfo consumerInfo, final String topicName, final QoS qoS) throws MQTTProtocolException {
        MQTTSubscription mqttSubscription = new MQTTSubscription(this.protocol, topicName, qoS, consumerInfo);
        this.subscriptionsByConsumerId.put(consumerInfo.getConsumerId(), mqttSubscription);
        this.mqttSubscriptionByTopic.put(topicName, mqttSubscription);
        final byte[] qos = new byte[]{-1};
        this.protocol.sendToActiveMQ(consumerInfo, new ResponseHandler(){

            @Override
            public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                if (response.isException()) {
                    Throwable throwable = ((ExceptionResponse)response).getException();
                    LOG.warn("Error subscribing to {}", (Object)topicName, (Object)throwable);
                    qos[0] = AbstractMQTTSubscriptionStrategy.this.protocol.version == 4 ? -128 : (byte)qoS.ordinal();
                } else {
                    qos[0] = (byte)qoS.ordinal();
                }
            }
        });
        if (qos[0] == -128) {
            this.subscriptionsByConsumerId.remove(consumerInfo.getConsumerId());
            this.mqttSubscriptionByTopic.remove(topicName);
        }
        return qos[0];
    }

    public void doUnSubscribe(MQTTSubscription subscription) {
        this.mqttSubscriptionByTopic.remove(subscription.getTopicName());
        ConsumerInfo info = subscription.getConsumerInfo();
        if (info != null) {
            this.subscriptionsByConsumerId.remove(info.getConsumerId());
            RemoveInfo removeInfo = info.createRemoveCommand();
            this.protocol.sendToActiveMQ(removeInfo, new ResponseHandler(){

                @Override
                public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                }
            });
        }
    }

    protected void deleteDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                rsi.setConnectionId(this.protocol.getConnectionId());
                rsi.setSubscriptionName(sub.getSubcriptionName());
                rsi.setClientId(sub.getClientId());
                this.protocol.sendToActiveMQ(rsi, new ResponseHandler(){

                    @Override
                    public void onResponse(MQTTProtocolConverter converter, Response response) throws IOException {
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not delete the MQTT durable subs.", e);
        }
    }

    protected void restoreDurableSubs(List<SubscriptionInfo> subs) {
        try {
            for (SubscriptionInfo sub : subs) {
                String name = sub.getSubcriptionName();
                String[] split = name.split(":", 2);
                QoS qoS = QoS.valueOf((String)split[0]);
                this.onSubscribe(new org.fusesource.mqtt.client.Topic(split[1], qoS));
                this.restoredDurableSubs.add(MQTTProtocolSupport.convertMQTTToActiveMQ(split[1]));
            }
        }
        catch (IOException e) {
            LOG.warn("Could not restore the MQTT durable subs.", e);
        }
    }

    protected List<SubscriptionInfo> lookupSubscription(String clientId) throws MQTTProtocolException {
        RegionBroker regionBroker;
        ArrayList<SubscriptionInfo> result = new ArrayList<SubscriptionInfo>();
        try {
            regionBroker = (RegionBroker)this.brokerService.getBroker().getAdaptor(RegionBroker.class);
        }
        catch (Exception e) {
            throw new MQTTProtocolException("Error recovering durable subscriptions: " + e.getMessage(), false, e);
        }
        TopicRegion topicRegion = (TopicRegion)regionBroker.getTopicRegion();
        List<DurableTopicSubscription> subscriptions = topicRegion.lookupSubscriptions(clientId);
        if (subscriptions != null) {
            for (DurableTopicSubscription subscription : subscriptions) {
                LOG.debug("Recovered durable sub:{} on connect", (Object)subscription);
                SubscriptionInfo info = new SubscriptionInfo();
                info.setDestination(subscription.getActiveMQDestination());
                info.setSubcriptionName(subscription.getSubscriptionKey().getSubscriptionName());
                info.setClientId(clientId);
                result.add(info);
            }
        }
        return result;
    }
}

