/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.osgi.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jolokia.server.core.osgi.security.Authenticator;
import org.jolokia.server.core.osgi.security.DefaultServletContextHelper;

public class BasicAuthenticationServletContextHelper
extends DefaultServletContextHelper {
    private final String realm;
    private final Authenticator authenticator;

    public BasicAuthenticationServletContextHelper(String pRealm, Authenticator pAuthenticator) {
        this.realm = pRealm;
        this.authenticator = pAuthenticator;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.authenticator.authenticate(request)) {
            response.setHeader("WWW-Authenticate", "BASIC realm=\"" + this.realm + "\"");
            response.sendError(401);
            return false;
        }
        return true;
    }
}

