/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.OpenType;
import org.jolokia.service.serializer.object.ArrayTypeConverter;
import org.jolokia.service.serializer.object.CompositeTypeConverter;
import org.jolokia.service.serializer.object.OpenTypeConverter;
import org.jolokia.service.serializer.object.SimpleTypeConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;
import org.jolokia.service.serializer.object.TabularDataConverter;

public class OpenTypeDeserializer {
    protected boolean forgiving = false;
    private final List<OpenTypeConverter<? extends OpenType>> converters;

    public OpenTypeDeserializer(StringToObjectConverter pStringToObjectConverter) {
        this.converters = Arrays.asList(new SimpleTypeConverter(this, pStringToObjectConverter), new ArrayTypeConverter(this), new CompositeTypeConverter(this), new TabularDataConverter(this));
    }

    public Object deserialize(OpenType pOpenType, Object pValue) {
        if (pValue == null) {
            return null;
        }
        for (OpenTypeConverter<? extends OpenType> converter : this.converters) {
            if (!converter.canConvert(pOpenType)) continue;
            return converter.convertToObject(pOpenType, pValue);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(pValue) + " to " + String.valueOf(pOpenType) + ": No converter could be found");
    }

    public void makeForgiving() {
        this.forgiving = true;
    }

    public boolean isForgiving() {
        return this.forgiving;
    }
}

