/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateEmbAttributeUndoableEdit
extends CayenneUndoableEdit {
    private Embeddable embeddable;
    private EmbeddableAttribute[] attrs;

    public CreateEmbAttributeUndoableEdit(Embeddable embeddable, EmbeddableAttribute[] attr) {
        this.embeddable = embeddable;
        this.attrs = attr;
    }

    @Override
    public String getPresentationName() {
        return "Create Embeddable Attribute";
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateAttributeAction action = this.actionManager.getAction(CreateAttributeAction.class);
        for (EmbeddableAttribute attr : this.attrs) {
            action.createEmbAttribute(this.embeddable, attr);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveAttributeAction action = this.actionManager.getAction(RemoveAttributeAction.class);
        action.removeEmbeddableAttributes(this.embeddable, this.attrs);
    }
}

