/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.CompoundSaverDelegate;
import org.apache.cayenne.project.ConfigurationSaver;
import org.apache.cayenne.project.ConfigurationSourceGetter;
import org.apache.cayenne.project.ConfigurationSourceSetter;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.SaveableNodesGetter;
import org.apache.cayenne.project.extension.ProjectExtension;
import org.apache.cayenne.project.extension.SaverDelegate;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class FileProjectSaver
implements ProjectSaver {
    @Inject
    protected ConfigurationNameMapper nameMapper;
    protected ConfigurationNodeVisitor<Resource> resourceGetter = new ConfigurationSourceGetter();
    protected ConfigurationNodeVisitor<Collection<ConfigurationNode>> saveableNodesGetter = new SaveableNodesGetter();
    protected String fileEncoding = "UTF-8";
    protected Collection<ProjectExtension> extensions;
    protected SaverDelegate delegate;

    public FileProjectSaver(@Inject List<ProjectExtension> extensions) {
        this.extensions = extensions;
        ArrayList<SaverDelegate> delegates = new ArrayList<SaverDelegate>(extensions.size());
        for (ProjectExtension extension : extensions) {
            delegates.add(extension.createSaverDelegate());
        }
        this.delegate = new CompoundSaverDelegate(delegates);
    }

    @Override
    public String getSupportedVersion() {
        return String.valueOf(10);
    }

    @Override
    public void save(Project project) {
        this.save(project, project.getConfigurationResource(), true);
    }

    @Override
    public void saveAs(Project project, Resource baseDirectory) {
        if (baseDirectory == null) {
            throw new NullPointerException("Null 'baseDirectory'");
        }
        this.save(project, baseDirectory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(Project project, Resource baseResource, boolean deleteOldResources) {
        Collection nodes = (Collection)project.getRootNode().acceptVisitor(this.saveableNodesGetter);
        ArrayList<SaveUnit> units = new ArrayList<SaveUnit>(nodes.size());
        this.delegate.setBaseDirectory(baseResource);
        for (ConfigurationNode node : nodes) {
            String targetLocation = this.nameMapper.configurationLocation(node);
            if (node instanceof DataMap) {
                DataMap dataMapNode = (DataMap)node;
                dataMapNode.setLocation(targetLocation);
            }
            Resource targetResource = baseResource.getRelativeResource(targetLocation);
            units.add(this.createSaveUnit(node, targetResource, null));
            for (ProjectExtension extension : this.extensions) {
                ConfigurationNodeVisitor<String> namingDelegate = extension.createNamingDelegate();
                SaverDelegate unitSaverDelegate = extension.createSaverDelegate();
                String fileName = (String)node.acceptVisitor(namingDelegate);
                if (fileName == null) continue;
                targetResource = baseResource.getRelativeResource(fileName);
                units.add(this.createSaveUnit(node, targetResource, unitSaverDelegate));
            }
        }
        this.checkAccess(units);
        try {
            this.saveToTempFiles(units);
            this.saveCommit(units);
        }
        finally {
            this.clearTempFiles(units);
        }
        try {
            if (deleteOldResources) {
                this.clearRenamedFiles(units);
                Collection<URL> unusedResources = project.getUnusedResources();
                for (SaveUnit unit : units) {
                    unusedResources.remove(unit.sourceConfiguration.getURL());
                }
                this.deleteUnusedFiles(unusedResources);
            }
        }
        catch (IOException ex) {
            throw new CayenneRuntimeException((Throwable)ex);
        }
        project.getUnusedResources().clear();
    }

    SaveUnit createSaveUnit(ConfigurationNode node, Resource targetResource, SaverDelegate delegate) {
        SaveUnit unit = new SaveUnit();
        unit.node = node;
        unit.delegate = delegate;
        unit.sourceConfiguration = (Resource)node.acceptVisitor(this.resourceGetter);
        if (unit.sourceConfiguration == null) {
            unit.sourceConfiguration = targetResource;
        }
        URL targetUrl = targetResource.getURL();
        try {
            unit.targetFile = Util.toFile((URL)targetUrl);
        }
        catch (IllegalArgumentException e) {
            throw new CayenneRuntimeException("Can't save configuration to the following location: '%s'. Is this a valid file location?. (%s)", (Throwable)e, new Object[]{targetUrl, e.getMessage()});
        }
        return unit;
    }

    void checkAccess(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            File targetFile = unit.targetFile;
            File parent = targetFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new CayenneRuntimeException("Error creating directory tree for '%s'", new Object[]{parent.getAbsolutePath()});
            }
            if (targetFile.isDirectory()) {
                throw new CayenneRuntimeException("Target file '%s' is a directory", new Object[]{targetFile.getAbsolutePath()});
            }
            if (!targetFile.exists() || targetFile.canWrite()) continue;
            throw new CayenneRuntimeException("Can't write to file '%s'", new Object[]{targetFile.getAbsolutePath()});
        }
    }

    void saveToTempFiles(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            String name = unit.targetFile.getName();
            if (name.length() < 3) {
                name = "cayenne-project";
            }
            File parent = unit.targetFile.getParentFile();
            try {
                unit.targetTempFile = File.createTempFile(name, null, parent);
            }
            catch (IOException e) {
                throw new CayenneRuntimeException("Error creating temp file (%s)", (Throwable)e, new Object[]{e.getMessage()});
            }
            if (unit.targetTempFile.exists()) {
                unit.targetTempFile.delete();
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(unit.targetTempFile), this.fileEncoding));){
                this.saveToTempFile(unit, printWriter);
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding '%s' (%s)", (Throwable)e, new Object[]{this.fileEncoding, e.getMessage()});
            }
            catch (FileNotFoundException e) {
                throw new CayenneRuntimeException("File not found '%s' (%s)", (Throwable)e, new Object[]{unit.targetTempFile.getAbsolutePath(), e.getMessage()});
            }
        }
    }

    void saveToTempFile(SaveUnit unit, PrintWriter printWriter) {
        Object visitor;
        if (unit.delegate == null) {
            visitor = new ConfigurationSaver(printWriter, this.getSupportedVersion(), this.delegate);
        } else {
            XMLEncoder encoder = new XMLEncoder(printWriter, "\t", this.getSupportedVersion());
            encoder.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            unit.delegate.setXMLEncoder(encoder);
            visitor = unit.delegate;
        }
        unit.node.acceptVisitor((ConfigurationNodeVisitor)visitor);
    }

    void saveCommit(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            File targetFile = unit.targetFile;
            System.gc();
            if (targetFile.exists() && !targetFile.delete()) {
                throw new CayenneRuntimeException("Unable to remove old master file '%s'", new Object[]{targetFile.getAbsolutePath()});
            }
            File tempFile = unit.targetTempFile;
            if (!tempFile.renameTo(targetFile)) {
                throw new CayenneRuntimeException("Unable to move '%s' to '%s'", new Object[]{tempFile.getAbsolutePath(), targetFile.getAbsolutePath()});
            }
            unit.targetTempFile = null;
            try {
                if (unit.delegate != null) continue;
                unit.node.acceptVisitor((ConfigurationNodeVisitor)new ConfigurationSourceSetter((Resource)new URLResource(targetFile.toURI().toURL())));
            }
            catch (MalformedURLException e) {
                throw new CayenneRuntimeException("Malformed URL for file '%s'", (Throwable)e, new Object[]{targetFile.getAbsolutePath()});
            }
        }
    }

    private void clearTempFiles(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            if (unit.targetTempFile == null || !unit.targetTempFile.exists()) continue;
            unit.targetTempFile.delete();
            unit.targetTempFile = null;
        }
    }

    private void clearRenamedFiles(Collection<SaveUnit> units) throws IOException {
        for (SaveUnit unit : units) {
            File sourceFile;
            if (unit.sourceConfiguration == null) continue;
            URL sourceUrl = unit.sourceConfiguration.getURL();
            try {
                sourceFile = Util.toFile((URL)sourceUrl);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!sourceFile.exists()) continue;
            boolean isTarget = false;
            for (SaveUnit xunit : units) {
                if (!this.isFilesEquals(sourceFile, xunit.targetFile)) continue;
                isTarget = true;
                break;
            }
            if (isTarget || sourceFile.delete()) continue;
            throw new CayenneRuntimeException("Could not delete file '%s'", new Object[]{sourceFile.getCanonicalPath()});
        }
    }

    private boolean isFilesEquals(File firstFile, File secondFile) throws IOException {
        boolean isFirstFileExists = firstFile.exists();
        boolean isSecondFileExists = secondFile.exists();
        String firstFilePath = firstFile.getCanonicalPath();
        String secondFilePath = secondFile.getCanonicalPath();
        return isFirstFileExists && isSecondFileExists && firstFilePath.equals(secondFilePath);
    }

    private void deleteUnusedFiles(Collection<URL> unusedResources) throws IOException {
        for (URL unusedResource : unusedResources) {
            File unusedFile;
            try {
                unusedFile = Util.toFile((URL)unusedResource);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!unusedFile.exists() || unusedFile.delete()) continue;
            throw new CayenneRuntimeException("Could not delete file '%s'", new Object[]{unusedFile.getCanonicalPath()});
        }
    }

    class SaveUnit {
        private ConfigurationNode node;
        private SaverDelegate delegate;
        private Resource sourceConfiguration;
        private File targetFile;
        private File targetTempFile;

        SaveUnit() {
        }
    }
}

