/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.util.ResultIteratorIterator;

public class JDBCResultIterator<T>
implements ResultIterator<T> {
    protected Statement statement;
    protected ResultSet resultSet;
    protected boolean closed;
    protected boolean nextRow;
    private RowReader<T> rowReader;

    public JDBCResultIterator(Statement statement, ResultSet resultSet, RowReader<T> rowReader) {
        this.statement = statement;
        this.resultSet = resultSet;
        this.rowReader = rowReader;
        this.checkNextRow();
    }

    @Override
    public Iterator<T> iterator() {
        return new ResultIteratorIterator(this);
    }

    @Override
    public List<T> allRows() {
        ArrayList<T> list = new ArrayList<T>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() {
        return this.nextRow;
    }

    @Override
    public T nextRow() {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        T row = this.rowReader.readRow(this.resultSet);
        this.checkNextRow();
        return row;
    }

    @Override
    public void skipRow() {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        this.checkNextRow();
    }

    @Override
    public void close() throws NoSuchElementException {
        if (!this.closed) {
            this.nextRow = false;
            StringBuilder errors = new StringBuilder();
            try {
                this.resultSet.close();
            }
            catch (SQLException e1) {
                errors.append("Error closing ResultSet.");
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e2) {
                    errors.append("Error closing PreparedStatement.");
                }
            }
            if (errors.length() > 0) {
                throw new CayenneRuntimeException("Error closing ResultIterator: %s", errors);
            }
            this.closed = true;
        }
    }

    protected void checkNextRow() {
        this.nextRow = false;
        try {
            if (this.resultSet.next()) {
                this.nextRow = true;
            }
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Error rewinding ResultSet", (Throwable)e, new Object[0]);
        }
    }
}

