/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import java.rmi.RemoteException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventBridgeFactory;
import org.apache.cayenne.remote.BaseConnection;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;

public class HttpClientConnection
extends BaseConnection {
    private RemoteService remoteService;
    private RemoteSession session;
    private String sharedSessionName;

    public HttpClientConnection(RemoteService remoteService, String sharedSession) {
        this.remoteService = remoteService;
        this.sharedSessionName = sharedSession;
    }

    public RemoteSession getSession() {
        return this.session;
    }

    @Override
    protected void beforeSendMessage(ClientMessage message) throws CayenneRuntimeException {
        if (this.session == null) {
            this.connect();
        }
    }

    @Override
    protected Object doSendMessage(ClientMessage message) throws CayenneRuntimeException {
        try {
            return this.remoteService.processMessage(message);
        }
        catch (CayenneRuntimeException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new CayenneRuntimeException(th.getMessage(), th, new Object[0]);
        }
    }

    @Override
    public EventBridge getServerEventBridge() throws CayenneRuntimeException {
        if (this.session == null) {
            this.connect();
        }
        return this.createServerEventBridge(this.session);
    }

    @BeforeScopeEnd
    public void shutdown() throws RemoteException {
        this.remoteService.close();
    }

    protected synchronized void connect() {
        if (this.session != null) {
            return;
        }
        long t0 = System.currentTimeMillis();
        try {
            this.session = this.sharedSessionName != null ? this.remoteService.establishSharedSession(this.sharedSessionName) : this.remoteService.establishSession();
        }
        catch (Throwable th) {
            this.logger.info(th.getMessage(), th);
            throw new CayenneRuntimeException(th.getMessage(), th, new Object[0]);
        }
        if (this.logger.isInfoEnabled()) {
            long time = System.currentTimeMillis() - t0;
            this.logger.info("=== Connected, session: " + this.session + " - took " + time + " ms.");
        }
    }

    protected EventBridge createServerEventBridge(RemoteSession session) throws CayenneRuntimeException {
        if (!session.isServerEventsEnabled()) {
            return null;
        }
        try {
            EventBridgeFactory factory = (EventBridgeFactory)Class.forName(session.getEventBridgeFactory()).newInstance();
            return factory.createEventBridge(RemoteSession.getSubjects(), session.getName(), session.getEventBridgeParameters());
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error creating EventBridge.", (Throwable)ex, new Object[0]);
        }
    }
}

