/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.AbstractBitMapExtractorTest;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.DefaultIndexExtractorTest;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultBitMapExtractorTest
extends AbstractBitMapExtractorTest {
    long[] values = DefaultBitMapExtractorTest.generateLongArray(5);

    static long[] generateLongArray(int size) {
        return ThreadLocalRandom.current().longs(size).toArray();
    }

    @Override
    protected BitMapExtractor createEmptyExtractor() {
        return new DefaultBitMapExtractor(new long[0]);
    }

    @Override
    protected BitMapExtractor createExtractor() {
        return new DefaultBitMapExtractor(this.values);
    }

    @Override
    protected boolean emptyIsZeroLength() {
        return true;
    }

    @Test
    public void testAsBitMapArrayLargeArray() {
        long[] expected = DefaultBitMapExtractorTest.generateLongArray(32);
        BitMapExtractor bitMapExtractor = predicate -> {
            for (long l : expected) {
                if (predicate.test(l)) continue;
                return false;
            }
            return true;
        };
        long[] ary = bitMapExtractor.asBitMapArray();
        Assertions.assertArrayEquals((long[])expected, (long[])ary);
    }

    @Test
    public void testFromBitMapArray() {
        int nOfBitMaps = BitMaps.numberOfBitMaps((int)256);
        long[] expected = DefaultBitMapExtractorTest.generateLongArray(nOfBitMaps);
        long[] ary = BitMapExtractor.fromBitMapArray((long[])expected).asBitMapArray();
        Assertions.assertArrayEquals((long[])expected, (long[])ary);
    }

    @Test
    public void testFromIndexExtractor() {
        int[] expected = DefaultIndexExtractorTest.generateIntArray(10, 256);
        IndexExtractor indexExtractor = IndexExtractor.fromIndexArray((int[])expected);
        long[] ary = BitMapExtractor.fromIndexExtractor((IndexExtractor)indexExtractor, (int)256).asBitMapArray();
        for (int idx : expected) {
            Assertions.assertTrue((boolean)BitMaps.contains((long[])ary, (int)idx));
        }
    }

    class DefaultBitMapExtractor
    implements BitMapExtractor {
        long[] bitMaps;

        DefaultBitMapExtractor(long[] bitMaps) {
            this.bitMaps = bitMaps;
        }

        public boolean processBitMaps(LongPredicate predicate) {
            for (long bitmap : this.bitMaps) {
                if (predicate.test(bitmap)) continue;
                return false;
            }
            return true;
        }
    }
}

