/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataFloat;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataInt;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.datareaders.AbstractImageDataReader;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.datareaders.DataInterpreterJpeg;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.AbstractPhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;

public final class DataReaderTiled
extends AbstractImageDataReader {
    private final int tileWidth;
    private final int tileLength;
    private final int bitsPerPixel;
    private final int compression;
    private final ByteOrder byteOrder;
    private final AbstractTiffImageData.Tiles imageData;

    public DataReaderTiled(TiffDirectory directory, AbstractPhotometricInterpreter photometricInterpreter, int tileWidth, int tileLength, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int sampleFormat, int width, int height, int compression, TiffPlanarConfiguration planarConfiguration, ByteOrder byteOrder, AbstractTiffImageData.Tiles imageData) {
        super(directory, photometricInterpreter, bitsPerSample, predictor, samplesPerPixel, sampleFormat, width, height, planarConfiguration);
        this.tileWidth = tileWidth;
        this.tileLength = tileLength;
        this.bitsPerPixel = bitsPerPixel;
        this.compression = compression;
        this.imageData = imageData;
        this.byteOrder = byteOrder;
    }

    private void interpretTile(ImageBuilder imageBuilder, byte[] bytes, int startX, int startY, int xLimit, int yLimit) throws ImagingException, IOException {
        if (this.sampleFormat == 3) {
            int i0 = startY;
            int i1 = startY + this.tileLength;
            if (i1 > yLimit) {
                i1 = yLimit;
            }
            int j0 = startX;
            int j1 = startX + this.tileWidth;
            if (j1 > xLimit) {
                j1 = xLimit;
            }
            int[] samples = new int[4];
            int[] b = this.unpackFloatingPointSamples(j1 - j0, i1 - i0, this.tileWidth, bytes, this.bitsPerPixel, this.byteOrder);
            for (int i = i0; i < i1; ++i) {
                int row = i - startY;
                int rowOffset = row * this.tileWidth;
                for (int j = j0; j < j1; ++j) {
                    int column = j - startX;
                    int k = (rowOffset + column) * this.samplesPerPixel;
                    samples[0] = b[k];
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, j, i);
                }
            }
            return;
        }
        boolean allSamplesAreOneByte = this.isHomogenous(8);
        if ((this.bitsPerPixel == 24 || this.bitsPerPixel == 32) && allSamplesAreOneByte && this.photometricInterpreter instanceof PhotometricInterpreterRgb) {
            int j1;
            int i1 = startY + this.tileLength;
            if (i1 > yLimit) {
                i1 = yLimit;
            }
            if ((j1 = startX + this.tileWidth) > xLimit) {
                j1 = xLimit;
            }
            if (this.predictor == 2) {
                this.applyPredictorToBlock(this.tileWidth, i1 - startY, this.samplesPerPixel, bytes);
            }
            if (this.bitsPerPixel == 24) {
                for (int i = startY; i < i1; ++i) {
                    int k = (i - startY) * this.tileWidth * 3;
                    int j = startX;
                    while (j < j1) {
                        int rgb = 0xFF000000 | bytes[k] << 16 | (bytes[k + 1] & 0xFF) << 8 | bytes[k + 2] & 0xFF;
                        imageBuilder.setRgb(j, i, rgb);
                        ++j;
                        k += 3;
                    }
                }
            } else if (this.bitsPerPixel == 32) {
                for (int i = startY; i < i1; ++i) {
                    int k = (i - startY) * this.tileWidth * 4;
                    int j = startX;
                    while (j < j1) {
                        int rgb = (bytes[k] & 0xFF) << 16 | (bytes[k + 1] & 0xFF) << 8 | bytes[k + 2] & 0xFF | bytes[k + 3] << 24;
                        imageBuilder.setRgb(j, i, rgb);
                        ++j;
                        k += 4;
                    }
                }
            }
            return;
        }
        try (BitInputStream bis = new BitInputStream(new ByteArrayInputStream(bytes), this.byteOrder);){
            int pixelsPerTile = this.tileWidth * this.tileLength;
            int tileX = 0;
            int tileY = 0;
            int[] samples = Allocator.intArray(this.bitsPerSampleLength);
            this.resetPredictor();
            for (int i = 0; i < pixelsPerTile; ++i) {
                int x = tileX + startX;
                int y = tileY + startY;
                this.getSamplesAsBytes(bis, samples);
                if (x < xLimit && y < yLimit) {
                    samples = this.applyPredictor(samples);
                    this.photometricInterpreter.interpretPixel(imageBuilder, samples, x, y);
                }
                if (++tileX < this.tileWidth) continue;
                tileX = 0;
                this.resetPredictor();
                bis.flushCache();
                if (++tileY < this.tileLength) continue;
                break;
            }
        }
    }

    @Override
    public ImageBuilder readImageData(Rectangle subImageSpecification, boolean hasAlpha, boolean isAlphaPreMultiplied) throws IOException, ImagingException {
        Rectangle subImage = subImageSpecification == null ? new Rectangle(0, 0, this.width, this.height) : subImageSpecification;
        int bitsPerRow = this.tileWidth * this.bitsPerPixel;
        int bytesPerRow = (bitsPerRow + 7) / 8;
        int bytesPerTile = bytesPerRow * this.tileLength;
        int col0 = subImage.x / this.tileWidth;
        int col1 = (subImage.x + subImage.width - 1) / this.tileWidth;
        int row0 = subImage.y / this.tileLength;
        int row1 = (subImage.y + subImage.height - 1) / this.tileLength;
        int nCol = col1 - col0 + 1;
        int nRow = row1 - row0 + 1;
        int workingWidth = nCol * this.tileWidth;
        int workingHeight = nRow * this.tileLength;
        int nColumnsOfTiles = (this.width + this.tileWidth - 1) / this.tileWidth;
        int x0 = col0 * this.tileWidth;
        int y0 = row0 * this.tileLength;
        ImageBuilder workingBuilder = new ImageBuilder(workingWidth, workingHeight, hasAlpha, isAlphaPreMultiplied);
        for (int iRow = row0; iRow <= row1; ++iRow) {
            for (int iCol = col0; iCol <= col1; ++iCol) {
                int tile = iRow * nColumnsOfTiles + iCol;
                byte[] compressed = this.imageData.tiles[tile].getData();
                int x = iCol * this.tileWidth - x0;
                int y = iRow * this.tileLength - y0;
                if (this.compression == 7) {
                    if (this.planarConfiguration == TiffPlanarConfiguration.PLANAR) {
                        throw new ImagingException("TIFF file in non-supported configuration: JPEG compression used in planar configuration.");
                    }
                    DataInterpreterJpeg.intepretBlock(this.directory, workingBuilder, x, y, this.tileWidth, this.tileLength, compressed);
                    continue;
                }
                byte[] decompressed = this.decompress(compressed, this.compression, bytesPerTile, this.tileWidth, this.tileLength);
                this.interpretTile(workingBuilder, decompressed, x, y, this.width, this.height);
            }
        }
        if (subImage.x == x0 && subImage.y == y0 && subImage.width == workingWidth && subImage.height == workingHeight) {
            return workingBuilder;
        }
        return workingBuilder.getSubset(subImage.x - x0, subImage.y - y0, subImage.width, subImage.height);
    }

    @Override
    public AbstractTiffRasterData readRasterData(Rectangle subImage) throws ImagingException, IOException {
        switch (this.sampleFormat) {
            case 3: {
                return this.readRasterDataFloat(subImage);
            }
            case 2: {
                return this.readRasterDataInt(subImage);
            }
        }
        throw new ImagingException("Unsupported sample format, value=" + this.sampleFormat);
    }

    private AbstractTiffRasterData readRasterDataFloat(Rectangle subImage) throws ImagingException, IOException {
        int rasterHeight;
        int rasterWidth;
        int yRaster;
        int xRaster;
        int bitsPerRow = this.tileWidth * this.bitsPerPixel;
        int bytesPerRow = (bitsPerRow + 7) / 8;
        int bytesPerTile = bytesPerRow * this.tileLength;
        if (subImage != null) {
            xRaster = subImage.x;
            yRaster = subImage.y;
            rasterWidth = subImage.width;
            rasterHeight = subImage.height;
        } else {
            xRaster = 0;
            yRaster = 0;
            rasterWidth = this.width;
            rasterHeight = this.height;
        }
        float[] rasterDataFloat = Allocator.floatArray(rasterWidth * rasterHeight * this.samplesPerPixel);
        int col0 = xRaster / this.tileWidth;
        int col1 = (xRaster + rasterWidth - 1) / this.tileWidth;
        int row0 = yRaster / this.tileLength;
        int row1 = (yRaster + rasterHeight - 1) / this.tileLength;
        int nColumnsOfTiles = (this.width + this.tileWidth - 1) / this.tileWidth;
        for (int iRow = row0; iRow <= row1; ++iRow) {
            for (int iCol = col0; iCol <= col1; ++iCol) {
                int tile = iRow * nColumnsOfTiles + iCol;
                byte[] compressed = this.imageData.tiles[tile].getData();
                byte[] decompressed = this.decompress(compressed, this.compression, bytesPerTile, this.tileWidth, this.tileLength);
                int x = iCol * this.tileWidth;
                int y = iRow * this.tileLength;
                int[] blockData = this.unpackFloatingPointSamples(this.tileWidth, this.tileLength, this.tileWidth, decompressed, this.bitsPerPixel, this.byteOrder);
                this.transferBlockToRaster(x, y, this.tileWidth, this.tileLength, blockData, xRaster, yRaster, rasterWidth, rasterHeight, this.samplesPerPixel, rasterDataFloat);
            }
        }
        return new TiffRasterDataFloat(rasterWidth, rasterHeight, this.samplesPerPixel, rasterDataFloat);
    }

    private AbstractTiffRasterData readRasterDataInt(Rectangle subImage) throws ImagingException, IOException {
        int rasterHeight;
        int rasterWidth;
        int yRaster;
        int xRaster;
        int bitsPerRow = this.tileWidth * this.bitsPerPixel;
        int bytesPerRow = (bitsPerRow + 7) / 8;
        int bytesPerTile = bytesPerRow * this.tileLength;
        if (subImage != null) {
            xRaster = subImage.x;
            yRaster = subImage.y;
            rasterWidth = subImage.width;
            rasterHeight = subImage.height;
        } else {
            xRaster = 0;
            yRaster = 0;
            rasterWidth = this.width;
            rasterHeight = this.height;
        }
        int[] rasterDataInt = Allocator.intArray(rasterWidth * rasterHeight);
        int col0 = xRaster / this.tileWidth;
        int col1 = (xRaster + rasterWidth - 1) / this.tileWidth;
        int row0 = yRaster / this.tileLength;
        int row1 = (yRaster + rasterHeight - 1) / this.tileLength;
        int nColumnsOfTiles = (this.width + this.tileWidth - 1) / this.tileWidth;
        for (int iRow = row0; iRow <= row1; ++iRow) {
            for (int iCol = col0; iCol <= col1; ++iCol) {
                int tile = iRow * nColumnsOfTiles + iCol;
                byte[] compressed = this.imageData.tiles[tile].getData();
                byte[] decompressed = this.decompress(compressed, this.compression, bytesPerTile, this.tileWidth, this.tileLength);
                int x = iCol * this.tileWidth;
                int y = iRow * this.tileLength;
                int[] blockData = this.unpackIntSamples(this.tileWidth, this.tileLength, this.tileWidth, decompressed, this.predictor, this.bitsPerPixel, this.byteOrder);
                this.transferBlockToRaster(x, y, this.tileWidth, this.tileLength, blockData, xRaster, yRaster, rasterWidth, rasterHeight, rasterDataInt);
            }
        }
        return new TiffRasterDataInt(rasterWidth, rasterHeight, rasterDataInt);
    }
}

