/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateSampler;
import org.apache.commons.rng.sampling.distribution.InternalGamma;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

final class InternalUtils {
    private static final double[] LOG_FACTORIALS = new double[]{0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.1780538303479458, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.801827480081469, 15.104412573075516, 17.502307845873887, 19.987214495661885, 22.552163853123425, 25.19122118273868, 27.89927138384089, 30.671860106080672, 33.50507345013689, 36.39544520803305, 39.339884187199495, 42.335616460753485};
    private static final int BEGIN_LOG_FACTORIALS = 2;
    private static final double DOUBLE_MULTIPLIER = (double)1.110223E-16f;

    private InternalUtils() {
    }

    static double logFactorial(int n) {
        return LOG_FACTORIALS[n];
    }

    static double validateProbabilities(double[] probabilities) {
        if (probabilities == null || probabilities.length == 0) {
            throw new IllegalArgumentException("Probabilities must not be empty.");
        }
        double sumProb = 0.0;
        for (double prob : probabilities) {
            sumProb += InternalUtils.requirePositiveFinite(prob, "probability");
        }
        return InternalUtils.requireStrictlyPositiveFinite(sumProb, "sum of probabilities");
    }

    static double requireFinite(double x, String name) {
        if (!Double.isFinite(x)) {
            throw new IllegalArgumentException(name + " is not finite: " + x);
        }
        return x;
    }

    static double requirePositiveFinite(double x, String name) {
        if (!(x >= 0.0) || !(x < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException(name + " is not positive and finite: " + x);
        }
        return x;
    }

    static double requireStrictlyPositiveFinite(double x, String name) {
        if (!(x > 0.0) || !(x < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException(name + " is not strictly positive and finite: " + x);
        }
        return x;
    }

    static double requirePositive(double x, String name) {
        if (!(x >= 0.0)) {
            throw new IllegalArgumentException(name + " is not positive: " + x);
        }
        return x;
    }

    static double requireStrictlyPositive(double x, String name) {
        if (!(x > 0.0)) {
            throw new IllegalArgumentException(name + " is not strictly positive: " + x);
        }
        return x;
    }

    static double requireRange(double min, double max, double x, String name) {
        if (!(min <= x) || !(x < max)) {
            throw new IllegalArgumentException(String.format("%s not within range: %s <= %s < %s", name, min, x, max));
        }
        return x;
    }

    static double requireRangeClosed(double min, double max, double x, String name) {
        if (!(min <= x) || !(x <= max)) {
            throw new IllegalArgumentException(String.format("%s not within closed range: %s <= %s <= %s", name, min, x, max));
        }
        return x;
    }

    static NormalizedGaussianSampler newNormalizedGaussianSampler(NormalizedGaussianSampler sampler, UniformRandomProvider rng) {
        if (!(sampler instanceof SharedStateSampler)) {
            throw new UnsupportedOperationException("The underlying sampler cannot share state");
        }
        Object newSampler = ((SharedStateSampler)((Object)sampler)).withUniformRandomProvider(rng);
        if (!(newSampler instanceof NormalizedGaussianSampler)) {
            throw new UnsupportedOperationException("The underlying sampler did not create a normalized Gaussian sampler");
        }
        return (NormalizedGaussianSampler)newSampler;
    }

    static double makeDouble(long v) {
        return (double)(v >>> 11) * (double)1.110223E-16f;
    }

    static double makeNonZeroDouble(long v) {
        return (double)((v >>> 11) + 1L) * (double)1.110223E-16f;
    }

    public static final class FactorialLog {
        private final double[] logFactorials;

        private FactorialLog(int numValues, double[] cache) {
            int endCopy;
            this.logFactorials = new double[numValues];
            if (cache != null && cache.length > 2) {
                endCopy = Math.min(cache.length, numValues);
                System.arraycopy(cache, 2, this.logFactorials, 2, endCopy - 2);
            } else {
                endCopy = 2;
            }
            for (int i = endCopy; i < numValues; ++i) {
                this.logFactorials[i] = i < LOG_FACTORIALS.length ? LOG_FACTORIALS[i] : this.logFactorials[i - 1] + Math.log(i);
            }
        }

        public static FactorialLog create() {
            return new FactorialLog(0, null);
        }

        public FactorialLog withCache(int cacheSize) {
            return new FactorialLog(cacheSize, this.logFactorials);
        }

        public double value(int n) {
            if (n < this.logFactorials.length) {
                return this.logFactorials[n];
            }
            if (n < LOG_FACTORIALS.length) {
                return LOG_FACTORIALS[n];
            }
            return InternalGamma.logGamma((double)n + 1.0);
        }
    }
}

