/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Webdav4FileObjectTest {
    private static final String WEBDAV4_URL = "webdav4://www.apache.org/licenses/LICENSE-2.0.txt";
    private static final String INTERNAL_WEBDAV4_URL = "http://www.apache.org/licenses/LICENSE-2.0.txt";
    private static final String WEBDAV4S_URL = "webdav4s://www.apache.org/licenses/LICENSE-2.0.txt";
    private static final String INTERNAL_WEBDAV4S_URL = "https://www.apache.org/licenses/LICENSE-2.0.txt";

    @Test
    public void testWebdav4FileObjectURLs() throws FileSystemException {
        FileSystemManager fsm = VFS.getManager();
        try (FileObject file = fsm.resolveFile(WEBDAV4_URL);){
            Assertions.assertEquals((Object)WEBDAV4_URL, (Object)file.getURL().toString());
            Assertions.assertInstanceOf(Webdav4FileObject.class, (Object)file);
            Webdav4FileObject webdav4File = (Webdav4FileObject)file;
            Assertions.assertEquals((Object)INTERNAL_WEBDAV4_URL, (Object)webdav4File.toUrlString((GenericURLFileName)webdav4File.getName()));
        }
    }

    @Test
    public void testWebdav4sFileObjectURLs() throws FileSystemException {
        FileSystemManager fsm = VFS.getManager();
        try (FileObject file = fsm.resolveFile(WEBDAV4S_URL);){
            Assertions.assertEquals((Object)WEBDAV4S_URL, (Object)file.getURL().toString());
            Assertions.assertInstanceOf(Webdav4FileObject.class, (Object)file);
            Webdav4FileObject webdav4File = (Webdav4FileObject)file;
            Assertions.assertEquals((Object)INTERNAL_WEBDAV4S_URL, (Object)webdav4File.toUrlString((GenericURLFileName)webdav4File.getName()));
        }
    }
}

