/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsJsonReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsJsonConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

@PreMatching
@Priority(value=1002)
public class JwsJsonContainerRequestFilter
extends AbstractJwsJsonReaderProvider
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext context) throws IOException {
        if (this.isMethodWithNoContent(context.getMethod()) || this.isCheckEmptyStream() && !context.hasEntity()) {
            return;
        }
        String content = IOUtils.readStringFromStream((InputStream)context.getEntityStream());
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier();
        JwsJsonConsumer c = new JwsJsonConsumer(content);
        try {
            this.validate(c, theSigVerifier);
        }
        catch (JwsException ex) {
            context.abortWith(JAXRSUtils.toResponse((int)400));
            return;
        }
        byte[] bytes = c.getDecodedJwsPayloadBytes();
        context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        JwsJsonSignatureEntry sigEntry = (JwsJsonSignatureEntry)c.getSignatureEntries().get(0);
        String ct = JoseUtils.checkContentType((String)sigEntry.getUnionHeader().getContentType(), (String)this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
        if (super.isValidateHttpHeaders()) {
            super.validateHttpHeadersIfNeeded((MultivaluedMap<String, String>)context.getHeaders(), sigEntry.getProtectedHeader());
        }
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoRequestContent((String)method);
    }
}

