/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.lib.schema.annotation.props.gen.YesNo;
import org.apache.daffodil.lib.schema.annotation.props.gen.YesNo$Yes$;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.parsers.BinaryNumberCheckWidth;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.BinaryNumberBaseUnparser;

public abstract class BinaryDecimalUnparserBase
extends BinaryNumberBaseUnparser
implements BinaryNumberCheckWidth {
    private final YesNo signed;
    private final int binaryDecimalVirtualPoint;

    public BinaryDecimalUnparserBase(ElementRuntimeData e, YesNo signed, int binaryDecimalVirtualPoint) {
        this.signed = signed;
        this.binaryDecimalVirtualPoint = binaryDecimalVirtualPoint;
        super(e);
    }

    @Override
    public Number getNumberToPut(UState state) {
        DISimple node = state.currentInfosetNode().asSimple();
        Object object = node.dataValue();
        Number value = DataValue$.MODULE$.getNumber$extension(object);
        BigDecimal bigDec = Numbers$.MODULE$.asBigDecimal(value);
        BigInteger bigInt = this.binaryDecimalVirtualPoint != 0 ? bigDec.scaleByPowerOfTen(this.binaryDecimalVirtualPoint).toBigInteger() : bigDec.toBigInteger();
        return bigInt;
    }

    @Override
    public boolean putNumber(DataOutputStream dos, Number value, int nBits, FormatInfo finfo) {
        UState state = (UState)finfo;
        YesNo yesNo = this.signed;
        YesNo$Yes$ yesNo$Yes$ = YesNo$Yes$.MODULE$;
        boolean isSigned = !(yesNo != null ? !yesNo.equals(yesNo$Yes$) : yesNo$Yes$ != null);
        int minWidth = isSigned ? 2 : 1;
        this.checkMinWidth(state, isSigned, nBits, minWidth);
        return dos.putBigInt(Numbers$.MODULE$.asBigInt(value), nBits, isSigned, finfo);
    }
}

