/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GetCurrentPropertiesTest
extends BaseJDBCTestCase {
    public GetCurrentPropertiesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(GetCurrentPropertiesTest.class);
        baseTestSuite = TestConfiguration.clientServerDecorator((Test)baseTestSuite);
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
    }

    public void test_01_propertiesBeforeConnection() throws Exception {
        Properties properties = null;
        String string = GetCurrentPropertiesTest.getSystemProperty("user.dir");
        String string2 = string + File.separator + "system";
        Properties properties2 = new Properties();
        properties2.setProperty("derby.drda.traceDirectory", string2);
        properties2.setProperty("derby.drda.maxThreads", "0");
        properties2.setProperty("derby.drda.sslMode", "off");
        properties2.setProperty("derby.drda.keepAlive", "true");
        properties2.setProperty("derby.drda.minThreads", "0");
        properties2.setProperty("derby.drda.portNumber", "" + TestConfiguration.getCurrent().getPort());
        properties2.setProperty("derby.drda.logConnections", "false");
        properties2.setProperty("derby.drda.timeSlice", "0");
        properties2.setProperty("derby.drda.startNetworkServer", "false");
        properties2.setProperty("derby.drda.host", "127.0.0.1");
        properties2.setProperty("derby.drda.traceAll", "false");
        properties = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)properties.get(string3);
            GetCurrentPropertiesTest.println(properties2.getProperty(string3));
            GetCurrentPropertiesTest.println(string4);
            GetCurrentPropertiesTest.assertEquals((String)properties2.getProperty(string3), (String)string4);
        }
    }

    public void test_02_propertiesAfterConnection() throws Exception {
        Properties properties = null;
        String string = GetCurrentPropertiesTest.getSystemProperty("user.dir");
        String string2 = string + File.separator + "system";
        Properties properties2 = new Properties();
        properties2.setProperty("derby.drda.traceDirectory", string2);
        properties2.setProperty("derby.drda.maxThreads", "0");
        properties2.setProperty("derby.drda.sslMode", "off");
        properties2.setProperty("derby.drda.trace.4", "true");
        properties2.setProperty("derby.drda.keepAlive", "true");
        properties2.setProperty("derby.drda.minThreads", "0");
        properties2.setProperty("derby.drda.portNumber", "" + TestConfiguration.getCurrent().getPort());
        properties2.setProperty("derby.drda.logConnections", "true");
        properties2.setProperty("derby.drda.timeSlice", "0");
        properties2.setProperty("derby.drda.startNetworkServer", "false");
        properties2.setProperty("derby.drda.host", "127.0.0.1");
        properties2.setProperty("derby.drda.traceAll", "false");
        this.getConnection().setAutoCommit(false);
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        networkServerControl.trace(4, true);
        networkServerControl.logConnections(true);
        properties = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)properties.get(string3);
            GetCurrentPropertiesTest.println(properties2.getProperty(string3));
            GetCurrentPropertiesTest.println(string4);
            GetCurrentPropertiesTest.assertEquals((String)properties2.getProperty(string3), (String)string4);
        }
    }

    public void test_03_propertiesTraceOn() throws Exception {
        Properties properties = null;
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        networkServerControl.trace(true);
        String string = GetCurrentPropertiesTest.getSystemProperty("derby.system.home");
        networkServerControl.setTraceDirectory(string);
        Properties properties2 = new Properties();
        properties2.setProperty("derby.drda.traceDirectory", string);
        properties2.setProperty("derby.drda.maxThreads", "0");
        properties2.setProperty("derby.drda.sslMode", "off");
        properties2.setProperty("derby.drda.keepAlive", "true");
        properties2.setProperty("derby.drda.minThreads", "0");
        properties2.setProperty("derby.drda.portNumber", "" + TestConfiguration.getCurrent().getPort());
        properties2.setProperty("derby.drda.logConnections", "true");
        properties2.setProperty("derby.drda.timeSlice", "0");
        properties2.setProperty("derby.drda.startNetworkServer", "false");
        properties2.setProperty("derby.drda.host", "127.0.0.1");
        properties2.setProperty("derby.drda.traceAll", "true");
        properties = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)properties.get(string2);
            GetCurrentPropertiesTest.println(properties2.getProperty(string2));
            GetCurrentPropertiesTest.println(string3);
            GetCurrentPropertiesTest.assertEquals((String)("Unexpected value for property " + string2), (String)properties2.getProperty(string2), (String)string3);
        }
    }
}

