/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import org.apache.derby.agg.Aggregator;
import org.apache.derbyTesting.functionTests.tests.lang.FullName;

public class GenericMode<B extends Comparable<B>>
implements Aggregator<B, B, GenericMode<B>> {
    private HashMap<B, Accumulator<B>> _accumulators;

    public void init() {
        this._accumulators = new HashMap();
    }

    public void accumulate(B value) {
        this.getAccumulator(value).add(1);
    }

    public void merge(GenericMode<B> otherAggregator) {
        HashMap<B, Accumulator<B>> otherAccumulators = otherAggregator._accumulators;
        for (Comparable value : otherAccumulators.keySet()) {
            this.getAccumulator(value).add(otherAccumulators.get(value).getCount());
        }
    }

    public B terminate() {
        return this._accumulators.isEmpty() ? null : (B)Collections.max(this._accumulators.values()).getValue();
    }

    private Accumulator<B> getAccumulator(B value) {
        Accumulator<B> retval = this._accumulators.get(value);
        if (retval == null) {
            retval = new Accumulator<B>(value);
            this._accumulators.put(value, retval);
        }
        return retval;
    }

    public static final class Accumulator<B extends Comparable<B>>
    implements Comparable<Accumulator<B>> {
        private B _value;
        private int _count;

        public Accumulator(B value) {
            this._value = value;
            this._count = 0;
        }

        public void add(int increment) {
            this._count += increment;
        }

        public B getValue() {
            return this._value;
        }

        public int getCount() {
            return this._count;
        }

        @Override
        public int compareTo(Accumulator<B> that) {
            int retval = this._count - that._count;
            if (retval != 0) {
                return retval;
            }
            return this._value.compareTo(that._value);
        }
    }

    public static final class FullNameMode
    extends GenericMode<FullName> {
    }

    public static final class StringMode
    extends GenericMode<String> {
    }

    public static final class RealMode
    extends GenericMode<Float> {
    }

    public static final class DoubleMode
    extends GenericMode<Double> {
    }

    public static final class BigintMode
    extends GenericMode<Long> {
    }

    public static final class IntMode
    extends GenericMode<Integer> {
    }

    public static final class ShortMode
    extends GenericMode<Short> {
    }

    public static final class BooleanMode
    extends GenericMode<Boolean> {
    }

    public static final class BigDecimalMode
    extends GenericMode<BigDecimal> {
    }
}

