/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class JoinNode
extends TableOperatorNode {
    static final int INNERJOIN = 1;
    static final int CROSSJOIN = 2;
    static final int LEFTOUTERJOIN = 3;
    static final int RIGHTOUTERJOIN = 4;
    static final int FULLOUTERJOIN = 5;
    static final int UNIONJOIN = 6;
    private boolean naturalJoin;
    private boolean optimized;
    private PredicateList leftPredicateList;
    private PredicateList rightPredicateList;
    protected boolean flattenableJoin = true;
    List<AggregateNode> aggregates;
    SubqueryList subqueryList;
    ValueNode joinClause;
    boolean joinClauseNormalized;
    PredicateList joinPredicates;
    ResultColumnList usingClause;
    Properties joinOrderStrategyProperties;

    JoinNode(ResultSetNode leftResult, ResultSetNode rightResult, ValueNode onClause, ResultColumnList usingClause, ResultColumnList selectList, Properties tableProperties, Properties joinOrderStrategyProperties, ContextManager cm) throws StandardException {
        super(leftResult, rightResult, tableProperties, cm);
        this.setResultColumns(selectList);
        this.joinClause = onClause;
        this.joinClauseNormalized = false;
        this.usingClause = usingClause;
        this.joinOrderStrategyProperties = joinOrderStrategyProperties;
        if (this.getResultColumns() != null) {
            SanityManager.ASSERT(this.leftResultSet.getReferencedTableMap() != null && this.rightResultSet.getReferencedTableMap() != null || this.leftResultSet.getReferencedTableMap() == null && this.rightResultSet.getReferencedTableMap() == null, "left and right referencedTableMaps are expected to either both be non-null or both be null");
            if (this.leftResultSet.getReferencedTableMap() != null) {
                this.setReferencedTableMap((JBitSet)this.leftResultSet.getReferencedTableMap().clone());
                this.getReferencedTableMap().or(this.rightResultSet.getReferencedTableMap());
            }
        }
        this.joinPredicates = new PredicateList(cm);
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceOptimizingJoinNode();
        }
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftPredicateList(), outerCost);
        for (int i = this.joinPredicates.size() - 1; i >= 0; --i) {
            Predicate p = (Predicate)this.joinPredicates.elementAt(i);
            if (!((Predicate)this.joinPredicates.elementAt(i)).getPushable()) continue;
            this.joinPredicates.removeElementAt(i);
            this.getRightPredicateList().addElement(p);
        }
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightPredicateList(), this.leftResultSet.getCostEstimate());
        this.setCostEstimate(this.getCostEstimate(optimizer));
        this.getCostEstimate().setCost(this.leftResultSet.getCostEstimate().getEstimatedCost() + this.rightResultSet.getCostEstimate().getEstimatedCost(), this.rightResultSet.getCostEstimate().rowCount(), this.rightResultSet.getCostEstimate().rowCount());
        this.adjustNumberOfRowsReturned(this.getCostEstimate());
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, this.getCostEstimate());
        optimizer.considerCost(this, predList, this.getCostEstimate(), outerCost);
        if (!this.optimized && this.subqueryList != null) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.getCostEstimate().rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.getCostEstimate();
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT(optimizablePredicate instanceof Predicate, "optimizablePredicate expected to be instanceof Predicate");
        SanityManager.ASSERT(!optimizablePredicate.hasSubquery() && !optimizablePredicate.hasMethodCall(), "optimizablePredicate either has a subquery or a method call");
        this.joinPredicates.addPredicate((Predicate)optimizablePredicate);
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        ((Predicate)optimizablePredicate).getAndNode().accept(rcrv);
        return true;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        super.modifyAccessPath(outerTables);
        if (this.getLeftPredicateList().size() != 0) {
            SanityManager.THROWASSERT("getLeftPredicateList().size() expected to be 0, not " + this.getLeftPredicateList().size());
        }
        if (this.getRightPredicateList().size() != 0) {
            SanityManager.THROWASSERT("getRightPredicateList().size() expected to be 0, not " + this.getRightPredicateList().size());
        }
        return this;
    }

    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
    }

    @Override
    ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        if (this.usingClause == null) {
            return this.getAllResultColumnsNoUsing(allTableName);
        }
        ResultSetNode logicalLeftRS = this.getLogicalLeftResultSet();
        ResultColumnList joinRCL = logicalLeftRS.getAllResultColumns(null).getJoinColumns(this.usingClause);
        ResultColumnList leftRCL = this.leftResultSet.getAllResultColumns(allTableName);
        ResultColumnList rightRCL = this.rightResultSet.getAllResultColumns(allTableName);
        if (leftRCL != null) {
            leftRCL.removeJoinColumns(this.usingClause);
        }
        if (rightRCL != null) {
            rightRCL.removeJoinColumns(this.usingClause);
        }
        if (leftRCL == null) {
            if (rightRCL == null) {
                return null;
            }
            rightRCL.resetVirtualColumnIds();
            return rightRCL;
        }
        if (rightRCL == null) {
            leftRCL.resetVirtualColumnIds();
            return leftRCL;
        }
        if (allTableName != null) {
            SanityManager.THROWASSERT("allTableName (" + String.valueOf(allTableName) + ") expected to be null");
        }
        joinRCL.destructiveAppend(leftRCL);
        joinRCL.destructiveAppend(rightRCL);
        joinRCL.resetVirtualColumnIds();
        return joinRCL;
    }

    private ResultColumnList getAllResultColumnsNoUsing(TableName allTableName) throws StandardException {
        ResultColumnList leftRCL = this.leftResultSet.getAllResultColumns(allTableName);
        ResultColumnList rightRCL = this.rightResultSet.getAllResultColumns(allTableName);
        if (leftRCL == null) {
            return rightRCL;
        }
        if (rightRCL == null) {
            return leftRCL;
        }
        if (allTableName != null) {
            SanityManager.THROWASSERT("allTableName (" + String.valueOf(allTableName) + ") expected to be null");
        }
        ResultColumnList tempList = new ResultColumnList(this.getContextManager());
        tempList.nondestructiveAppend(leftRCL);
        tempList.nondestructiveAppend(rightRCL);
        return tempList;
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultSetNode logicalLeftRS = this.getLogicalLeftResultSet();
        ResultSetNode logicalRightRS = this.getLogicalRightResultSet();
        ResultColumn resultColumn = null;
        ResultColumn rightRC = null;
        ResultColumn usingRC = null;
        ResultColumn leftRC = logicalLeftRS.getMatchingColumn(columnReference);
        if (leftRC != null) {
            resultColumn = leftRC;
            if (this.usingClause != null) {
                usingRC = this.usingClause.getResultColumn(leftRC.getName());
            }
        }
        if (usingRC == null) {
            rightRC = logicalRightRS.getMatchingColumn(columnReference);
        } else if (this instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)this).isRightOuterJoin()) {
            leftRC.setRightOuterJoinUsingClause(true);
        }
        if (rightRC != null) {
            if (leftRC != null) {
                throw StandardException.newException("42X03", columnReference.getSQLColumnName());
            }
            if (this instanceof HalfOuterJoinNode) {
                rightRC.setNullability(true);
            }
            resultColumn = rightRC;
        }
        if (this.getResultColumns() != null) {
            for (ResultColumn rc : this.getResultColumns()) {
                VirtualColumnNode vcn = (VirtualColumnNode)rc.getExpression();
                if (resultColumn != vcn.getSourceColumn()) continue;
                resultColumn = rc;
                break;
            }
        }
        return resultColumn;
    }

    @Override
    public void bindExpressions(FromList fromListParam) throws StandardException {
        super.bindExpressions(fromListParam);
        if (this.naturalJoin) {
            this.usingClause = this.getCommonColumnsForNaturalJoin();
        }
    }

    @Override
    void bindResultColumns(FromList fromListParam) throws StandardException {
        super.bindResultColumns(fromListParam);
        this.buildRCL();
        this.deferredBindExpressions(fromListParam);
    }

    @Override
    void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
        this.buildRCL();
        this.deferredBindExpressions(fromListParam);
    }

    private void buildRCL() throws StandardException {
        if (this.getResultColumns() != null) {
            return;
        }
        this.setResultColumns(this.leftResultSet.getResultColumns());
        ResultColumnList leftRCL = this.getResultColumns().copyListAndObjects();
        this.leftResultSet.setResultColumns(leftRCL);
        this.getResultColumns().genVirtualColumnNodes(this.leftResultSet, leftRCL, false);
        if (this instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)this).isRightOuterJoin()) {
            this.getResultColumns().setNullability(true);
        }
        ResultColumnList tmpRCL = this.rightResultSet.getResultColumns();
        ResultColumnList rightRCL = tmpRCL.copyListAndObjects();
        this.rightResultSet.setResultColumns(rightRCL);
        tmpRCL.genVirtualColumnNodes(this.rightResultSet, rightRCL, false);
        tmpRCL.adjustVirtualColumnIds(this.getResultColumns().size());
        if (this instanceof HalfOuterJoinNode && !((HalfOuterJoinNode)this).isRightOuterJoin()) {
            tmpRCL.setNullability(true);
        }
        this.getResultColumns().nondestructiveAppend(tmpRCL);
    }

    private void deferredBindExpressions(FromList fromListParam) throws StandardException {
        ContextManager cm = this.getContextManager();
        CompilerContext cc = this.getCompilerContext();
        this.subqueryList = new SubqueryList(cm);
        this.aggregates = new ArrayList<AggregateNode>();
        if (this.joinClause != null) {
            this.joinClause = this.bindExpression(this.joinClause, true, true, "ON");
        } else if (this.usingClause != null) {
            this.joinClause = new BooleanConstantNode(true, cm);
            for (ResultColumn rc : this.usingClause) {
                fromListParam.insertElementAt(this.leftResultSet, 0);
                ValueNode leftCR = new ColumnReference(rc.getName(), ((FromTable)this.leftResultSet).getTableName(), cm);
                leftCR = leftCR.bindExpression(fromListParam, this.subqueryList, (List)this.aggregates);
                fromListParam.removeElementAt(0);
                fromListParam.insertElementAt(this.rightResultSet, 0);
                ValueNode rightCR = new ColumnReference(rc.getName(), ((FromTable)this.rightResultSet).getTableName(), cm);
                rightCR = rightCR.bindExpression(fromListParam, this.subqueryList, (List)this.aggregates);
                fromListParam.removeElementAt(0);
                BinaryRelationalOperatorNode equalsNode = new BinaryRelationalOperatorNode(0, leftCR, rightCR, false, cm);
                equalsNode.bindComparisonOperator();
                AndNode newJoinClause = new AndNode(equalsNode, this.joinClause, cm);
                newJoinClause.postBindFixup();
                this.joinClause = newJoinClause;
            }
        }
        if (this.joinClause != null) {
            TypeId joinTypeId;
            if (this.joinClause.requiresTypeFromContext()) {
                this.joinClause.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
            }
            if ((joinTypeId = this.joinClause.getTypeId()).userType()) {
                this.joinClause = this.joinClause.genSQLJavaSQLTree();
            }
            if (!this.joinClause.getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) {
                throw StandardException.newException("42Y12", this.joinClause.getTypeServices().getTypeId().getSQLTypeName());
            }
        }
    }

    public ValueNode bindExpression(ValueNode expression, boolean useLeftChild, boolean useRightChild, String expressionType) throws StandardException {
        ContextManager cm = this.getContextManager();
        CompilerContext cc = this.getCompilerContext();
        FromList fromList = this.makeFromList(useLeftChild, useRightChild);
        int previousReliability = this.orReliability(16384);
        expression = expression.bindExpression(fromList, this.subqueryList, this.aggregates);
        cc.setReliability(previousReliability);
        SelectNode.checkNoWindowFunctions(expression, expressionType);
        if (!this.aggregates.isEmpty()) {
            throw StandardException.newException("42Z07", new Object[0]);
        }
        return expression;
    }

    public FromList makeFromList(boolean useLeftChild, boolean useRightChild) throws StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        if (useLeftChild) {
            fromList.addElement((FromTable)this.leftResultSet);
        }
        if (useRightChild) {
            fromList.addElement((FromTable)this.rightResultSet);
        }
        return fromList;
    }

    private ResultColumnList getCommonColumnsForNaturalJoin() throws StandardException {
        ResultColumnList leftRCL = this.getLeftResultSet().getAllResultColumns(null);
        ResultColumnList rightRCL = this.getRightResultSet().getAllResultColumns(null);
        List<String> columnNames = JoinNode.extractColumnNames(leftRCL);
        columnNames.retainAll(JoinNode.extractColumnNames(rightRCL));
        ResultColumnList commonColumns = new ResultColumnList(this.getContextManager());
        for (String name : columnNames) {
            ResultColumn rc = new ResultColumn(name, null, this.getContextManager());
            commonColumns.addResultColumn(rc);
        }
        return commonColumns;
    }

    private static List<String> extractColumnNames(ResultColumnList rcl) {
        ArrayList<String> names = new ArrayList<String>();
        for (ResultColumn rc : rcl) {
            names.add(rc.getName());
        }
        return names;
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        ResultSetNode newTreeTop = super.preprocess(numTables, gbl, fromList);
        if (this.joinClause != null) {
            this.normExpressions();
            if (this.subqueryList != null) {
                this.joinClause = this.joinClause.preprocess(numTables, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), new SubqueryList(this.getContextManager()), new PredicateList(this.getContextManager()));
            }
            this.joinPredicates.pullExpressions(numTables, this.joinClause);
            this.joinPredicates.categorize();
            this.joinClause = null;
        }
        return newTreeTop;
    }

    @Override
    void projectResultColumns() throws StandardException {
        this.leftResultSet.projectResultColumns();
        this.rightResultSet.projectResultColumns();
        this.getResultColumns().pullVirtualIsReferenced();
        super.projectResultColumns();
    }

    void normExpressions() throws StandardException {
        if (this.joinClauseNormalized) {
            return;
        }
        this.joinClause = this.joinClause.eliminateNots(false);
        if (!this.joinClause.verifyEliminateNots()) {
            this.joinClause.treePrint();
            SanityManager.THROWASSERT("joinClause in invalid form: " + String.valueOf(this.joinClause));
        }
        this.joinClause = this.joinClause.putAndsOnTop();
        if (!(this.joinClause instanceof AndNode) || !this.joinClause.verifyPutAndsOnTop()) {
            this.joinClause.treePrint();
            SanityManager.THROWASSERT("joinClause in invalid form: " + String.valueOf(this.joinClause));
        }
        this.joinClause = this.joinClause.changeToCNF(false);
        if (!(this.joinClause instanceof AndNode) || !this.joinClause.verifyChangeToCNF()) {
            this.joinClause.treePrint();
            SanityManager.THROWASSERT("joinClause in invalid form: " + String.valueOf(this.joinClause));
        }
        this.joinClauseNormalized = true;
    }

    @Override
    void pushExpressions(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        if (this instanceof HalfOuterJoinNode) {
            SanityManager.THROWASSERT("JN.pushExpressions() not expected to be called for " + this.getClass().getName());
        }
        this.pushExpressionsToLeft(outerPredicateList);
        leftFromTable.pushExpressions(this.getLeftPredicateList());
        this.pushExpressionsToRight(outerPredicateList);
        rightFromTable.pushExpressions(this.getRightPredicateList());
        this.grabJoinPredicates(outerPredicateList);
        if (this.getLeftPredicateList().size() != 0) {
            SanityManager.THROWASSERT("getLeftPredicateList().size() expected to be 0, not " + this.getLeftPredicateList().size());
        }
        if (this.getRightPredicateList().size() != 0) {
            SanityManager.THROWASSERT("getRightPredicateList().size() expected to be 0, not " + this.getRightPredicateList().size());
        }
    }

    protected void pushExpressionsToLeft(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        JBitSet leftReferencedTableMap = leftFromTable.getReferencedTableMap();
        for (int index = outerPredicateList.size() - 1; index >= 0; --index) {
            JBitSet curBitSet;
            Predicate predicate = (Predicate)outerPredicateList.elementAt(index);
            if (!predicate.getPushable() || !leftReferencedTableMap.contains(curBitSet = predicate.getReferencedSet())) continue;
            this.getLeftPredicateList().addPredicate(predicate);
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(rcrv);
            predicate.getAndNode().accept(rcrv);
            outerPredicateList.removeElementAt(index);
        }
    }

    private void pushExpressionsToRight(PredicateList outerPredicateList) throws StandardException {
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        JBitSet rightReferencedTableMap = rightFromTable.getReferencedTableMap();
        for (int index = outerPredicateList.size() - 1; index >= 0; --index) {
            JBitSet curBitSet;
            Predicate predicate = (Predicate)outerPredicateList.elementAt(index);
            if (!predicate.getPushable() || !rightReferencedTableMap.contains(curBitSet = predicate.getReferencedSet())) continue;
            this.getRightPredicateList().addPredicate(predicate);
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(rcrv);
            predicate.getAndNode().accept(rcrv);
            outerPredicateList.removeElementAt(index);
        }
    }

    private void grabJoinPredicates(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        JBitSet leftReferencedTableMap = leftFromTable.getReferencedTableMap();
        JBitSet rightReferencedTableMap = rightFromTable.getReferencedTableMap();
        for (int index = outerPredicateList.size() - 1; index >= 0; --index) {
            Predicate predicate = (Predicate)outerPredicateList.elementAt(index);
            if (!predicate.getPushable()) continue;
            JBitSet curBitSet = predicate.getReferencedSet();
            JBitSet innerBitSet = (JBitSet)rightReferencedTableMap.clone();
            innerBitSet.or(leftReferencedTableMap);
            if (!innerBitSet.contains(curBitSet)) continue;
            this.joinPredicates.addPredicate(predicate);
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(rcrv);
            predicate.getAndNode().accept(rcrv);
            outerPredicateList.removeElementAt(index);
        }
    }

    @Override
    FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl, ValueNode havingClause) throws StandardException {
        if (this instanceof HalfOuterJoinNode) {
            SanityManager.THROWASSERT("JN.flatten() not expected to be called for " + this.getClass().getName());
        }
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        fromList.addElement((FromTable)this.leftResultSet);
        fromList.addElement((FromTable)this.rightResultSet);
        this.getResultColumns().setRedundant();
        rcl.remapColumnReferencesToExpressions();
        outerPList.remapColumnReferencesToExpressions();
        if (gbl != null) {
            gbl.remapColumnReferencesToExpressions();
        }
        if (havingClause != null) {
            havingClause.remapColumnReferencesToExpressions();
        }
        if (this.joinPredicates.size() > 0) {
            outerPList.destructiveAppend(this.joinPredicates);
        }
        if (this.subqueryList != null && this.subqueryList.size() > 0) {
            sql.destructiveAppend(this.subqueryList);
        }
        return fromList;
    }

    @Override
    boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    @Override
    FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        if (predicateTree == null) {
            ((FromTable)this.leftResultSet).transformOuterJoins(null, numTables);
            ((FromTable)this.rightResultSet).transformOuterJoins(null, numTables);
            return this;
        }
        this.leftResultSet = ((FromTable)this.leftResultSet).transformOuterJoins(predicateTree, numTables);
        this.rightResultSet = ((FromTable)this.rightResultSet).transformOuterJoins(predicateTree, numTables);
        return this;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCore(acb, mb, 1, null, null);
    }

    void generateCore(ActivationClassBuilder acb, MethodBuilder mb, int joinType) throws StandardException {
        this.generateCore(acb, mb, joinType, this.joinClause, this.subqueryList);
    }

    void generateCore(ActivationClassBuilder acb, MethodBuilder mb, int joinType, ValueNode joinClause, SubqueryList subquerys) throws StandardException {
        if (this.joinPredicates != null) {
            joinClause = this.joinPredicates.restorePredicates();
            this.joinPredicates = null;
        }
        this.assignResultSetNumber();
        if (subquerys != null && subquerys.size() > 0) {
            subquerys.setPointOfAttachment(this.getResultSetNumber());
        }
        String joinResultSetString = joinType == 3 ? ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().halfOuterJoinResultSetMethodName() : ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().joinResultSetMethodName();
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getJoinArguments(acb, mb, joinClause);
        mb.callMethod((short)185, null, joinResultSetString, "org.apache.derby.iapi.sql.execute.NoPutResultSet", nargs);
    }

    private int getJoinArguments(ActivationClassBuilder acb, MethodBuilder mb, ValueNode joinClause) throws StandardException {
        int numArgs = this.getNumJoinArguments();
        this.leftResultSet.generate(acb, mb);
        mb.push(this.leftResultSet.getResultColumns().size());
        this.rightResultSet.generate(acb, mb);
        mb.push(this.rightResultSet.getResultColumns().size());
        this.setCostEstimate(this.getFinalCostEstimate());
        if (joinClause == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            joinClause.generate(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(this.getResultSetNumber());
        this.addOuterJoinArguments(acb, mb);
        this.oneRowRightSide(acb, mb);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        if (this.joinOrderStrategyProperties != null) {
            mb.push(PropertyUtil.sortProperties(this.joinOrderStrategyProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        return numArgs;
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        CostEstimate leftCE = this.leftResultSet.getFinalCostEstimate();
        CostEstimate rightCE = this.rightResultSet.getFinalCostEstimate();
        this.setCandidateFinalCostEstimate(this.getNewCostEstimate());
        this.getCandidateFinalCostEstimate().setCost(leftCE.getEstimatedCost() + rightCE.getEstimatedCost(), rightCE.rowCount(), rightCE.rowCount());
        return this.getCandidateFinalCostEstimate();
    }

    void oneRowRightSide(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.push(this.rightResultSet.isOneRowResultSet());
        mb.push(this.rightResultSet.isNotExists());
    }

    protected int getNumJoinArguments() {
        return 11;
    }

    int addOuterJoinArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        return 0;
    }

    static String joinTypeToString(int joinType) {
        switch (joinType) {
            case 1: {
                return "INNER JOIN";
            }
            case 2: {
                return "CROSS JOIN";
            }
            case 3: {
                return "LEFT OUTER JOIN";
            }
            case 4: {
                return "RIGHT OUTER JOIN";
            }
            case 5: {
                return "FULL OUTER JOIN";
            }
            case 6: {
                return "UNION JOIN";
            }
        }
        SanityManager.ASSERT(false, "Unexpected joinType");
        return null;
    }

    protected PredicateList getLeftPredicateList() throws StandardException {
        if (this.leftPredicateList == null) {
            this.leftPredicateList = new PredicateList(this.getContextManager());
        }
        return this.leftPredicateList;
    }

    protected PredicateList getRightPredicateList() throws StandardException {
        if (this.rightPredicateList == null) {
            this.rightPredicateList = new PredicateList(this.getContextManager());
        }
        return this.rightPredicateList;
    }

    @Override
    int updateTargetLockMode() {
        return 6;
    }

    @Override
    void notFlattenableJoin() {
        this.flattenableJoin = false;
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
    }

    @Override
    boolean isFlattenableJoinNode() {
        return this.flattenableJoin;
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, List<FromBaseTable> fbtHolder) throws StandardException {
        return this.leftResultSet.isOrderedOn(crs, permuteOrdering, fbtHolder);
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subqueryList != null) {
            this.printLabel(depth, "subqueryList: ");
            this.subqueryList.treePrint(depth + 1);
        }
        if (this.joinClause != null) {
            this.printLabel(depth, "joinClause: ");
            this.joinClause.treePrint(depth + 1);
        }
        if (this.joinPredicates.size() != 0) {
            this.printLabel(depth, "joinPredicates: ");
            this.joinPredicates.treePrint(depth + 1);
        }
        if (this.usingClause != null) {
            this.printLabel(depth, "usingClause: ");
            this.usingClause.treePrint(depth + 1);
        }
    }

    void setSubqueryList(SubqueryList subqueryList) {
        this.subqueryList = subqueryList;
    }

    void setAggregates(List<AggregateNode> aggregates) {
        this.aggregates = aggregates;
    }

    void setNaturalJoin() {
        this.naturalJoin = true;
    }

    ResultSetNode getLogicalLeftResultSet() {
        return this.leftResultSet;
    }

    ResultSetNode getLogicalRightResultSet() {
        return this.rightResultSet;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.getResultColumns() != null) {
            this.setResultColumns((ResultColumnList)this.getResultColumns().accept(v));
        }
        if (this.joinClause != null) {
            this.joinClause = (ValueNode)this.joinClause.accept(v);
        }
        if (this.usingClause != null) {
            this.usingClause = (ResultColumnList)this.usingClause.accept(v);
        }
        if (this.joinPredicates != null) {
            this.joinPredicates = (PredicateList)this.joinPredicates.accept(v);
        }
    }

    @Override
    JBitSet LOJgetReferencedTables(int numTables) throws StandardException {
        JBitSet map = this.leftResultSet.LOJgetReferencedTables(numTables);
        if (map == null) {
            return null;
        }
        map.or(this.rightResultSet.LOJgetReferencedTables(numTables));
        return map;
    }
}

