/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.api;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.optional.utils.ToolUtilities;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public abstract class SimpleJsonUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray toJSON(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JSONArray result = new JSONArray();
        try {
            while (rs.next()) {
                JSONObject row = new JSONObject();
                for (int i = 1; i <= columnCount; ++i) {
                    String keyName = rsmd.getColumnName(i);
                    Object value = SimpleJsonUtils.getLegalJsonValue(rs.getObject(i));
                    row.put((Object)keyName, value);
                }
                result.add((Object)row);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return result;
    }

    public static JSONArray readArray(Reader reader) throws SQLException {
        JSONParser parser = new JSONParser();
        Object obj = null;
        try {
            obj = parser.parse(reader);
        }
        catch (Throwable t) {
            throw ToolUtilities.wrap(t);
        }
        if (obj == null || !(obj instanceof JSONArray)) {
            throw new SQLException("Document is not a JSON array.");
        }
        return (JSONArray)obj;
    }

    public static JSONArray readArrayFromString(String document) throws SQLException {
        if (document == null) {
            document = "";
        }
        return SimpleJsonUtils.readArray(new StringReader(document));
    }

    public static JSONArray readArrayFromStream(InputStream inputStream, String characterSetName) throws SQLException {
        try {
            JSONArray jSONArray = SimpleJsonUtils.readArray(new InputStreamReader(inputStream, characterSetName));
            return jSONArray;
        }
        catch (UnsupportedEncodingException uee) {
            throw ToolUtilities.wrap(uee);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                throw ToolUtilities.wrap(ioe);
            }
        }
    }

    public static JSONArray readArrayFromFile(String fileName, String characterSetName) throws SQLException {
        FileInputStream fis = null;
        String name_of_file = fileName;
        try {
            fis = new FileInputStream(name_of_file);
        }
        catch (Exception pae) {
            throw ToolUtilities.wrap(pae);
        }
        return SimpleJsonUtils.readArrayFromStream(fis, characterSetName);
    }

    public static JSONArray readArrayFromURL(String urlString, String characterSetName) throws SQLException {
        InputStream inputStream = null;
        String url_string = urlString;
        try {
            URL url = new URI(url_string).toURL();
            inputStream = url.openStream();
        }
        catch (Exception pae) {
            throw ToolUtilities.wrap(pae);
        }
        return SimpleJsonUtils.readArrayFromStream(inputStream, characterSetName);
    }

    public static Clob arrayToClob(JSONArray array) {
        if (array == null) {
            return null;
        }
        return new HarmonySerialClob(array.toJSONString());
    }

    private static Object getLegalJsonValue(Object obj) throws SQLException {
        if (obj == null || obj instanceof Long || obj instanceof Double || obj instanceof Boolean || obj instanceof String || obj instanceof JSONObject || obj instanceof JSONArray) {
            return obj;
        }
        if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            return SimpleJsonUtils.formatBytes(blob.getBytes(1L, (int)blob.length()));
        }
        if (obj instanceof byte[]) {
            return SimpleJsonUtils.formatBytes((byte[])obj);
        }
        return obj.toString();
    }

    private static String formatBytes(byte[] bytes) {
        return StringUtil.toHexString((byte[])bytes, (int)0, (int)bytes.length);
    }

    private static Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }
}

