/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Changes10_10
extends UpgradeChange {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String HARD_UPGRADE_REQUIRED = "XCL47";
    private static final String NEEDS_JAVA_STYLE = "42ZCA";
    private static final String DB_README_FILE_NAME = "README_DO_NOT_TOUCH_FILES.txt";
    static final float[] beyondDB2Real = new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 1.174E-37f, -1.174E-37f, Float.MIN_NORMAL, -1.1754944E-38f};
    static final double[] beyondDB2Double = new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 2.224E-307, -2.224E-307, Double.MIN_NORMAL, -2.2250738585072014E-308};

    public Changes10_10(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        BaseTestSuite suite = new BaseTestSuite("Upgrade test for 10.9");
        suite.addTestSuite(Changes10_10.class);
        return new SupportFilesSetup((Test)suite);
    }

    public void testProcsNewTo10_10() throws Exception {
        Statement s = this.createStatement();
        String iss = "call syscs_util.SYSCS_INVALIDATE_STORED_STATEMENTS()";
        String rt = "call syscs_util.syscs_register_tool( 'foo', true )";
        String rtGoodSQLState = "X0Y88";
        String syntaxError = SYNTAX_ERROR;
        boolean atLeastJava5 = JDBC.vmSupportsJDBC3();
        boolean oldSupportsBoolean = this.oldAtLeast(10, 7);
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                this.vetProcs(s, iss, false, null);
                if (!atLeastJava5) break;
                this.vetProcs(s, rt, false, oldSupportsBoolean || this.getPhase() == 1 ? null : syntaxError);
                break;
            }
            case 3: {
                this.vetProcs(s, iss, true, null);
                if (!atLeastJava5) break;
                this.vetProcs(s, rt, true, rtGoodSQLState);
            }
        }
        s.close();
    }

    private void vetProcs(Statement s, String procCall, boolean shouldExist, String sqlState) throws Exception {
        try {
            s.execute(procCall);
            if (!shouldExist) {
                Changes10_10.fail((String)"Procedure should not exist!");
            }
            if (sqlState != null) {
                Changes10_10.fail((String)("Expected to fail with SQLState " + sqlState));
            }
        }
        catch (SQLException se) {
            if (sqlState == null) {
                sqlState = "42Y03";
            }
            Changes10_10.assertSQLState(sqlState, se);
        }
    }

    public void testUDAs() throws Exception {
        Statement st = this.createStatement();
        String createUDA = "create derby aggregate mode for int external name 'foo.bar.Wibble'";
        String dropUDA = "drop derby aggregate mode restrict";
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_10.assertStatementError(SYNTAX_ERROR, st, createUDA);
                Changes10_10.assertStatementError(SYNTAX_ERROR, st, dropUDA);
                break;
            }
            case 1: {
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, st, createUDA);
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, st, dropUDA);
                break;
            }
            case 3: {
                st.execute(createUDA);
                st.execute(dropUDA);
            }
        }
        st.close();
    }

    public void testVarargss() throws Exception {
        Statement st = this.createStatement();
        String createVarargsProc = "create procedure vds ( a int ... ) language java parameter style derby no sql external name 'Foo.foo'";
        String createVarargsFunc = "create function vds ( a int ... ) returns integer language java parameter style derby no sql external name 'Foo.foo'";
        String createVarargsTableFunc = "create function vtf ( a int ... ) returns table ( b int ) language java parameter style derby_jdbc_result_set no sql external name 'Foo.foo'";
        String createNonVarargsProcDerbyStyle = "create procedure nvds ( a int ) language java parameter style derby no sql external name 'Foo.foo'";
        String createNonVarargsFuncDerbyStyle = "create function nvds ( a int ) returns integer language java parameter style derby no sql external name 'Foo.foo'";
        boolean tableFunctionsOK = this.oldAtLeast(10, 4);
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_10.assertStatementError(SYNTAX_ERROR, st, createVarargsProc);
                Changes10_10.assertStatementError(SYNTAX_ERROR, st, createVarargsFunc);
                if (tableFunctionsOK) {
                    Changes10_10.assertStatementError(SYNTAX_ERROR, st, createVarargsTableFunc);
                }
                Changes10_10.assertStatementError(SYNTAX_ERROR, st, createNonVarargsProcDerbyStyle);
                Changes10_10.assertStatementError(SYNTAX_ERROR, st, createNonVarargsFuncDerbyStyle);
                break;
            }
            case 1: {
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, st, createVarargsProc);
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, st, createVarargsFunc);
                if (tableFunctionsOK) {
                    Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, st, createVarargsTableFunc);
                }
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, st, createNonVarargsProcDerbyStyle);
                Changes10_10.assertStatementError(HARD_UPGRADE_REQUIRED, st, createNonVarargsFuncDerbyStyle);
                break;
            }
            case 3: {
                st.execute(createVarargsProc);
                st.execute(createVarargsFunc);
                st.execute(createVarargsTableFunc);
                Changes10_10.assertStatementError(NEEDS_JAVA_STYLE, st, createNonVarargsProcDerbyStyle);
                Changes10_10.assertStatementError(NEEDS_JAVA_STYLE, st, createNonVarargsFuncDerbyStyle);
            }
        }
        st.close();
    }

    public void testReadMeFiles() throws SQLException, IOException {
        Statement s = this.createStatement();
        s.close();
        TestConfiguration currentConfig = TestConfiguration.getCurrent();
        String dbPath = currentConfig.getDatabasePath(currentConfig.getDefaultDatabaseName());
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                this.lookForReadmeFile(dbPath, false);
                this.lookForReadmeFile(dbPath + File.separator + "seg0", false);
                this.lookForReadmeFile(dbPath + File.separator + "log", false);
                break;
            }
            case 3: 
            case 4: {
                this.lookForReadmeFile(dbPath, true);
                this.lookForReadmeFile(dbPath + File.separator + "seg0", true);
                this.lookForReadmeFile(dbPath + File.separator + "log", true);
            }
        }
    }

    private void lookForReadmeFile(String path, boolean fileShouldExist) throws IOException {
        File readmeFile = new File(path, DB_README_FILE_NAME);
        if (fileShouldExist) {
            Changes10_10.assertTrue((String)(String.valueOf(readmeFile) + "doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(readmeFile));
        } else {
            Changes10_10.assertFalse((String)(String.valueOf(readmeFile) + "exists"), (boolean)PrivilegedFileOpsForTests.exists(readmeFile));
        }
    }

    public void testFloatLimits() throws Exception {
        if (JVMInfo.isModuleAware()) {
            return;
        }
        Statement st = this.createStatement();
        st.execute("create table d3398(r real, d double)");
        PreparedStatement psInsertReal = this.prepareStatement("insert into d3398(r) values (?)");
        PreparedStatement psInsertDouble = this.prepareStatement("insert into d3398(d) values (?)");
        PreparedStatement psSelect = this.prepareStatement("select * from d3398", 1003, 1008);
        st.execute("insert into d3398 values (0.0, 0.0)");
        switch (this.getPhase()) {
            case 0: {
                this.verifyDB2Behavior(psSelect, psInsertReal, psInsertDouble, false);
                break;
            }
            case 2: {
                this.verifyDB2Behavior(psSelect, psInsertReal, psInsertDouble, false);
                break;
            }
            case 1: {
                this.verifyDB2Behavior(psSelect, psInsertReal, psInsertDouble, true);
                break;
            }
            case 3: {
                ResultSet rs;
                int i;
                for (i = 0; i < beyondDB2Real.length; ++i) {
                    psInsertReal.setFloat(1, beyondDB2Real[i]);
                    psInsertReal.execute();
                    rs = psSelect.executeQuery();
                    rs.next();
                    rs.updateFloat(1, beyondDB2Real[i]);
                    rs.updateRow();
                    rs.close();
                }
                for (i = 0; i < beyondDB2Double.length; ++i) {
                    psInsertDouble.setDouble(1, beyondDB2Double[i]);
                    psInsertDouble.execute();
                    rs = psSelect.executeQuery();
                    rs.next();
                    rs.updateDouble(2, beyondDB2Double[i]);
                    rs.updateRow();
                    rs.close();
                }
                break;
            }
        }
        st.executeUpdate("drop table d3398");
        st.close();
    }

    private void assertSetError(PreparedStatement ps, float fv, boolean defer) throws SQLException {
        try {
            ps.setFloat(1, fv);
            if (!defer) {
                Changes10_10.fail();
            }
            ps.executeUpdate();
            Changes10_10.fail();
        }
        catch (SQLException e) {
            Changes10_10.assertSQLState("22003", e);
        }
    }

    private void assertSetError(PreparedStatement ps, double dv, boolean defer) throws SQLException {
        try {
            ps.setDouble(1, dv);
            if (!defer) {
                Changes10_10.fail();
            }
            ps.executeUpdate();
            Changes10_10.fail();
        }
        catch (SQLException e) {
            Changes10_10.assertSQLState("22003", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUpdateError(PreparedStatement ps, float fv, boolean defer) throws SQLException {
        boolean supportsForwardUpdatableResultSet = this.oldAtLeast(10, 2);
        if (!supportsForwardUpdatableResultSet) {
            return;
        }
        ResultSet rs = ps.executeQuery();
        rs.next();
        try {
            rs.updateFloat(1, fv);
            if (!defer) {
                Changes10_10.fail();
            }
            rs.updateRow();
            Changes10_10.fail();
        }
        catch (SQLException e) {
            Changes10_10.assertSQLState("22003", e);
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUpdateError(PreparedStatement ps, double fv, boolean defer) throws SQLException {
        boolean supportsForwardUpdatableResultSet = this.oldAtLeast(10, 2);
        if (!supportsForwardUpdatableResultSet) {
            return;
        }
        ResultSet rs = ps.executeQuery();
        rs.next();
        try {
            rs.updateDouble(1, fv);
            if (!defer) {
                Changes10_10.fail();
            }
            rs.updateRow();
            Changes10_10.fail();
        }
        catch (SQLException e) {
            Changes10_10.assertSQLState("22003", e);
        }
        finally {
            rs.close();
        }
    }

    private void verifyDB2Behavior(PreparedStatement psSelect, PreparedStatement psInsertReal, PreparedStatement psInsertDouble, boolean defer) throws SQLException {
        int i;
        for (i = 0; i < beyondDB2Real.length; ++i) {
            this.assertSetError(psInsertReal, beyondDB2Real[i], defer);
            this.assertUpdateError(psSelect, beyondDB2Real[i], defer);
        }
        for (i = 0; i < beyondDB2Double.length; ++i) {
            this.assertSetError(psInsertDouble, beyondDB2Double[i], defer);
            this.assertUpdateError(psSelect, beyondDB2Double[i], defer);
        }
    }
}

