/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class BlockedByteArrayTest
extends BaseTestCase {
    public BlockedByteArrayTest(String name) {
        super(name);
    }

    public void testLengthNoInitialBlocksWriteSingleByte() {
        BlockedByteArray src = new BlockedByteArray();
        BlockedByteArrayTest.assertEquals((long)0L, (long)src.length());
        src.writeByte(0L, (byte)1);
        BlockedByteArrayTest.assertEquals((long)1L, (long)src.length());
        for (int i = 0; i < 67584; ++i) {
            src.writeByte((long)(1 + i), (byte)i);
            BlockedByteArrayTest.assertEquals((long)(i + 2), (long)src.length());
        }
    }

    public void testLengthNoInitialBlocksWriteMultipleBytes4K() {
        BlockedByteArray src = new BlockedByteArray();
        byte[] buf = new byte[4096];
        Arrays.fill(buf, (byte)1);
        src.writeBytes(0L, buf, 0, buf.length);
        BlockedByteArrayTest.assertEquals((long)buf.length, (long)src.length());
        Arrays.fill(buf, (byte)2);
        src.writeBytes((long)buf.length, buf, 0, buf.length);
        BlockedByteArrayTest.assertEquals((long)(2 * buf.length), (long)src.length());
        src.writeByte(69L, (byte)8);
        BlockedByteArrayTest.assertEquals((long)(2 * buf.length), (long)src.length());
    }

    public void testLengthNoInitialBlocksWriteMultipleBytes4KPlussAFew() {
        BlockedByteArray src = new BlockedByteArray();
        byte[] buf = new byte[4133];
        Arrays.fill(buf, (byte)1);
        src.writeBytes(0L, buf, 0, buf.length);
        BlockedByteArrayTest.assertEquals((long)buf.length, (long)src.length());
        Arrays.fill(buf, (byte)2);
        src.writeBytes((long)buf.length, buf, 0, buf.length);
        BlockedByteArrayTest.assertEquals((long)(2 * buf.length), (long)src.length());
        src.writeByte(54L, (byte)7);
        BlockedByteArrayTest.assertEquals((long)(2 * buf.length), (long)src.length());
    }

    public void testReadArray() throws IOException {
        int read;
        int size = 66560;
        BlockedByteArray src = this.createBlockedByteArray(size);
        byte[] buf = new byte[4096];
        for (read = 0; read < size; read += src.read((long)read, buf, 0, buf.length)) {
        }
        src = this.createBlockedByteArray(size);
        buf = new byte[2567];
        for (read = 0; read < size; read += src.read((long)read, buf, 0, buf.length)) {
        }
        src = this.createBlockedByteArray(size);
        buf = new byte[16384];
        for (read = 0; read < size; read += src.read((long)read, buf, 0, buf.length)) {
        }
    }

    public void testReadSingle() throws IOException {
        int size = 66560;
        BlockedByteArray src = this.createBlockedByteArray(size);
        int read = 0;
        while (src.read((long)read) != -1) {
            ++read;
        }
    }

    public void testLength() throws IOException {
        BlockedByteArray src = this.createBlockedByteArray(0L);
        BlockedByteArrayTest.assertEquals((long)0L, (long)src.length());
        src.writeByte(0L, (byte)1);
        BlockedByteArrayTest.assertEquals((long)1L, (long)src.length());
        src.writeByte(0L, (byte)1);
        BlockedByteArrayTest.assertEquals((long)1L, (long)src.length());
        src.writeByte(9L, (byte)2);
        BlockedByteArrayTest.assertEquals((long)10L, (long)src.length());
        byte[] bytes = new byte[4096];
        Arrays.fill(bytes, (byte)7);
        src.writeBytes(0L, bytes, 0, bytes.length);
        BlockedByteArrayTest.assertEquals((long)bytes.length, (long)src.length());
        src.writeBytes((long)bytes.length, bytes, 0, bytes.length);
        BlockedByteArrayTest.assertEquals((long)(2 * bytes.length), (long)src.length());
        src.setLength(55555L);
        BlockedByteArrayTest.assertEquals((long)55555L, (long)src.length());
        src.setLength(44444L);
        BlockedByteArrayTest.assertEquals((long)44444L, (long)src.length());
    }

    public void testCapacityGrowth() throws IOException {
        BlockedByteArray src = this.createBlockedByteArray(0L);
        src.setLength(0x100000L);
        src.setLength(0xA00000L);
        src.setLength(0x500000L);
        src.setLength(0x700000L);
        BlockedByteArrayTest.assertEquals((long)0x700000L, (long)src.length());
        src.setLength(0L);
        BlockedByteArrayTest.assertEquals((long)0L, (long)src.length());
        src.setLength(0x2700000L);
        src.setLength(40894465L);
        BlockedByteArrayTest.assertEquals((long)40894465L, (long)src.length());
        src.setLength(0x2700000L);
        BlockedByteArrayTest.assertEquals((long)0x2700000L, (long)src.length());
        src.setLength(0x2700000L);
        BlockedByteArrayTest.assertEquals((long)0x2700000L, (long)src.length());
        src.setLength(-1L);
        BlockedByteArrayTest.assertEquals((long)0L, (long)src.length());
    }

    public static Test suite() {
        return new BaseTestSuite(BlockedByteArrayTest.class);
    }

    private BlockedByteArray createBlockedByteArray(long length) throws IOException {
        int readFromSrc;
        BlockedByteArray data = new BlockedByteArray();
        LoopingAlphabetStream src = new LoopingAlphabetStream(length);
        byte[] buf = new byte[4096];
        for (long pos = 0L; pos < length; pos += (long)data.writeBytes(pos, buf, 0, readFromSrc)) {
            readFromSrc = src.read(buf);
        }
        return data;
    }
}

