/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.tools.dblook;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class dblook_test {
    private static final int SERVER_PORT = 1527;
    private static final int FRONT = -1;
    private static final int REAR = 1;
    protected static final String dbCreationScript_1 = "dblook_makeDB.sql";
    protected static final String dbCreationScript_2 = "dblook_makeDB_2.sql";
    private static final char TEST_DELIMITER = '#';
    protected static String testDirectory = "dblook_test";
    protected static String testDBName = "wombat";
    protected static String separator;
    private static String dbPath;
    private static int duplicateCounter;
    private static int sysNameCount;
    private static String jdbcProtocol;
    protected static String territoryBased;
    protected static String expectedCollation;
    private static final String[] ignorableSchemaNames;

    public static void main(String[] stringArray) {
        separator = System.getProperty("file.separator");
        new dblook_test().doTest();
        System.out.println("\n[ Done. ]\n");
        dblook_test.renameDbLookLog("dblook_test");
    }

    protected void doTest() {
        try {
            System.out.println("\n-= Start dblook Functional Tests. =-");
            this.createTestDatabase(dbCreationScript_1);
            this.runDBLook(testDBName);
            System.out.println("\n-= Start dblook Message Tests =-");
            this.createTestDatabase(dbCreationScript_2);
            this.runMessageCheckTest(testDBName);
            System.out.println("\n-= Start DERBY-6387 test. =-");
            this.testDerby6387();
        }
        catch (SQLException sQLException) {
            System.out.println("FAILED: to complete the test:");
            sQLException.printStackTrace(System.out);
            for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
                sQLException2.printStackTrace(System.out);
            }
        }
        catch (Exception exception) {
            System.out.println("FAILED: to complete the test:");
            exception.printStackTrace(System.out);
        }
    }

    protected void createTestDatabase(String string) throws Exception {
        try {
            this.deleteDB(testDBName);
        }
        catch (Exception exception) {
            System.out.println("** Warning: failed to delete old test db before creating a new one...");
        }
        Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        jdbcProtocol = "jdbc:derby:";
        this.createDBFromDDL(testDBName, string);
        String string2 = System.getProperty("derby.system.home");
        dbPath = string2 + File.separatorChar;
    }

    private void runDBLook(String string) throws Exception {
        System.err.close();
        this.dumpSysCatalogs(string);
        this.lookOne(string);
        this.dumpFileToSysOut("dblook.log");
        String string2 = string + "_new";
        this.createDBFromDDL(string2, string + ".sql");
        this.deleteFile(new File(string + ".sql"));
        this.dumpSysCatalogs(string2);
        this.deleteDB(string2);
        this.deleteFile(new File(string2 + ".sql"));
        this.runAllTests(string, string2);
    }

    protected void runAllTests(String string, String string2) throws Exception {
        this.runTest(2, string, string2);
        this.runTest(4, string, string2);
        this.runTest(5, string, string2);
        this.runTest(7, string, string2);
        this.runTest(6, string, string2);
    }

    protected void runTest(int n, String string, String string2) {
        try {
            switch (n) {
                case 2: {
                    this.lookTwo(string);
                    break;
                }
                case 3: {
                    this.lookThree(string);
                    break;
                }
                case 4: {
                    this.lookFour(string);
                    break;
                }
                case 5: {
                    this.lookFive(string);
                    break;
                }
                case 6: {
                    this.lookSix(string);
                    break;
                }
                case 7: {
                    this.lookSeven(string);
                    break;
                }
            }
            this.dumpFileToSysOut("dblook.log");
            this.createDBFromDDL(string2, string + ".sql");
            this.dumpSysCatalogs(string2);
            this.deleteDB(string2);
            this.deleteFile(new File(string + ".sql"));
        }
        catch (SQLException sQLException) {
            System.out.println("FAILED: Test # : " + n);
            sQLException.printStackTrace(System.out);
            for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
                sQLException2.printStackTrace(System.out);
            }
        }
        catch (Exception exception) {
            System.out.println("FAILED: Test # : " + n);
            exception.printStackTrace(System.out);
        }
    }

    private void lookOne(String string) throws Exception {
        this.printAsHeader("\nDumping full schema for '" + string + "'\nto file '" + string + ".sql':\n");
        String[] stringArray = new String[]{"-o", string + ".sql", "-td", ""};
        this.go(string, stringArray);
    }

    private void lookTwo(String string) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects with schema\n'BAR', excluding views:\n");
        String[] stringArray = new String[]{"-o", string + ".sql", "-td", "", "-z", "bar", "-noview"};
        this.go(string, stringArray);
    }

    private void lookThree(String string) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects, using\nNetwork Server:\n");
        String string2 = TestUtil.getHostName();
        jdbcProtocol = TestUtil.getJdbcUrlPrefix(string2, 1527);
        String string3 = TestUtil.isJCCFramework() ? jdbcProtocol + "\"" + dbPath + separator + string + "\":user=app;password=apppw;" : jdbcProtocol + dbPath + separator + string + ";user=app;password=apppw";
        try {
            DriverManager.getConnection("jdbc:derby:" + string + ";shutdown=true;user=app;password=apppw");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new dblook(new String[]{"-d", string3, "-o", string + ".sql", "-td", ""});
        }
        catch (Exception exception) {
            System.out.println("FAILED: ");
            exception.printStackTrace(System.out);
        }
    }

    private void lookFour(String string) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects with schema 'BAR'\nthat are related to tables 'T3', 'tWithKeys',\nand 'MULTI WORD NAME':\n");
        String[] stringArray = new String[]{"-o", string + ".sql", "-td", "", "-z", "BAR", "-t", "t3", "\"tWithKeys\"", "Multi word name"};
        this.go(string, stringArray);
    }

    private void lookFive(String string) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects related to 'T1'\nand 'TWITHKEYS':\n");
        String[] stringArray = new String[]{"-o", string + ".sql", "-td", "", "-t", "t1", "tWithKeys"};
        this.go(string, stringArray);
    }

    private void lookSix(String string) throws Exception {
        this.printAsHeader("\nDumping DDL w/ invalid url, and writing\nerror to the log:\n");
        new dblook(new String[]{"-o", string + ".sql", "-d", string});
    }

    private void lookSeven(String string) throws Exception {
        this.printAsHeader("\nDumping DDL for all objects with schema\n'\"Quoted\"Schema\"':\n");
        String[] stringArray = new String[]{"-o", string + ".sql", "-td", "", "-z", "\"\"Quoted\"Schema\"\""};
        this.go(string, stringArray);
    }

    private void go(String string, String[] stringArray) {
        jdbcProtocol = "jdbc:derby:";
        String string2 = jdbcProtocol + dbPath + separator + string + ";user=app;password=apppw";
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = "-d";
        stringArray2[1] = string2;
        for (int i = 2; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i - 2];
        }
        try {
            new dblook(stringArray2);
        }
        catch (Exception exception) {
            System.out.println("FAILED: to run dblook: ");
            exception.printStackTrace(System.out);
        }
    }

    private void runMessageCheckTest(String string) throws Exception {
        System.out.println("\n************\nMsg Test 1\n************\n");
        this.lookOne(string);
        this.dumpFileToSysOut(string + ".sql");
        this.dumpFileToSysOut("dblook.log");
        System.out.println("\n************\nMsg Test 2\n************\n");
        this.go(string, new String[]{"-t", "t1", "-z", "bar", "-o", string + ".sql"});
        this.dumpFileToSysOut(string + ".sql");
        this.dumpFileToSysOut("dblook.log");
        System.out.println("\n************\nMsg Test 3\n************\n");
        try {
            new dblook(new String[]{"-verbose"});
        }
        catch (Exception exception) {
            System.out.println("FAILED: to run dblook: ");
            exception.printStackTrace(System.out);
        }
        System.out.println("\n************\nMsg Test 4\n************\n");
        this.go(string, new String[]{"-td", " #"});
        System.out.println("\n************\nMsg Test 5\n************\n");
        Object object = new File(dbPath + separator + string).getAbsolutePath();
        try {
            Connection connection = DriverManager.getConnection("jdbc:derby:" + (String)object + ";shutdown=true,user=app;password=apppw");
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        object = (String)object + separator + "jar";
        this.deleteFile(new File((String)object));
        this.go(string, new String[]{"-verbose", "-o", string + ".sql"});
        this.dumpFileToSysOut("dblook.log");
        try {
            this.deleteFile(new File(string + ".sql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSysCatalogs(String string) throws Exception {
        Object object;
        System.out.println("\nDumping system tables for '" + string + "'\n");
        dblook_test.writeOut("\n----------------=================---------------");
        dblook_test.writeOut("System Tables for: " + string);
        dblook_test.writeOut("----------------=================---------------\n");
        Connection connection = DriverManager.getConnection("jdbc:derby:" + string + ";user=app;password=apppw");
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.executeUpdate("SET SCHEMA SYS");
        try (ResultSet resultSet = null;){
            resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.database.collation')");
            resultSet.next();
            object = resultSet.getString(1);
            if (object == null || !((String)object).equals(expectedCollation)) {
                throw new SQLException("Collation doesn't match with the expected type " + expectedCollation);
            }
        }
        object = this.loadIdMappings(statement);
        dblook_test.writeOut("\n========== SYSALIASES ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.sysaliases.* from sys.sysaliases");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSCHECKS ==========\n");
        resultSet = statement.executeQuery("select c.schemaid, ck.* from sys.syschecks ck, sys.sysconstraints c where ck.constraintid = c.constraintid");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSCOLUMNS ==========\n");
        dblook_test.writeOut("--- Columns for Tables ---");
        resultSet = statement.executeQuery("select t.schemaid, c.* from sys.syscolumns c, sys.systables t where c.referenceid = t.tableid");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n--- Columns for Statements ---");
        resultSet = statement.executeQuery("select s.schemaid, c.* from sys.syscolumns c, sys.sysstatements s where c.referenceid = s.stmtid");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSCONGLOMERATES ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.sysconglomerates.* from sys.sysconglomerates");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSCONSTRAINTS ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.sysconstraints.* from sys.sysconstraints");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSDEPENDS ==========\n");
        resultSet = statement.executeQuery("select dependentid, sys.sysdepends.* from sys.sysdepends");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, connection);
        dblook_test.writeOut("\n========== SYSFILES ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.sysfiles.* from sys.sysfiles");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSFOREIGNKEYS ==========\n");
        resultSet = statement.executeQuery("select c.schemaid, fk.* from sys.sysforeignkeys fk, sys.sysconstraints c where fk.constraintid = c.constraintid");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSKEYS ==========\n");
        resultSet = statement.executeQuery("select c.schemaid, k.* from sys.syskeys k, sys.sysconstraints c where k.constraintid = c.constraintid");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSSCHEMAS ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.sysschemas.* from sys.sysschemas");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSSTATEMENTS ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.sysstatements.* from sys.sysstatements");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSTABLES ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.systables.* from sys.systables");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSTRIGGERS ==========\n");
        resultSet = statement.executeQuery("select schemaid, sys.systriggers.* from sys.systriggers");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSVIEWS ==========\n");
        resultSet = statement.executeQuery("select compilationschemaid, sys.sysviews.* from sys.sysviews");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        dblook_test.writeOut("\n========== SYSROLES ==========\n");
        resultSet = statement.executeQuery("select 'dummyFirstCol', roleid || '_' || grantee || '_' || grantor as rgd, roleid, grantee, grantor, withadminoption, isdef from sys.sysroles");
        this.dumpResultSet(resultSet, (HashMap<String, String>)object, null);
        statement.close();
        resultSet.close();
        connection.commit();
        connection.close();
    }

    private boolean isIgnorableSchema(String string) {
        boolean bl = false;
        int n = ignorableSchemaNames.length - 1;
        while (n >= 0 && !(bl = ignorableSchemaNames[n--].equalsIgnoreCase(string))) {
        }
        return bl;
    }

    private void dumpResultSet(ResultSet resultSet, HashMap<String, String> hashMap, Connection connection) throws Exception {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap<String, ArrayList<String>> treeMap = new TreeMap<String, ArrayList<String>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                String string2 = resultSet.getString(i);
                object = hashMap.get(string2);
                if (string.indexOf("SCHEMAID") != -1 && object != null && (((String)object).indexOf("SYS") != -1 || this.isIgnorableSchema((String)object))) {
                    arrayList = null;
                    break;
                }
                if (string.equals("JAVACLASSNAME") && string2 != null && string2.indexOf("org.apache.derby") != -1 && string2.indexOf(".util.") == -1) {
                    arrayList = null;
                    break;
                }
                if (i == 1) continue;
                String string3 = string.equals("RGD") ? string2 : this.dumpColumnData(string, string2, (String)object, arrayList);
                if (string.equals("DEPENDENTID")) {
                    String string4 = this.getDependsData(resultSet, connection, hashMap);
                    if (string4.indexOf("SYS_OBJECT") != -1) {
                        arrayList = null;
                        break;
                    }
                    stringBuffer.append(string4);
                    arrayList.add(string4);
                }
                if (string3 != null) {
                    stringBuffer.append(string3);
                }
                if (!string.equals("STMTNAME") || string2.indexOf("TRIGGERACTN") == -1) continue;
                stringBuffer.append(resultSet.getString(6));
            }
            if (arrayList != null) {
                if (arrayList2.contains(stringBuffer.toString())) {
                    this.handleDuplicateRow(arrayList, null, treeMap);
                } else {
                    ArrayList<String> arrayList3 = treeMap.put(stringBuffer.toString(), arrayList);
                    if (arrayList3 != null) {
                        arrayList2.add(stringBuffer.toString());
                        treeMap.remove(stringBuffer.toString());
                        this.handleDuplicateRow(arrayList, arrayList3, treeMap);
                    }
                }
            }
            stringBuffer = new StringBuffer();
            arrayList = new ArrayList();
        }
        Set set = treeMap.keySet();
        for (String string2 : set) {
            object = (ArrayList)treeMap.get(string2);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                dblook_test.writeOut((String)((ArrayList)object).get(i));
            }
            dblook_test.writeOut("----");
        }
        treeMap = null;
        resultSet.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String dumpColumnData(String string, String string2, String string3, ArrayList<String> arrayList) {
        if (string3 == null) {
            if (string.equals("CONGLOMERATENUMBER") || string.equals("GENERATIONID")) {
                arrayList.add("<systemnumber>");
                return null;
            }
            if (string.equals("AUTOINCREMENTVALUE")) {
                arrayList.add("<autoincval>");
                return null;
            }
            if (string.equals("VALID")) {
                arrayList.add("<validityflag>");
                return null;
            }
            if (string2 == null) {
                arrayList.add(string2);
                return null;
            }
            if (this.looksLikeSysGenName(string2)) {
                if (this.columnHoldsObjectName(string)) {
                    arrayList.add("<systemname>");
                    return null;
                }
                arrayList.add(string2);
                return string2;
            }
            if (this.looksLikeSysGenId(string2)) {
                arrayList.add("<systemid>");
                return null;
            }
            arrayList.add(string2);
            if (!this.columnHoldsObjectName(string)) return null;
            return string2;
        }
        if (!this.isSystemGenerated(string3)) {
            arrayList.add(string3);
            return string3;
        }
        arrayList.add("<systemname>");
        return null;
    }

    private void handleDuplicateRow(ArrayList<String> arrayList, ArrayList<String> arrayList2, TreeMap<String, ArrayList<String>> treeMap) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i));
        }
        ArrayList<String> arrayList3 = treeMap.put(stringBuffer.toString(), arrayList);
        if (arrayList3 != null) {
            treeMap.put(stringBuffer.toString() + duplicateCounter++, arrayList);
        }
        if (arrayList2 != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < arrayList2.size(); ++i) {
                stringBuffer2.append(arrayList2.get(i));
            }
            arrayList3 = treeMap.put(stringBuffer2.toString(), arrayList2);
            if (arrayList3 != null) {
                treeMap.put(stringBuffer2.toString() + duplicateCounter++, arrayList2);
            }
        }
    }

    private void createDBFromDDL(String string, String string2) throws Exception {
        System.out.println("\n\nCreating database '" + string + "' from ddl script '" + string2 + "'");
        Connection connection = DriverManager.getConnection("jdbc:derby:" + string + ";create=true;user=app;password=apppw" + territoryBased);
        dblook_test.runDDL(connection, string2);
        connection.close();
    }

    static void runDDL(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.indexOf("--") != 0 && string2.trim().length() != 0) {
                if (string2.charAt(string2.length() - 1) == '#' || string2.charAt(string2.length() - 1) == ';') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                try {
                    statement.execute(string2);
                }
                catch (Exception exception) {
                    System.out.println("FAILED: to execute cmd from DDL script:\n" + string2 + "\n");
                    System.out.println(exception.getMessage());
                }
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        statement.close();
    }

    private static void writeOut(String string) {
        System.out.println(string);
    }

    private HashMap<String, String> loadIdMappings(Statement statement) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = statement.executeQuery("select tableid, tablename from sys.systables");
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        resultSet = statement.executeQuery("select schemaid, schemaname from sys.sysschemas");
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        resultSet = statement.executeQuery("select constraintid, constraintname from sys.sysconstraints");
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        return hashMap;
    }

    private String getDependsData(ResultSet resultSet, Connection connection, HashMap hashMap) throws Exception {
        DependableFinder dependableFinder = (DependableFinder)resultSet.getObject(3);
        DependableFinder dependableFinder2 = (DependableFinder)resultSet.getObject(5);
        String string = dependableFinder.getSQLObjectType();
        String string2 = dependableFinder2.getSQLObjectType();
        Statement statement = connection.createStatement();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHiddenDependsData(string, resultSet.getString(2), statement, hashMap));
        stringBuffer.append(" -> ");
        stringBuffer.append(this.getHiddenDependsData(string2, resultSet.getString(4), statement, hashMap));
        return stringBuffer.toString();
    }

    private String getHiddenDependsData(String string, String string2, Statement statement, HashMap hashMap) throws Exception {
        ResultSet resultSet = null;
        if (string.equals("Constraint")) {
            resultSet = statement.executeQuery("select schemaid, constraintname from sys.sysconstraints where constraintid = '" + string2 + "'");
        } else if (string.equals("StoredPreparedStatement")) {
            resultSet = statement.executeQuery("select schemaid, stmtname from sys.sysstatements where stmtid = '" + string2 + "'");
        } else if (string.equals("Trigger")) {
            resultSet = statement.executeQuery("select schemaid, triggername from sys.systriggers where triggerid = '" + string2 + "'");
        } else if (string.equals("View") || string.equals("Table") || string.equals("ColumnsInTable")) {
            resultSet = statement.executeQuery("select schemaid, tablename from sys.systables where tableid = '" + string2 + "'");
        } else if (string.equals("Conglomerate")) {
            resultSet = statement.executeQuery("select schemaid, conglomeratename from sys.sysconglomerates where conglomerateid = '" + string2 + "'");
        } else {
            System.out.println("WARNING: Unexpected dependent type: " + string);
            return "";
        }
        if (resultSet.next()) {
            String string3 = (String)hashMap.get(resultSet.getString(1));
            if (this.isIgnorableSchema(string3)) {
                return "SYS_OBJECT";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<");
            stringBuffer.append(string);
            stringBuffer.append(">");
            stringBuffer.append(string3);
            stringBuffer.append(".");
            if (this.isSystemGenerated(resultSet.getString(2))) {
                stringBuffer.append("<sysname>");
            } else {
                stringBuffer.append(resultSet.getString(2));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private void deleteDB(String string) throws Exception {
        Object object;
        String string2 = new File(dbPath + separator + string).getAbsolutePath();
        try {
            object = DriverManager.getConnection("jdbc:derby:" + string2 + ";shutdown=true;user=app;password=apppw");
            object.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        object = new File(string2);
        if (!((File)object).exists()) {
            return;
        }
        File[] fileArray = ((File)object).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.deleteFile(fileArray[i]);
        }
        if (!((File)object).delete()) {
            System.out.println("ERROR: deleting: " + ((File)object).getName());
        }
        this.deleteFile(new File(System.getProperty("user.dir") + separator + "CSJARS"));
        System.out.println("Database '" + string + "' deleted.");
    }

    private void deleteFile(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        if (file.delete()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.deleteFile(fileArray[i]);
            }
        }
        if (!file.delete()) {
            System.out.println("ERROR: deleting: " + file.getName());
        }
    }

    protected static void renameDbLookLog(String string) {
        File file = new File("dblook.log");
        if (file.exists()) {
            int n = 0;
            String string2 = string + n + ".log";
            File file2 = new File(string2);
            while (file2.exists()) {
                string2 = string + ++n + ".log";
                file2 = new File(string2);
            }
            if (!file.renameTo(file2)) {
                System.out.println("Failed to rename dblook.org to " + string2);
            }
        }
    }

    private void dumpFileToSysOut(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                System.out.println("File " + string + " was NOT empty.  Contents are:\n############## Begin File Contents ################\n");
                do {
                    System.out.println(string2);
                } while ((string2 = bufferedReader.readLine()) != null);
                System.out.println("############## End File Contents ################");
            } else {
                System.out.println("File " + string + " was empty.");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("FAILED: to dump file '" + string + "'");
            exception.printStackTrace(System.out);
        }
    }

    private boolean isSystemGenerated(String string) {
        return this.looksLikeSysGenName(string) || this.looksLikeSysGenId(string);
    }

    private boolean looksLikeSysGenName(String string) {
        return string != null && (string.trim().indexOf("SQL") == 0 || string.trim().indexOf("TRIGGERACTN_") == 0 && string.indexOf("-") != -1);
    }

    private boolean looksLikeSysGenId(String string) {
        return string != null && string.indexOf("-") != -1;
    }

    private boolean columnHoldsObjectName(String string) {
        return string.equals("ALIAS") || string.indexOf("NAME") != -1;
    }

    private void printAsHeader(String string) {
        dblook_test.writeOut("--\n*******************************************");
        dblook_test.writeOut(string);
        dblook_test.writeOut("*******************************************\n");
    }

    private void testDerby6387() throws Exception {
        this.createTestDatabase("dblook_makeDB_derby6387.sql");
        this.lookOne(testDBName);
        this.dumpFileToSysOut("dblook.log");
        this.dumpFileToSysOut(testDBName + ".sql");
    }

    static {
        duplicateCounter = 0;
        sysNameCount = 0;
        territoryBased = "";
        expectedCollation = "UCS_BASIC";
        ignorableSchemaNames = new String[]{"SYSIBM", "SYS", "SYSVISUAL", "SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_ADMIN", "SYSCS_DIAG", "SYSCS_UTIL", "SQLJ"};
    }
}

