/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.Statistics;

class MaxLongGauge {
    private final int statId;
    private final Statistics stats;
    private final AtomicLong max;

    public MaxLongGauge(int statId, Statistics stats) {
        this.statId = statId;
        this.stats = stats;
        this.max = new AtomicLong();
    }

    public void recordMax(long currentValue) {
        boolean done = false;
        while (!done) {
            long maxValue = this.max.get();
            if (currentValue <= maxValue) {
                done = true;
                continue;
            }
            done = this.max.compareAndSet(maxValue, currentValue);
            if (!done) continue;
            this.stats.incLong(this.statId, currentValue - maxValue);
        }
    }
}

