/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

public class OffHeapClearRequired {
    private static final ThreadLocal<Object> clearNeedsToCheckForOffHeap = new ThreadLocal();

    public static boolean doesClearNeedToCheckForOffHeap() {
        return clearNeedsToCheckForOffHeap.get() != null;
    }

    public static void doWithOffHeapClear(Runnable r) {
        clearNeedsToCheckForOffHeap.set(Boolean.TRUE);
        try {
            r.run();
        }
        finally {
            clearNeedsToCheckForOffHeap.remove();
        }
    }
}

