/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hertzbeat.common.util.Base64Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AesUtil {
    private static final Logger log = LoggerFactory.getLogger(AesUtil.class);
    public static final String DEFAULT_ENCODE_RULES = "tomSun28HaHaHaHa";
    private static final String ALGORITHM_STR = "AES/CBC/PKCS5Padding";
    private static final String AES = "AES";
    private static String secretKey = "tomSun28HaHaHaHa";

    private AesUtil() {
    }

    public static void setDefaultSecretKey(String secretKeyNow) {
        secretKey = secretKeyNow;
    }

    public static String getDefaultSecretKey() {
        return secretKey;
    }

    public static String aesEncode(String content) {
        return AesUtil.aesEncode(content, secretKey);
    }

    public static String aesDecode(String content) {
        return AesUtil.aesDecode(content, secretKey);
    }

    public static boolean isCiphertext(String text) {
        return AesUtil.isCiphertext(text, secretKey);
    }

    public static String aesEncode(String content, String encryptKey) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(encryptKey.getBytes(StandardCharsets.UTF_8), AES);
            Cipher cipher = Cipher.getInstance(ALGORITHM_STR);
            cipher.init(1, (Key)keySpec, new IvParameterSpec(encryptKey.getBytes(StandardCharsets.UTF_8)));
            byte[] byteEncode = content.getBytes(StandardCharsets.UTF_8);
            byte[] byteAes = cipher.doFinal(byteEncode);
            return Base64.getEncoder().encodeToString(byteAes);
        }
        catch (Exception e) {
            log.error("aes encode content error: {}", (Object)e.getMessage(), (Object)e);
            return content;
        }
    }

    public static String aesDecode(String content, String decryptKey) {
        try {
            byte[] byteDecode = AesUtil.getBytes(content, decryptKey);
            return new String(byteDecode, StandardCharsets.UTF_8);
        }
        catch (BadPaddingException e) {
            if (!DEFAULT_ENCODE_RULES.equals(decryptKey)) {
                log.warn("There has default encode secret encode content, try to decode with default secret key");
                return AesUtil.aesDecode(content, DEFAULT_ENCODE_RULES);
            }
            log.error("aes decode content error: {}, please config right common secret key", (Object)e.getMessage());
            return content;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("no such algorithm: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (IllegalBlockSizeException e) {
            log.error("illegal block size: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (NullPointerException e) {
            log.error("null point exception: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            log.error("aes decode error: {}", (Object)e.getMessage(), (Object)e);
        }
        return content;
    }

    private static byte[] getBytes(String content, String decryptKey) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(decryptKey.getBytes(StandardCharsets.UTF_8), AES);
        Cipher cipher = Cipher.getInstance(ALGORITHM_STR);
        cipher.init(2, (Key)keySpec, new IvParameterSpec(decryptKey.getBytes(StandardCharsets.UTF_8)));
        byte[] bytesContent = Base64.getDecoder().decode(content);
        return cipher.doFinal(bytesContent);
    }

    public static boolean isCiphertext(String text, String decryptKey) {
        if (Base64Util.isBase64(text)) {
            try {
                byte[] byteDecode = AesUtil.getBytes(text, decryptKey);
                return byteDecode != null;
            }
            catch (Exception e) {
                log.warn("isCiphertext method error: {}", (Object)e.getMessage());
                return false;
            }
        }
        return false;
    }
}

