/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.push.service.impl;

import java.io.InputStream;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hertzbeat.collector.collect.prometheus.parser.MetricFamily;
import org.apache.hertzbeat.collector.collect.prometheus.parser.OnlineParser;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.util.SnowFlakeIdGenerator;
import org.apache.hertzbeat.push.dao.PushMonitorDao;
import org.apache.hertzbeat.push.service.PushGatewayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushGatewayServiceImpl
implements PushGatewayService {
    private static final Logger log = LoggerFactory.getLogger(PushGatewayServiceImpl.class);
    private final CommonDataQueue commonDataQueue;
    private final PushMonitorDao pushMonitorDao;
    private final Map<String, Long> jobInstanceMap;

    public PushGatewayServiceImpl(CommonDataQueue commonDataQueue, PushMonitorDao pushMonitorDao) {
        this.commonDataQueue = commonDataQueue;
        this.pushMonitorDao = pushMonitorDao;
        this.jobInstanceMap = new ConcurrentHashMap<String, Long>();
        pushMonitorDao.findMonitorsByType((byte)1).forEach(monitor -> this.jobInstanceMap.put(monitor.getApp() + "_" + monitor.getName(), monitor.getId()));
    }

    @Override
    public boolean pushPrometheusMetrics(InputStream inputStream, String job, String instance) {
        try {
            long curTime = Instant.now().toEpochMilli();
            Map metricFamilyMap = OnlineParser.parseMetrics((InputStream)inputStream);
            if (metricFamilyMap == null) {
                log.error("parse prometheus metrics is null, job: {}, instance: {}", (Object)job, (Object)instance);
                return false;
            }
            long id = 0L;
            if (job != null && instance != null) {
                id = this.jobInstanceMap.computeIfAbsent(job + "_" + instance, key -> {
                    log.info("auto create monitor by prometheus push, job: {}, instance: {}", (Object)job, (Object)instance);
                    long monitorId = SnowFlakeIdGenerator.generateId();
                    Monitor monitor = Monitor.builder().id(Long.valueOf(monitorId)).app(job).name(instance).host(instance).type((byte)1).status((byte)1).build();
                    this.pushMonitorDao.save(monitor);
                    return monitorId;
                });
            }
            for (Map.Entry entry : metricFamilyMap.entrySet()) {
                CollectRep.MetricsData.Builder builder = CollectRep.MetricsData.newBuilder();
                builder.setId(id);
                builder.setApp(job);
                builder.setTime(curTime);
                String metricsName = (String)entry.getKey();
                builder.setMetrics(metricsName);
                MetricFamily metricFamily = (MetricFamily)entry.getValue();
                if (metricFamily.getMetricList().isEmpty()) continue;
                LinkedList metricsFields = new LinkedList();
                for (int index = 0; index < metricFamily.getMetricList().size(); ++index) {
                    MetricFamily.Metric metric = (MetricFamily.Metric)metricFamily.getMetricList().get(index);
                    if (index == 0) {
                        metric.getLabels().forEach(label -> {
                            metricsFields.add(label.getName());
                            builder.addField(CollectRep.Field.newBuilder().setName(label.getName()).setType(1).setLabel(true).build());
                        });
                        builder.addField(CollectRep.Field.newBuilder().setName("value").setType(0).setLabel(false).build());
                    }
                    Map<String, String> labelMap = metric.getLabels().stream().collect(Collectors.toMap(MetricFamily.Label::getName, MetricFamily.Label::getValue));
                    CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
                    for (String field : metricsFields) {
                        String fieldValue = labelMap.get(field);
                        valueRowBuilder.addColumn(fieldValue == null ? "&nbsp;" : fieldValue);
                    }
                    valueRowBuilder.addColumn(String.valueOf(metric.getValue()));
                    builder.addValueRow(valueRowBuilder.build());
                }
                this.commonDataQueue.sendMetricsData(builder.build());
            }
            return true;
        }
        catch (Exception e) {
            log.error("push prometheus metrics error", (Throwable)e);
            return false;
        }
    }
}

