/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory.method;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;
import org.datanucleus.util.Localiser;

public class TemporalMonthMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        if (invokedValue == null && expr.getArguments() != null) {
            List<Expression> argExprs = expr.getArguments();
            if (argExprs.size() > 1) {
                throw new NucleusUserException("Incorrect number of arguments to MONTH");
            }
            Expression argExpr = argExprs.get(0);
            invokedValue = eval.getValueForExpression(argExpr);
        }
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!(invokedValue instanceof Date)) {
            throw new NucleusException(Localiser.msg("021011", expr.getOperation(), invokedValue.getClass().getName()));
        }
        if (invokedValue instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)invokedValue);
            return Integer.valueOf(cal.get(2)) + 1;
        }
        if (invokedValue instanceof Calendar) {
            return Integer.valueOf(((Calendar)invokedValue).get(2)) + 1;
        }
        if (invokedValue instanceof LocalDate) {
            return ((LocalDate)invokedValue).getMonthValue();
        }
        if (invokedValue instanceof LocalDateTime) {
            return ((LocalDateTime)invokedValue).getMonthValue();
        }
        throw new NucleusUserException("We do not currently support MONTH() with argument of type " + invokedValue.getClass().getName());
    }
}

