/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.containers;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.datanucleus.store.types.containers.ElementContainerAdapter;

public class OptionalAdapter
extends ElementContainerAdapter<Optional> {
    public OptionalAdapter(Optional optional) {
        super(optional);
    }

    @Override
    public void clear() {
        this.setContainer(Optional.empty());
    }

    @Override
    public Iterator<Object> iterator() {
        return ((Optional)this.container).isPresent() ? new OptionalIterator(((Optional)this.container).get()) : Collections.emptyIterator();
    }

    @Override
    public void add(Object newElement) {
        this.setContainer(Optional.ofNullable(newElement));
    }

    @Override
    public void remove(Object element) {
        this.setContainer(Optional.empty());
    }

    class OptionalIterator
    implements Iterator<Object> {
        private Object value;
        private boolean hasNext = true;

        public OptionalIterator(Object value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Object next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.value;
            }
            throw new NoSuchElementException();
        }
    }
}

